         .XLIST
;******************************************************************************
;
;      MACROS
;
;******************************************************************************

BEGINCOM MACRO SEGNAM
         .SALL
         PAGE  57,132
SEGNAM   SEGMENT 'CODE'
         ASSUME CS:SEGNAM,DS:SEGNAM,ES:SEGNAM
         ORG   0100H
O0O0O0O0:
         ENDM


ENDCOM   MACRO SEGNAM
SEGNAM   ENDS
         END   O0O0O0O0
         ENDM


@SVC MACRO CALL_NUM, PARM
;;GENERATES AN 'INT CALL_NUM', WITH PARM IN AH
         IFNB <PARM>
         MOV   AH,PARM
         ENDIF
         INT   CALL_NUM
         ENDM
;
;
;
@DOS MACRO FUNCTION,PARM
;;GENERATES A DOS FUNCTION CALL WITH PARM IN AL
         IFNB <PARM>
         MOV   AL,PARM
         ENDIF
         @SVC  21H,FUNCTION
         ENDM
;
; SEND A MESSAGE
;
@MSG MACRO TXT
         LOCAL TXTSTR
         LOCAL NSI
         IFNB <TXT>
         JMP   SHORT NSI
TXTSTR   DB    TXT,13,10,'$'
NSI:     PUSH  DX                  ;SAVE REG
         MOV   DX,OFFSET TXTSTR    ;POINT TO STRING
         @DOS  9                   ;DISPLAY IT
         POP   DX                  ;RESTORE REG
         ENDIF
         ENDM
;
;
;
@DEX MACRO FUNCTION,PARM
;;GENERATES A DOS EXTENSION FUNCTION CALL WITH PARM IN AL VIA INT 15H
         IFNB <PARM>
         MOV   AL,PARM
         ENDIF
         @SVC  15H,FUNCTION
         ENDM
;******************************************************************************
;
;  SPECIAL KEYBOARD CHARACTER EQUATES
;
;******************************************************************************
KEYEQ    MACRO
;
;      ASCII CONTROL CODES
;
$NUL     EQU   00H                 ;
$SOH     EQU   01H                 ;^A
$STX     EQU   02H                 ;^B
$ETX     EQU   03H                 ;^C
$EOT     EQU   04H                 ;^D
$ENQ     EQU   05H                 ;^E
$ACK     EQU   06H                 ;^F
$BEL     EQU   07H                 ;BEEP
$BS      EQU   08H                 ;^H
$HT      EQU   09H                 ;^I
$LF      EQU   0AH                 ;LINE FEED
$VT      EQU   0BH                 ;^K
$FF      EQU   0CH                 ;^L
$CR      EQU   0DH                 ;CARRIAGE RETURN
$SO      EQU   0EH                 ;^N
$SI      EQU   0FH                 ;^O
$DLE     EQU   10H                 ;^P
$DC1     EQU   11H                 ;DEV CTL 1 = ^Q
$DC2     EQU   12H                 ;DEV CTL 2 = ^R
$DC3     EQU   13H                 ;DEV CTL 3 = ^S
$DC4     EQU   14H                 ;DEV CTL 4 = ^T
$NAK     EQU   15H                 ;^U
$SYN     EQU   16H                 ;^V
$ETB     EQU   17H                 ;^W
$CAN     EQU   18H                 ;^X
$EM      EQU   19H                 ;^Y
$SUB     EQU   1AH                 ;^Z
$ESC     EQU   1BH                 ;
$FS      EQU   1CH                 ;CURSOR RIGHT
$GS      EQU   1DH                 ;CURSOR LEFT
$RS      EQU   1EH                 ;CURSOR UP
$US      EQU   1FH                 ;CURSOR DOWM
;
; NUMERIC PAD KEYS
;
$HOME    EQU   71
$CSRUP   EQU   72
$PGUP    EQU   73
$CSRL    EQU   75
$CSRR    EQU   77
$END     EQU   79
$CSRDN   EQU   80
$PGDN    EQU   81
$INS     EQU   82
$DEL     EQU   83
;
; PROGRAM FUNCTION KEYS
;
$PF01    EQU   3BH                 ;STANDARD PF KEY
$PF02    EQU   3CH                 ;STANDARD PF KEY
$PF03    EQU   3DH                 ;STANDARD PF KEY
$PF04    EQU   3EH                 ;STANDARD PF KEY
$PF05    EQU   3FH                 ;STANDARD PF KEY
$PF06    EQU   40H                 ;STANDARD PF KEY
$PF07    EQU   41H                 ;STANDARD PF KEY
$PF08    EQU   42H                 ;STANDARD PF KEY
$PF09    EQU   43H                 ;STANDARD PF KEY
$PF10    EQU   44H                 ;STANDARD PF KEY
;
; SHIFTED PROGRAM FUNCTION KEYS
;
$SPF01   EQU   54H                 ;STANDARD PF KEY
$SPF02   EQU   55H                 ;STANDARD PF KEY
$SPF03   EQU   56H                 ;STANDARD PF KEY
$SPF04   EQU   57H                 ;STANDARD PF KEY
$SPF05   EQU   58H                 ;STANDARD PF KEY
$SPF06   EQU   59H                 ;STANDARD PF KEY
$SPF07   EQU   5AH                 ;STANDARD PF KEY
$SPF08   EQU   5BH                 ;STANDARD PF KEY
$SPF09   EQU   5CH                 ;STANDARD PF KEY
$SPF10   EQU   5DH                 ;STANDARD PF KEY
;
; CONTROL PROGRAM FUNCTION KEYS
;
$CPF01   EQU   5EH                 ;STANDARD PF KEY
$CPF02   EQU   5FH                 ;STANDARD PF KEY
$CPF03   EQU   60H                 ;STANDARD PF KEY
$CPF04   EQU   61H                 ;STANDARD PF KEY
$CPF05   EQU   62H                 ;STANDARD PF KEY
$CPF06   EQU   63H                 ;STANDARD PF KEY
$CPF07   EQU   64H                 ;STANDARD PF KEY
$CPF08   EQU   65H                 ;STANDARD PF KEY
$CPF09   EQU   66H                 ;STANDARD PF KEY
$CPF10   EQU   67H                 ;STANDARD PF KEY
;
; ALTERNATE PROGRAM FUNCTION KEYS
;
$APF01   EQU   68H                 ;STANDARD PF KEY
$APF02   EQU   69H                 ;STANDARD PF KEY
$APF03   EQU   6AH                 ;STANDARD PF KEY
$APF04   EQU   6BH                 ;STANDARD PF KEY
$APF05   EQU   6CH                 ;STANDARD PF KEY
$APF06   EQU   6DH                 ;STANDARD PF KEY
$APF07   EQU   6EH                 ;STANDARD PF KEY
$APF08   EQU   6FH                 ;STANDARD PF KEY
$APF09   EQU   70H                 ;STANDARD PF KEY
$APF10   EQU   71H                 ;STANDARD PF KEY
         ENDM
;******************************************************************************
;
;  COMM CARD REGISTER EQUATES EQUATES
;
;******************************************************************************
COMEQ    MACRO
;
;      INS8250 ACE REGISTERS FOR COMM PORT 1
;
THRCOM1  EQU    3F8H               ;TRANS HOLDING REGISTER (WRITE)
RBRCOM1  EQU    3F8H               ;RECEIVER BUFFER REGISTER (READ)
IERCOM1  EQU    3F9H               ;INTERRUPT ENABLE REGISTER
LCRCOM1  EQU    3FBH               ;LINE CONTROL REGISTER.
                                   ;BIT 7 OF LCR IS "DLAB".  DLAB MUST
                                   ;BE ZERO TO ACCESS THR, RBR, IER.
MCRCOM1  EQU    3FCH               ;MODEM CONTROL REGISTER
LSRCOM1  EQU    3FDH               ;LINE STATUS REGISTER
MSRCOM1  EQU    3FEH               ;MODEM STATUS REGISTER
;
;      INS8250 ACE REGISTERS FOR COMM PORT 2
;
THRCOM2  EQU    2F8H               ;TRANS HOLDING REGISTER (WRITE)
RBRCOM2  EQU    2F8H               ;RECEIVER BUFFER REGISTER (READ)
IERCOM2  EQU    2F9H               ;INTERRUPT ENABLE REGISTER
LCRCOM2  EQU    2FBH               ;LINE CONTROL REGISTER.
                                   ;BIT 7 OF LCR IS "DLAB".  DLAB MUST
                                   ;BE ZERO TO ACCESS THR, RBR, IER.
MCRCOM2  EQU    2FCH               ;MODEM CONTROL REGISTER
LSRCOM2  EQU    2FDH               ;LINE STATUS REGISTER
MSRCOM2  EQU    2FEH               ;MODEM STATUS REGISTER
         ENDM



;******************************************************************************
;
;  BIOS LOW CORE AREA DEFINITIONS
;
;******************************************************************************
BIOSM    MACRO LSTCTL
         IFB   <LSTCTL>
         .XLIST
         ENDIF
         IFNB  <LSTCTL>
         .LIST
         ENDIF
BIOSMEM  SEGMENT AT 0040H

;
;  COMM CARD BASE ADDRESSES
;
RS232_BASE LABEL WORD              ;OFFICIAL IBM TAG
COM1BASE DW    ?                   ;COMM CARD BASE ADDRESSES
COM2BASE DW    ?
COM3BASE DW    ?
COM4BASE DW    ?
;
;  PRINTER CARD BASE ADDRESSES
;
PRINTER_BASE LABEL WORD            ;OFFICIAL IBM TAG
PRT1BASE DW    ?                   ;PRINTER CARD BASE ADDRESSES
PRT2BASE DW    ?
PRT3BASE DW    ?
PRT4BASE DW    ?

EQPFLAG  DW    ?                   ;INSTALLED EQUIPMENT FLAG
MFG_TST  DB    ?
MEMORY_SIZE    DW   ?              ;MEM SIZE IN K BYTES
MFG_ERR_FLAG   DW   ?              ;SCRATCHPAD FOR MFG ERROR CODES
;
;  KEYBOARD DATA AREAS
;
KB_FLAG        DB   ?              ;KEYBOARD FLAG BYTE 1
INS_STATE      EQU  80H            ;  INSERT IS ACTIVE
CAPS_STATE     EQU  40H            ;  CAPS LOCK IS ACTIVE
NUM_STATE      EQU  20H            ;  NUM LOCK IS ACTIVE
SCROLL_STATE   EQU  10H            ;  SCROLL LOCK IS ACTIVE
ALT_SHIFT      EQU  08H            ;  ALT SHIFT IS DEPRESSED
CTL_SHIFT      EQU  04H            ;  CTL SHIFT IS DEPRESSED
LEFT_SHIFT     EQU  02H            ;  LEFT SHIFT KEY IS DEPRESSED
RIGHT_SHIFT    EQU  01H            ;  RIGHT SHIFT KEY IS DEPRESSED

KB_FLAG_1      DB   ?              ;SECOND KEYBOARD STATUS BYTE

INS_SHIFT      EQU  80H            ;INSERT KEY IS DEPRESSED
CAPS_SHIFT     EQU  40H            ;CAPS LOCK KEY IS DEPRESSED
NUM_SHIFT      EQU  20H            ;NUM LOCK KEY IS DEPRESSED
SCROLL_SHIFT   EQU  10H            ;SCROLL LOCK KEY IS DEPRESSED
HOLD_STATE     EQU  08H            ;SUSPEND STATE HAS BEEN TOGGLED

ALT_INPUT      DB   ?              ;STORAGE FOR ALTERNATE KEYPAD ENTRY
BUFFER_HEAD    DW   ?              ;POINTER TO KB BUFFER START
BUFFER_TAIL    DW   ?              ;POINTER TO KB BUFFER END
KB_BUFFER      DW   16 DUP (?)     ;ROOM FOR 15 ENTRIES
KB_BUFFER_END  LABEL WORD
;
; HEAD = TAIL = EMPTY BUFFER

NUM_KEY        EQU  69             ;SCAN CODE FOR NUM LOCK KEY
SCROLL_KEY     EQU  70             ;SCROLL LOCK KEY
ALT_KEY        EQU  56             ;ALT KEY
CTL_KEY        EQU  29             ;CONTROL KEY
CAPS_KEY       EQU  58             ;CAPS LOCK KEY
LEFT_KEY       EQU  42             ;LEFT SHIFT KEY
RIGHT_KEY      EQU  54             ;RIGHT SHIFT KEY
INS_KEY        EQU  82             ;INSERT KEY
DEL_KEY        EQU  83             ;DELETE KEY

;
;  DISKETTE DATA AREAS
;
SEEK_STATUS    DB   ?              ;DRIVE RECALIBRATION STATUS
                                   ;BIT 3-0 = DRIVE 3-0 NEEDS RECAL BEFORE NEXT
                                   ;SEEK IF BIT = 0
INT_FLAG       EQU  80H            ;INTERRUPT OCCURANCE FLAG

MOTOR_STATUS   DB   ?              ;STATUS OF DRIVE MOTORS
                                   ;BIT 3-0 = DRIVE 3-0 MOTOR RUNNING
                                   ;BIT 7 = WRITE OPERATION, DELAY REQUIRED
MOTOR_COUNT    DB   ?              ;TIME OUT COUNT FOR DRIVE MOTOR TURN OFF
MOTOR_WAIT     EQU  37             ;2 SECOND DELAY (@ 18.2 INTS/SEC)
DISKETTE_STATUS DB  ?              ;RETURN CODE STATUS BYTE
TIME_OUT       EQU  80H            ;  ATTACHMENT FAILED TO RESPOND
BAD_SEEK       EQU  40H            ;  SEEK OPS FAILED
BAD_NEC        EQU  20H            ;  NEC CONTROLLER FAILED
BAD_CRC        EQU  10H            ;  CRC ERROR ON DISK READ
DMA_BOUNDARY   EQU  09H            ;  ATTEMPT DMA ACROSS 64K BOUNDARY
BAD_DMA        EQU  08H            ;  DMA OVERRUN
RECORD_NOT_FND EQU  04H            ;  REQUESTED SECTOR NOT FOUND
WRITE_PROTECT  EQU  03H            ;  WRITE ATTEMPT ON PROT DISK
BAD_ADDR_MARK  EQU  02H            ;  ADDRESS MARK NOT FOUND
BAD_CMD        EQU  01H            ;  BAD COMMAND PASSED TO DISKETTE I/O

NEC_STATUS     DB   7 DUP (?)      ;STATUS BYTES FROM NEC
;
; VIDEO DISPLAY DATA AREA
;
CRT_MODE       DB   ?              ;CURRENT CRT MODE
CRT_COLS       DW   ?              ;# COLUMNS ON CRT
CRT_LEN        DW   ?              ;LENGTH OF REGEN IN BYTES
CRT_START      DW   ?              ;STARTING ADDRESS IN REGEN BUFFER
CURSOR_POSN    DW   8 DUP (?)      ;CURSOR POSITION FOR EACH OF 8 PAGES
CURSOR_MODE    DW   ?              ;CURRENT CURSOR MODE SETTING
ACTIVE_PAGE    DB   ?              ;CURRENT ACTIVE PAGE
ADDR_6845      DW   ?              ;I/O ADDRESS BASE FOR DISPLAY CARD
CRT_MODE_SET   DB   ?              ;CURRENT SETTING OF THE 3X8 REGISTER
CRT_PALETTE    DB   ?              ;CURRENT PALETTE SETTING - COLOR CARD
;
;  POST DATA AREA
;
IO_ROM_INIT    DW   ?              ;POINTER TO OPTIONAL ROM INIT ROUTINE
IO_ROM_SEG     DW   ?              ;IO ROM SEGMENT
INTR_FLAG      DB   ?              ;FLAG TO INDICATE INTERRUPT OCCURED
;
;  TIMER DATA AREA
;
TIMER_LOW      DW   ?              ;LOW WORD OF TIMER COUNT
TIMER_HIGH     DW   ?              ;HI WORD OF TIMER COUNT
TIMER_OFL      DB   ?              ;TIMER HAS OVERFLOWED SINCE LAST READ
;
;  SYSTEM DATA AREA
;
BIOS_BREAK     DB   ?              ;BIT 7 = 1 IF BREAK KEY HIT
RESET_FLAG     DW   ?              ;= 1234H IF KB RESET IN PROGRESS
;
;  FIXED DISK DATA AREAS
;
               DW   ?
               DW   ?
;
;  PRINTER AND RS232 TIME OUT VALUES
;
PRINT_TIM_OUT  DB   4 DUP (?)      ;TIME OUT VALUES FOR EACH PRINTER
RS232_TIM_OUT  DB   4 DUP (?)      ;TIME OUT VALUES FOR EACH COMM CARD
;
;  ADDITIONAL KEYBOARD DATA AREA
;
BUFFER_START   DW   ?
BUFFER_END     DW   ?
BIOSMEM  ENDS
         .LIST
         ENDM
;
;  END OF MACRO LIBRARY
;
         .LIST
