/*

This is the C part of the fastest 80x86 Life program.  See LIFE32A.ASM.
This one runs in 320x200 mode.  Note: these require at least a 486.

Compile with WATCOM C:  wcl386 -otexan -5 life32.c life32a.asm

*/

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>

#define TBL_SIZE    0x040000
#define BUF_SIZE    ((320 * 200) / 8)

extern void CalcLife(void *buf1, void *buf2, void *table);
extern void GenTable(void *table);
extern void ResetMode(void);
extern void SetMode(void);

unsigned char Table[TBL_SIZE];
unsigned char Buf1[BUF_SIZE], Buf2[BUF_SIZE];

main()
{
    int i;

    printf("Generating tables . . .");
    fflush(stdout);
    GenTable(Table);
    memset(Buf1, 0, BUF_SIZE);
    memset(Buf2, 0, BUF_SIZE);
    srand(* (int *) 0x00046C);
    for(i = 0; i < BUF_SIZE; i++)
        Buf1[i] = rand();
    SetMode();
    while(!kbhit())
    {
        CalcLife(Buf1, Buf2, Table);
        memcpy((char *) 0x0A0000, Buf2, BUF_SIZE);
        CalcLife(Buf2, Buf1, Table);
        memcpy((char *) 0x0A0000, Buf1, BUF_SIZE);
    }
    ResetMode();
    return 0;
}
