#include "common.h"
#include "coords.h"
#include "crtdbg.h"
#include "d3derr.h"
#include "texture.h"
#include "video.h"
#include "profile.h"
#include "3d.h"


float CTHRESH = 0;
float ETHRESH = 0;

int ebuf[LBUFY][2];
int zbuf[LBUFY/2][LBUFX];
int miny,maxy;
float camscale= (LBUFX/2);
float camzscale= 65536*256*LBUFMINZ/camscale;

void traceedge(int x1,int y1,int x2,int y2, int mxy)
{
	
	int dy=y2-y1;
	if (dy==0) return;
	int *dst=(int*)ebuf;
	if (dy<0)
	{
		dst++;
		int t=x1;x1=x2;x2=t;dy=-dy;
		t=y1;y1=y2;y2=t;
	}
	if (y1>=mxy) return;
	if (y2<=0) return;
	x1<<=16;
	x2<<=16;
	int dx=x2-x1;
	int g=dx/dy;
	if (y2>mxy) y2=mxy;	
	if (y1<=0)
	{
		x1-=g*y1;
		y1=0;
	} else dst+=y1*2;
	if (y1<miny) miny=y1;
	if (y2>maxy) maxy=y2;
	if (x1<=0)
	{
leftclip:
		if (g<=0) 
		{
			// all 0
			while (y1<y2)  {*dst=0;dst+=2;y1++;}
			return;
		}
		// part 0
		while (y1<y2 && x1<=0) {*dst=0;dst+=2;y1++;x1+=g;}
	}
	if (x1>=(LBUFX<<16))
	{
rightclip:
		if (g>=0)
		{
			// all max
			while (y1<y2)  {*dst=LBUFX;dst+=2;y1++;}
			return;
		}
		// part max
		while (y1<y2 && x1>=(LBUFX<<16)) {*dst=LBUFX;dst+=2;y1++;x1+=g;}		
	}
	while (y1<y2)
	{
		if (x1<0) goto leftclip; else if (x1>(LBUFX<<16)) goto rightclip;
		*dst=x1>>16;
		dst+=2;
		y1++;
		x1+=g;
	}
}


float ADIST(CPoint *a, CPoint *b)
{
	return a->weight+b->weight+ (a->rp-b->rp).MagnitudeSq();
}

float EDIST(CPoint *a, CPoint *b)
{
	return a->weight+b->weight+ (a->rp-b->rp).MagnitudeSq();
}

void CObject::Draw1(CCam *cam)
{
	int c1;
	FVector rotc=cam->mAxes*(mCentre-cam->mCentre);
	FMatrix rota=cam->mAxes*mAxes;

	// remove points with children
	CPoint *prev=NULL;
	CPoint *v,*v2,*df=NULL;
	for (v=mAV;v;v=v2)
	{
		v2=v->next;
		if (v->child) // && prev)
		{			
			if (prev)  prev->next=v->next; else	mAV=v->next;			
			if (v->child==v) 
			{
				// delete this one
				mNumV2++;
				v->next=mV2F;
				mV2F=v;
			}

		}
		else
		{			
			prev=v;
		}
	}

	// transform the points. prev is now used as a tail pointer
	prev=mAV;
	for (v=mAV;v;v=v->next)
	{
		v->rp=(rota*v->p)+rotc;		

		// do we need to expand?
		if (v->weight>ETHRESH*fabs(v->rp.Z))
		{
			// reinstate polygons... arg!
			CFace *f=v->nextf;if (f)
			{
				while (f->next) f=f->next;
				f->next=mAF;
				mAF=v->nextf;				
			}

			// mark this one for deleting
			v->weight=-1;							
			// reinstate parents
			v->parent->next=v->parent2;
			v->parent2->next=mAV;				
			mAV=v->parent;			
			v->next2=df;df=v;
			mNumAV++;
		}
	}

	// transform the new points
	for (v=mAV;v!=prev;v=v->next)
	{
		v->rp=(rota*v->p)+rotc;
	}

	if (df)
	{
		// run over indices looking for dead pointers
		for (c1=0;c1<mNumV;c1++)
		{
			CPoint *p=mVIdx[c1];
			if (p->weight<0)
			{
				CPoint *p1=mV+c1;
				while (p1->child!=p && p1->child) p1=p1->child;
				mVIdx[c1]=p1;
			}
		}
		// delete the vertices marked for deletion (df)
		while (df)
		{
			df->parent->child=df->parent2->child=NULL;			
			df->child=df;
			df=df->next2;
		}
	}

	// perform lighting now...

}


void CObject::Draw2()
{
	CPoint *v;
	int c1;
	// add the points to the materials
	for (v=mAV;v;v=v->next)
	{
		for (c1=0;c1<v->nummat;c1++) 
		{
			v->nfo[c1].idx=v->nfo[c1].m->AddVertex(v->rp.X,v->rp.Y,v->rp.Z,v->nfo[c1].u,v->nfo[c1].v,v->nfo[c1].fixcol+v->nfo[c1].dyncol);
			v->nfo[c1].dyncol.Reset();
		}
	}

	// draw the active polygons
	CFace *f,*f2,*prevf=NULL;
	CPoint *p1,*p2,*p3;
	numec=0;
	for (f=mAF;f;f=f2)
	{
		f2=f->next;
		p1=*(f->v[0]);
		p2=*(f->v[1]);
		p3=*(f->v[2]);
		if (p1==p2 || p1==p3)
		{
			// oh dear, kill this polygon from point 1
			if (prevf) prevf->next=f->next; else mAF=f->next;
			f->next=p1->nextf;
			p1->nextf=f;
			
		}
		else if (p2==p3)
		{
			// oh dear, kill this polygon from point 2
			if (prevf) prevf->next=f->next; else mAF=f->next;
			f->next=p2->nextf;
			p2->nextf=f;
		}
		else
		{
			prevf=f;
			p1->nfo[f->mat[0]].m->AddTri(p1->nfo[f->mat[0]].idx,p2->nfo[f->mat[1]].idx,p3->nfo[f->mat[2]].idx);			
			
			// consider 3 edges for collapsing!
			if (numec<MAXEC-3 && mNumV2>3)
			{
				float w;
				w=ADIST(p1,p2);	if (w<CTHRESH*fabs(p1->rp.Z+p2->rp.Z))  {ecl[numec].a=p1;ecl[numec++].b=p2;}
				w=ADIST(p2,p3);	if (w<CTHRESH*fabs(p2->rp.Z+p3->rp.Z))  {ecl[numec].a=p2;ecl[numec++].b=p3;}
				w=ADIST(p3,p1);	if (w<CTHRESH*fabs(p3->rp.Z+p1->rp.Z))  {ecl[numec].a=p3;ecl[numec++].b=p1;}
			}

			
		}
	}

	Draw3();

	// collapse the damn edges in the ecl!
	if (numec)
	{
		for (c1=0;c1<numec && mNumAV>3;c1++)
		{
			
			p1=ecl[c1].a;p2=ecl[c1].b;
			if (p1->child==NULL && p2->child==NULL && p1->matid==p2->matid)
			{
				p3=mV2F;mNumV2--;mV2F=mV2F->next;
				p1->child=p3;
				p2->child=p3;
				p3->child=NULL;
				p3->parent=p1;
				p3->parent2=p2;
				p3->next=mAV;mAV=p3;
				p3->nextf=NULL;
				p3->weight=EDIST(p1,p2);
				p3->p=(p1->p+p2->p)*0.5;

				// construct the material info
				p3->matid=p1->matid;
				p3->nummat=p1->nummat;
				CVInfo *src1=p1->nfo;
				CVInfo *src2=p2->nfo;
				CVInfo *dst=p3->nfo;
				for (int c2=0;c2<p1->nummat;c2++,src1++,dst++,src2++)
				{
					dst->u=(src1->u+src2->u)*0.5;
					dst->v=(src1->v+src2->v)*0.5;
					dst->n=(src1->n+src2->n)*0.5;
					//dst->n.Normalise();
					dst->fixcol.r=(src1->fixcol.r+src2->fixcol.r)>>1;
					dst->fixcol.g=(src1->fixcol.g+src2->fixcol.g)>>1;
					dst->fixcol.b=(src1->fixcol.b+src2->fixcol.b)>>1;
					dst->dyncol.Reset();
					dst->m=src1->m;					
				}

				mNumAV--;
			}
			
		}
		numec=0;

		// run down the index list making sure collapsing has taken place!
		int c2=1;
		while (c2)
		{
			c2=0;
			for (c1=0;c1<mNumV;c1++)
			{
				if (mVIdx[c1]->child) {mVIdx[c1]=mVIdx[c1]->child;c2=1;}
			}
		}
	}
}

void CObject::Draw3()
{
#define LBUFY2 (LBUFY/2)
	// project the points
	CPoint *v,*p1,*p2,*p3;
	
	
	for (v=mAV;v;v=v->next)
	{		
		if (v->rp.Z>LBUFMINZ)
		{
			float p=camscale/v->rp.Z;
			v->rp.X=(v->rp.X*p)+(0.5+LBUFX/2);
			v->rp.Y=(v->rp.Y*p*0.6666)+(0.5+LBUFY2/2);
			v->rp.Z=p*camzscale;
		} else v->rp.Z=0;
	}
	// draw the triangles
	CFace *f;
	for (f=mAF;f;f=f->next)
	{
		p1=*(f->v[2]);
		p2=*(f->v[1]);
		p3=*(f->v[0]);
		if (p1->rp.iZ && p2->rp.iZ && p3->rp.iZ)
		{
			// polygon is in front of the light so let's draw it
			int x1=p1->rp.X,y1=p1->rp.Y;
			int x2=p2->rp.X,y2=p2->rp.Y;
			int x3=p3->rp.X,y3=p3->rp.Y;
			if ((x1>=0 || x2>=0 || x3>=0) &&
		        (y1>=0 || y2>=0 || y3>=0) &&
				(x1<LBUFX || x2<LBUFX || x3<LBUFX) &&
		        (y1<LBUFY2 || y2<LBUFY2 || y3<LBUFY2))
			{
				int c=(x2-x1)*(y3-y1)-(y2-y1)*(x3-x1);
				if (c<0)
				{					
					miny=LBUFY2;
					maxy=0;
					traceedge(x1,y1,x2,y2,LBUFY2);
					traceedge(x2,y2,x3,y3,LBUFY2);
					traceedge(x3,y3,x1,y1,LBUFY2);
					if (miny<maxy)
					{
						int z1=p1->rp.Z;
						int z2=p2->rp.Z;
						int z3=p3->rp.Z;
						int dx=((y2-y1)*(z3-z1)-(z2-z1)*(y3-y1))/-c;
						int dy=((z2-z1)*(x3-x1)-(x2-x1)*(z3-z1))/-c;
						int *ldest=zbuf[miny];
						int *src=ebuf[miny];
						int lz=z1+(miny-y1)*dy-x1*dx;
						while (miny<maxy)
						{							
							int *dst=ldest+src[0];
							int *dst2=ldest+src[1];
							int z=lz+src[0]*dx;
							for (;dst<dst2;z+=dx,dst++) if (*dst<z) *dst=z;
							lz+=dy;							
							src+=2;
							ldest+=LBUFX;
							miny++;
						}
					}
				}
			}
		}
	}
}




////////////////////////////////////////////////////////////////////////////////////////
// basic light


float CUBE(float x) {return x*x*x;};

void CBasicLight::Light(CObject *o)
{
	FVector p=o->mAxes.Transpose()*(pos-o->mCentre);	
	CPoint *v;
	FVector p2;
	int c1;	
	for (v=o->mAV;v;v=v->next)
	{
		CVInfo *i=v->nfo;
		for (c1=0;c1<v->nummat;c1++,i++) 
		{
			p2=p-v->p;
			float d=-(i->n*p2)*10;						
			if (d>0)
			{
				d/=p2.MagnitudeSq();
				i->dyncol.r+=d*r;
				i->dyncol.g+=d*g;
				i->dyncol.b+=d*b;
			}
		}
	}
}


////////////////////////////////////////////////////////////////////////////////////////
// volume light

void CVolLight::Light(CObject *obj)
{

}



void CVolLight::renderobj(CObject *obj)
{
	
	FVector rotc=axes*(obj->mCentre-pos);
	FMatrix rota=axes*obj->mAxes;
	// transform the points into light space
	CPoint *v,*p1,*p2,*p3;
	zscale= 65536*256*LBUFMINZ/scale;
	for (v=obj->mAV;v;v=v->next)
	{
		v->rp=(rota*v->p)+rotc;
		if (v->rp.Z>LBUFMINZ)
		{
			float p=scale/v->rp.Z;
			v->rp.X=(v->rp.X*p)+(0.5+LBUFX/2);
			v->rp.Y=(v->rp.Y*p)+(0.5+LBUFY/2);
			v->rp.Z=p*zscale;
		} else v->rp.Z=0;
	}
	// draw the triangles
	CFace *f;
	for (f=obj->mAF;f;f=f->next)
	{
		p1=*(f->v[0]);
		p2=*(f->v[1]);
		p3=*(f->v[2]);
		if (p1->rp.iZ && p2->rp.iZ && p3->rp.iZ)
		{
			// polygon is in front of the light so let's draw it
			int x1=p1->rp.X,y1=p1->rp.Y;
			int x2=p2->rp.X,y2=p2->rp.Y;
			int x3=p3->rp.X,y3=p3->rp.Y;
			if ((x1>=0 || x2>=0 || x3>=0) &&
		        (y1>=0 || y2>=0 || y3>=0) &&
				(x1<LBUFX || x2<LBUFX || x3<LBUFX) &&
		        (y1<LBUFY || y2<LBUFY || y3<LBUFY))
			{
				int c=(x2-x1)*(y3-y1)-(y2-y1)*(x3-x1);
				if (c<0)
				{					
					miny=LBUFY;
					maxy=0;
					traceedge(x1,y1,x2,y2,LBUFY);
					traceedge(x2,y2,x3,y3,LBUFY);
					traceedge(x3,y3,x1,y1,LBUFY);
					if (miny<maxy)
					{
						int z1=p1->rp.Z;
						int z2=p2->rp.Z;
						int z3=p3->rp.Z;
						int dx=((y2-y1)*(z3-z1)-(z2-z1)*(y3-y1))/-c;
						int dy=((z2-z1)*(x3-x1)-(x2-x1)*(z3-z1))/-c;
						int *ldest=buf[miny];
						int *src=ebuf[miny];
						int lz=z1+(miny-y1)*dy-x1*dx;
						while (miny<maxy)
						{							
							int *dst=ldest+src[0];
							int *dst2=ldest+src[1];
							int z=lz+src[0]*dx;
							for (;dst<dst2;z+=dx,dst++) if (*dst<z) *dst=z;
							lz+=dy;							
							src+=2;
							ldest+=LBUFX;
							miny++;
						}
					}
				}
			}		
		}
	}
}


struct LMAPE
{
	int col;
	short idx;
};

LMAPE lmap[5][32*4+1];
CVolLight *firstvlight;

int CalcLight(int x,int y, int y2)
{	
	int col;
	//if (lmap[y2][x].idx<0x7e7e) return lmap[y2][x].col;
	if (lmap[y2][x].idx==0x7e7e) col=lmap[y2][x].col; else
	{
		col=0;
		CVolLight *l=firstvlight;
		for (;l;l=l->next)
		{
			col=l->CalcLight(x,y,col);
		}		
	}
	lmap[y2][x].idx=GOURAUD->AddVertex((x-16*4)*(1.f/(16*4)),(y-(8*4))*(1.f/(8*4)*3/4),1,lmap[y2][x].col=col);
	//lmap[y2][x].idx=GOURAUD->AddVertex((x-16*4)*(1.f/(16*4)),(y-(8*4))*(1.f/(8*4)*3/4),1,rand()*rand());lmap[y2][x].col=col;
	return col;
}

int coldiff(int c1, int c2)
{
	
	int r=abs((c1&0xff)-(c2&0xff)>>0);
	int g=abs((c1&0xff00)-(c2&0xff00)>>8);
	int b=abs((c1&0xff0000)-(c2&0xff0000)>>16);
	return (r+g+b)>24;
}

void LightTri(int l,int by, int x1, int y1, int x2, int y2, int x3, int y3)
{	
	int c1,c2,c3,c4,c5,c6;
	int x4,x5,x6,y4,y5,y6;

#define CALCLIGHT(x,y) ((lmap[(y)][(x)].idx>=0x7e7e)?CalcLight((x),(y)+(by<<2),(y)):lmap[(y)][(x)].col)

	c1=CALCLIGHT(x1,y1);
	c2=CALCLIGHT(x2,y2);
	c3=CALCLIGHT(x3,y3);

	if ((c1|c2|c3)==0) return;
	int mask=0;
	if (++l<3)
	{
		if (coldiff(c1,c2)) 
		{
			mask|=1;
			x4=(x1+x2)>>1;y4=(y1+y2)>>1;c4=CALCLIGHT(x4,y4);
		}
		if (coldiff(c2,c3)) 
		{
			mask|=2;
			x5=(x3+x2)>>1;y5=(y3+y2)>>1;c5=CALCLIGHT(x5,y5);
		}
		if (coldiff(c3,c1)) 
		{
			mask|=4;
			x6=(x1+x3)>>1;y6=(y1+y3)>>1;c6=CALCLIGHT(x6,y6);
		}		
	}

	if (mask==1 || mask==5 || mask==4)
	{
		x5=(x3+x2)>>1;y5=(y3+y2)>>1;
		c5=((c3&0xfefefefe)>>1)+((c2&0xfefefefe)>>1);
		if (lmap[y5][x5].idx>=0x7e7e) lmap[y5][x5].idx=GOURAUD->AddVertex((x5-16*4)*(1.f/(16*4)),((y5+(by<<2))-(8*4))*(1.f/(8*4)*3/4),1,lmap[y5][x5].col=c5);
			else c5=lmap[y5][x5].col;		
	}

	switch (mask)
	{
	case 0:
		GOURAUD->AddTri(lmap[y1][x1].idx,lmap[y2][x2].idx,lmap[y3][x3].idx);	// draw direct!		
		//GOURAUD->AddTri(lmap[y2][x2].idx,lmap[y1][x1].idx,lmap[y3][x3].idx);	// draw direct!		
		break;
	case 1:
		GOURAUD->AddTri(lmap[y1][x1].idx,lmap[y5][x5].idx,lmap[y3][x3].idx);	// draw direct! (case 1)		
		LightTri(l,by,x4,y4,x5,y5,x1,y1);		
		LightTri(l,by,x4,y4,x2,y2,x5,y5);		
		break;
	case 3:
		LightTri(l,by,x4,y4,x5,y5,x1,y1);
		LightTri(l,by,x1,y1,x5,y5,x3,y3);
		LightTri(l,by,x4,y4,x2,y2,x5,y5);
		break;
	case 2:
		LightTri(l,by,x5,y5,x1,y1,x2,y2);
		LightTri(l,by,x5,y5,x3,y3,x1,y1);		
		break;	
	case 4:		
		GOURAUD->AddTri(lmap[y1][x1].idx,lmap[y2][x2].idx,lmap[y5][x5].idx);	// draw direct (case 4)
		LightTri(l,by,x6,y6,x1,y1,x5,y5);
		LightTri(l,by,x6,y6,x5,y5,x3,y3);
		break;
	case 6:
		LightTri(l,by,x5,y5,x1,y1,x2,y2);
		LightTri(l,by,x6,y6,x1,y1,x5,y5);
		LightTri(l,by,x6,y6,x5,y5,x3,y3);
		break;
	case 5:
	case 7:
		LightTri(l,by,x6,y6,x1,y1,x5,y5);
		LightTri(l,by,x4,y4,x5,y5,x1,y1);
		LightTri(l,by,x4,y4,x2,y2,x5,y5);
		LightTri(l,by,x6,y6,x5,y5,x3,y3);
		break;
	}
}

void CVolLight::initforlight(CCam *cam, CVolLight *nxt)
{
	vec1=axes*(cam->mCentre-pos);
	zvec=axes*cam->mAxes.Row[2];
	xvec=(axes*cam->mAxes.Row[0])*(1/(4*16.f));
	yvec=(axes*cam->mAxes.Row[1])*(1/(4*8.f*4.f/3));
	next=nxt;
}

int CVolLight::CalcLight(int x, int y, int ocol)
{
	FVector vec=zvec+xvec*(x-16*4)+yvec*(y-8*4);
	int z=zbuf[y][x];if (z<10000) z=10000;
	FVector vec2=vec1+vec*((65536.f*256.f*LBUFMINZ)/(z));
	float shade=0;

	// perform poxy line clipping on p1,p2
	FVector p1,p2;
	
	if (vec1.Z>vec2.Z) {p2=vec1;p1=vec2;} else {p1=vec1;p2=vec2;}
	if (p2.Z>LBUFMINZ) 
	{
		if (p1.Z<LBUFMINZ) p1+=(p2-p1)*((LBUFMINZ-p1.Z)/(p2.Z-p1.Z));
		// project the points
		float p=scale/p1.Z;
		p1.X=(p1.X*p)+(LBUFX/2);
		p1.Y=(p1.Y*p)+(LBUFY/2);
		p1.Z=p*zscale;
		p=scale/p2.Z;
		p2.X=(p2.X*p)+(LBUFX/2);
		p2.Y=(p2.Y*p)+(LBUFY/2);
		p2.Z=p*zscale;
		int oc1=0,oc2=0;

#define LBUF2X (LBUFX-1)
#define LBUF2Y (LBUFY-1)

		if (p1.X<1) oc1|=1; else if (p1.X>LBUF2X) oc1|=2;if (p1.Y<1) oc1|=4; else if (p1.Y>LBUF2Y) oc1|=8;
		if (p2.X<1) oc2|=1; else if (p2.X>LBUF2X) oc2|=2;if (p2.Y<1) oc2|=4; else if (p2.Y>LBUF2Y) oc2|=8;
		if (!(oc1&oc2)) 
		{

			int oc3=oc1^oc2;
			if (oc3)
			{
				if (oc3&1)
				{
					FVector p3=p1+(p2-p1)*((1-p1.X)/(p2.X-p1.X));p3.X=1;
					int oc4=0;if (p3.X<1) oc4|=1; else if (p3.X>LBUF2X) oc4|=2;if (p3.Y<1) oc4|=4; else if (p3.Y>LBUF2Y) oc4|=8;
					if (oc1&1) {p1=p3;oc1=oc4;} else {p2=p3;oc2=oc4;}
					oc3=oc1^oc2;
				}

				if (oc3&2)
				{
					FVector p3=p1+(p2-p1)*((LBUF2X-p1.X)/(p2.X-p1.X));p3.X=LBUF2X;
					int oc4=0;if (p3.X<1) oc4|=1; else if (p3.X>LBUF2X) oc4|=2;if (p3.Y<1) oc4|=4; else if (p3.Y>LBUF2Y) oc4|=8;
					if (oc1&2) {p1=p3;oc1=oc4;} else {p2=p3;oc2=oc4;}
					oc3=oc1^oc2;
				}
				
				if (oc3&4)
				{
					FVector p3=p1+(p2-p1)*((1-p1.Y)/(p2.Y-p1.Y));p3.Y=1;
					int oc4=0;if (p3.X<1) oc4|=1; else if (p3.X>LBUF2X) oc4|=2;if (p3.Y<1) oc4|=4; else if (p3.Y>LBUF2Y) oc4|=8;
					if (oc1&4) {p1=p3;oc1=oc4;} else {p2=p3;oc2=oc4;}
					oc3=oc1^oc2;
				}
				if (oc3&8)
				{
					FVector p3=p1+(p2-p1)*((LBUF2Y-p1.Y)/(p2.Y-p1.Y));p3.Y=LBUF2Y;
					int oc4=0;if (p3.X<1) oc4|=1; else if (p3.X>LBUF2X) oc4|=2;if (p3.Y<1) oc4|=4; else if (p3.Y>LBUF2Y) oc4|=8;
					if (oc1&8) {p1=p3;oc1=oc4;} else {p2=p3;oc2=oc4;}
					oc3=oc1^oc2;
				}
			}
			if (!(oc1&oc2))
			{
			
				p2=(p2-p1)*(1/60.f);				
			
				float dinc=sqrt(p2.X*p2.X+p2.Y*p2.Y+p2.Z*p2.Z*(1/(32768*32768)));
				int lon=buf[int(p1.Y)][int(p1.X)]<p1.Z;
				
				int c1;
				for (c1=0;c1<60;c1++)
				{
						
					//if (!lon) break;
					p1+=p2;

					int moo=p1.Y;
					int cow=p1.X;

					int on=buf[moo][cow]<p1.Z;				
					
					if (on&lon)
					{
						shade+=dinc*p1.Z*(1/32768.f);
					}
					else if (on^lon)
					{
						shade+=dinc*p1.Z*(1/32768.f*0.5);
					}
					lon=on;
				}
				//if (lon) shade=0; else shade=100;
								
			}
			
		}
	}

	shade*=0.006;				
	shade=shade*shade;
	//if (shade>0.001) shade=0.3;

	//shade=x*y*0.001;

	int rr=((ocol>>16)&255)+shade*r;if (rr>255) rr=255;
	int gg=((ocol>>8)&255)+shade*g;if (gg>255) gg=255;
	int bb=((ocol>>0)&255)+shade*b;if (bb>255) bb=255;
	return (rr<<16)+(gg<<8)+bb;
}

void test3d()
{

	CTexture *mytex=new CTexture();

	DDPIXELFORMAT *pf;
	mytex->GetNicePixelFormat(16,0,&pf);
	mytex->Alloc(pf,128,128);

	int pitch,x,y;
	UWORD *out;
	if ((out=mytex->Lock(&pitch))!=NULL)
	{		
		for (int y=0;y<128;y++) for (x=0;x<128;x++) out[pitch*y+x]=x*y+(x<<11);
		mytex->Unlock();
	}
	else TRACE("error locking texture");


	CObject *o=new CObject();

	int NUMX=32;
	int NUMY=32;

	o->mNumAV=o->mNumV=NUMX*NUMY;
	o->mNumF=(NUMY-1)*NUMX*2;
	o->mVIdx=new CPoint*[o->mNumV];
	o->mV=new CPoint[o->mNumV];
	o->mF=new CFace[o->mNumF];
	o->mNumV2=o->mNumV;
	o->mV2F=o->mV2=new CPoint[o->mNumV2];
	int c1;
	for (c1=0;c1<o->mNumV2;c1++) o->mV2[c1].next=(c1+1==o->mNumV2)?NULL:o->mV2+c1+1;

	// initialise base vertices
	c1=0;
	for (y=0;y<NUMY;y++)
	for (x=0;x<NUMX;x++)
	{
		float r=4*(1.1+sin(y*PI*2/(NUMY-1)));
	
		o->mV[c1].p=FVector(r*sin(x*PI*2/NUMX),r*cos(x*PI*2/NUMX),((y-NUMY/2.f)/NUMY)*20.f);
		o->mV[c1].weight=0;		
		o->mV[c1].next=(c1+1==o->mNumV)?NULL:o->mV+c1+1;
		o->mV[c1].child=NULL;
		o->mV[c1].nextf=NULL;

		// material
		o->mV[c1].matid=1;	// just uses default mat
		o->mV[c1].nummat=1;	// just uses default mat
		o->mV[c1].nfo[0].m=mytex;
		o->mV[c1].nfo[0].u=o->mV[c1].p.X/4;
		o->mV[c1].nfo[0].v=o->mV[c1].p.Y/4;
		o->mV[c1].nfo[0].n=o->mV[c1].p;
		o->mV[c1].nfo[0].n.Normalise();
		o->mV[c1].nfo[0].fixcol.Reset();
		o->mV[c1].nfo[0].dyncol.Reset();
		c1++;
	}
	
	// initialise polygons
	c1=0;
	for (y=0;y<NUMY-1;y++)
	for (x=0;x<NUMX;x++)
	{
		int y2=y+1;
		int x2=(x+1)&(NUMX-1);
		o->mF[c1].v[0]=o->mVIdx+(y*NUMX+x);
		o->mF[c1].v[1]=o->mVIdx+(y*NUMX+x2);
		o->mF[c1].v[2]=o->mVIdx+(y2*NUMX+x2);
		o->mF[c1].next=(c1+1==o->mNumF)?NULL:o->mF+c1+1;
		o->mF[c1].mat[0]=o->mF[c1].mat[1]=o->mF[c1].mat[2]=0;			
		c1++;
		o->mF[c1].v[0]=o->mVIdx+(y2*NUMX+x2);
		o->mF[c1].v[1]=o->mVIdx+(y2*NUMX+x);
		o->mF[c1].v[2]=o->mVIdx+(y*NUMX+x);
		o->mF[c1].next=(c1+1==o->mNumF)?NULL:o->mF+c1+1;
		o->mF[c1].mat[0]=o->mF[c1].mat[1]=o->mF[c1].mat[2]=0;
		c1++;
	}
	// initialise index
	for (c1=0;c1<o->mNumV;c1++) o->mVIdx[c1]=o->mV+c1;
	o->mAF=o->mF;
	o->mAV=o->mV;

	//////////////////////////////////////////////////////////////////////////

	CBasicLight l1(255*2,15,15,FVector(40,-40,-10));
	CBasicLight l2(10,255*2,15,FVector(-40,-40,-10));
	CBasicLight l3(20,30,255*2,FVector(0,60,-10));
	CCam c;
	float t=0;
	c.mCentre=FVector(0,0,-50);

	CVolLight *l4=new CVolLight(255,128,64,FVector(-55,0,0));
	CVolLight *l5=new CVolLight(64,128,255,FVector(0,0,55));
	l4->axes.MakeYRot(PI/2);
	l5->axes.MakeYRot(PI);

	l4->clearbuf();
	l4->renderobj(o);
	l5->clearbuf();
	l5->renderobj(o);


	

	
	float dx=0,dy=0,dp=0;
	do
	{
		
		/*
		if ((out=mytex->Lock(&pitch))!=NULL)
		{		
			for (int y=0;y<128;y++) for (x=0;x<128;x++) out[pitch*y+x]=(l5->buf[y][x]>>5)+(3<<11);
			mytex->Unlock();
		}
		*/
		

		CTexture::RestoreLostSurfaces();
		CTexture::UploadAll();
		CTexture::mLastSelected=NULL;		
		gD->mD3DD2->BeginScene();		
		mytex->Select();
	
		FMatrix m1,m2;
		m1.MakeXRot(t*0.3523);
		m2.MakeYRot(t*-0.1025152);
		t=t+0.1;
		o->mAxes=m1*m2;

		
		memset(zbuf,0,sizeof(zbuf));
		o->Draw1(&c);
		l1.Light(o);
		l2.Light(o);
		l3.Light(o);
		o->Draw2();
		
		//o->Draw3();

		
		
		
		m1.MakeID();m2.MakeID();
		if (gKeyDown[VK_LEFT]) dx-=0.01;
		if (gKeyDown[VK_RIGHT]) dx+=0.01;
		if (gKeyDown[VK_UP]) dy-=0.01;
		if (gKeyDown[VK_DOWN]) dy+=0.01;
		if (gKeyDown[VK_HOME]) dp+=0.1;
		if (gKeyDown[VK_END]) dp-=0.1;


		dx*=0.95;
		dy*=0.95;
		dp*=0.95;
		m1.MakeYRot(dx*0.1);
		m2.MakeXRot(dy*0.1);		
		c.mAxes=(m1*m2)*c.mAxes;
		c.mCentre+=c.mAxes.Row[2]*dp*0.1;

		CTHRESH=0.07;
		ETHRESH=CTHRESH*2;

		

		

		CTexture::DrawAll();

		{

			gD->mD3DD2->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE , TRUE );	
			gD->mD3DD2->SetRenderState( D3DRENDERSTATE_ZFUNC , D3DCMP_ALWAYS );
			gD->mD3DD2->SetRenderState( D3DRENDERSTATE_SRCBLEND , D3DBLEND_ONE);
			gD->mD3DD2->SetRenderState( D3DRENDERSTATE_DESTBLEND , D3DBLEND_ONE);

			
			GOURAUD->Select();

			int y,x;

			// init lights
			firstvlight=l4;
			l4->initforlight(&c,l5);
			l5->initforlight(&c,NULL);
			l4->clearbuf();
			l4->renderobj(o);

			memset(lmap[4],0x7f,sizeof(LMAPE)* (32*4+1));
			for (y=0;y<16;y++)
			{
				// clear up the mess
				//memset(lmap[4],-1,sizeof(LMAPE)* (32*4+1));
				memcpy(lmap[0],lmap[4],sizeof(LMAPE)* (32*4+1));
				memset(lmap[1],0x7f,sizeof(LMAPE)* 4*(32*4+1));

				for (x=0;x<32*4;x+=4) 
				{					
					LightTri(0,y, x+0,0, x+4,0, x+0,4);
					LightTri(0,y, x+4,4, x+0,4, x+4,0);
					
					
				}

				if (GOURAUD->mVIdx > 3000) 
				{
					GOURAUD->Draw();	// periodically flush it
					for (x=0;x<32*4+1;x++) lmap[4][x].idx=0x7e7e;
				}
				
			}
			GOURAUD->Draw();

			if (0)
			{
				int a,b,c,d;
				a=mytex->AddVertex(-5,-5,10,0,0,0xffffffff);
				b=mytex->AddVertex( 5,-5,10,1,0,0xffffffff);
				c=mytex->AddVertex( 5, 5,10,1,1,0xffffffff);
				d=mytex->AddVertex(-5, 5,10,0,1,0xffffffff);
				mytex->AddTri(a,b,c);mytex->AddTri(c,b,a);
				mytex->AddTri(c,d,a);mytex->AddTri(a,d,c);
			}


			gD->mD3DD2->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE , FALSE );	
			gD->mD3DD2->SetRenderState( D3DRENDERSTATE_ZFUNC , D3DCMP_LESSEQUAL );
		}
		
		gD->mD3DD2->EndScene();

		if (!gD->Lock())
		{			
			char ss[1024];																					       
			sprintf(ss,"active vertices: %d (free=%d)",o->mNumAV,o->mNumV2);		
			drawstr(ss,gD->mScreenMem);
			gD->Unlock();
		}

		gD->DoTick(DT_FLIPCLEAR);
	} while (!gQuit);

	delete mytex;

	delete o;

}