// main
//

#include "common.h"
#include "crtdbg.h"
#include "3d.h"
#include "demo.h"

#ifdef _PROFILE
Prof prof;
#endif

#pragma  warning(disable:4244 4305)

HINSTANCE gInst;
HWND gHWnd;


char appname[]="stxdemo";

void DDError(HRESULT error, char *context)
{
	char c2[1024];
	sprintf(c2,"Error context was:\n\n%s\n\nSorry guv'nor.\nTry a different mode/driver/computer/life",context);
	MessageBox(NULL,c2,"Direct-X Error!",MB_OK|MB_ICONERROR);
}

void SoundError()
{
	char c2[1024];
	sprintf(c2,"Sorry guv'nor.\nThere's a problem with the sound.\nTry a different mode/driver/computer/life");
	MessageBox(NULL,c2,"Direct-Sound Error!",MB_OK|MB_ICONERROR);
}



struct Camera
{
	FVector p;
	FMatrix m;
};

Camera cam;
float dalpha,dtheta;

LRESULT CALLBACK WndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
	switch (msg)
	{
	case WM_DESTROY:
		gQuit=1;
		break;
	case WM_KEYDOWN:
		switch ((wparam))
		{		
		case VK_LEFT:
				if (lparam&(1<<24)) dalpha=-1;
				break;
		case VK_RIGHT:
				if (lparam&(1<<24)) dalpha=1; 
				break;
		case VK_UP:
				if (lparam&(1<<24)) dtheta=-1;
				break;
		case VK_DOWN:
				if (lparam&(1<<24)) dtheta=+1;
				break;		
		}
		break;
	case WM_KEYUP:
		switch (toupper(wparam))
		{
		case VK_LEFT:
				if (lparam&(1<<24)) dalpha=0;
				break;
		case VK_RIGHT:
				if (lparam&(1<<24)) dalpha=0;
				break;
		case VK_UP:
				if (lparam&(1<<24)) dtheta=0;
				break;
		case VK_DOWN:
				if (lparam&(1<<24)) dtheta=0;
				break;
		}
		break;
	case WM_CHAR:
		switch (toupper(wparam))
		{		
		case 27:
			DestroyWindow(hwnd);
			break;		
		}		
		break;
	case WM_CREATE:
		return 0;	
	}
	if (gD) return gD->WndProc(hwnd,msg,wparam,lparam); else return DefWindowProc(hwnd,msg,wparam,lparam);
}



int WINAPI WinMain(HINSTANCE hinst, HINSTANCE hpinst, PSTR cmdline, int show)
{
#ifdef _DEBUG
	_CrtMemState memstate1;
	_CrtMemCheckpoint(&memstate1);
#endif

	gInst=hinst;

	// create window
	WNDCLASSEX wc={sizeof(wc),CS_HREDRAW|CS_VREDRAW,WndProc,0,0,hinst,LoadIcon(NULL,IDI_APPLICATION),
		LoadCursor(NULL,IDC_ARROW),(HBRUSH)GetStockObject(WHITE_BRUSH),NULL,appname,LoadIcon(NULL,IDI_APPLICATION)};
	RegisterClassEx(&wc);
	gHWnd=CreateWindow(appname,"statixdemo",WS_CAPTION|WS_SYSMENU|WS_BORDER,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,
						NULL,NULL,hinst,NULL);
	ShowWindow(gHWnd,SW_HIDE);	

	
	
	
	if (openlib("bleam.dat"))
	{
		TRACE("Error loading library file!\n");
		MessageBox(NULL,"Couldn't open data file","error",MB_OK|MB_ICONSTOP);
		return 1;
	}
	
	
	
	gD=new CD3D();

	if (gD->Init()) 
	{
		delete gD;
		return 1;
	}

	if (gD->InitScreen())
	{
		delete gD;
		return 1;
	}

	
	
	if (gD->InitSound())
	{
		gD->CloseScreen();
		SoundError();
		delete gD;
		return 1;
	}

	
	extern int InitMpegPlayer(char *fname);
	if (!InitMpegPlayer("bleam.mp3"))
	{
		gD->CloseSound();
		gD->CloseScreen();
		SoundError();
		delete gD;
		return 1;
	};
	
	
	
	
	//gD->FastForward(TICKSPERSEC*30);	// **********
	
	

	int frame=0;
	float fps=0;
	int time1=GetTickCount();


	cam.p=FVector(0,0,-500);
	cam.m.MakeID();


	CTexture::InitialiseAll(D3DCULL_NONE);
	gD->mD3DD2->SetRenderState( D3DRENDERSTATE_ALPHABLENDENABLE , TRUE );		
	gD->mD3DD2->SetRenderState( D3DRENDERSTATE_TEXTUREMAPBLEND , D3DTBLEND_MODULATEALPHA);
	gD->mD3DD2->SetRenderState( D3DRENDERSTATE_ZENABLE , TRUE );		
	gD->mD3DD2->SetRenderState( D3DRENDERSTATE_SRCBLEND , D3DBLEND_SRCALPHA);
	gD->mD3DD2->SetRenderState( D3DRENDERSTATE_DESTBLEND , D3DBLEND_INVSRCALPHA);
	

	// blah blah blah

/**********
	


	CTexture *mytex=new CTexture();
	DDPIXELFORMAT *pf;
	mytex->GetNicePixelFormat(16,0,&pf);
	mytex->Alloc(pf,256,256);	

	v_init();	
	v_load("d3d.ctl");
	v_initsection(mytex);
	
	int r;
	float alpha=0;
	float theta=-0.27f;
	float da=0;
	float dt=0;
	do
	{

		PROFNAME(1,"vstep");
		v_step(mytex);
		PROFILE(0);
		
		PROFNAME(2,"upload");
		CTexture::RestoreLostSurfaces();
		CTexture::UploadAll();
		CTexture::mLastSelected=NULL;
		PROFILE(0);
		r=gD->mD3DD2->BeginScene();
		if (r) trace_d3d_error(r);		
		
		FMatrix m1,m2;
		m1.MakeYRot(alpha);
		m2.MakeXRot(theta);
		cam.m=m2*m1;	
		if (dalpha) da=dalpha; else da*=0.95f;
		if (dtheta) dt=dtheta; else dt*=0.95f;
		
		alpha+=0.01f *da;
		theta+=0.01f*dt;
		
		cam.p=cam.m.Row[2]*-200;		
		
		mytex->Select();
	
		
		FVector p;
		float v1=(curframe&1)?1:0;		
		p=cam.m*(FVector(-200*4/3,-200,200/3)-cam.p);
		int a=mytex->AddVertex(p.X,p.Y,p.Z,0,v1, 0xffffffff);
		p=cam.m*(FVector(200*4/3,-200,200/3)-cam.p);
		int b=mytex->AddVertex(p.X,p.Y,p.Z,1,v1, 0xffffffff);
		p=cam.m*(FVector(200*4/3,200,200/3)-cam.p);
		//v1=(curframe&1)?1:0.5;		
		v1=0.5;
		int c=mytex->AddVertex(p.X,p.Y,p.Z,1,v1, 0xffffffff);
		p=cam.m*(FVector(-200*4/3,200,200/3)-cam.p);
		int d=mytex->AddVertex(p.X,p.Y,p.Z,0,v1, 0xffffffff);
		mytex->AddTri(a,b,c);mytex->AddTri(c,b,a);
		mytex->AddTri(c,d,a);mytex->AddTri(a,d,c);	

		PROFNAME(3,"drawall");

		CTexture::DrawAll();
		

		PROFNAME(4,"endscene");
		r=gD->mD3DD2->EndScene();
		PROFILE(0);
		if (r) trace_d3d_error(r);		

			
		if ((frame&7)==0)
		{
			RESULTS();
			START();
		}

		PROFNAME(5,"lock");
		
		if (!gD->Lock())
		{
			PROFNAME(6,"draw stats");

			char ss[1024];																					       
			sprintf(ss,"\n\nfps: %0.2f",fps);		
			drawstr(ss,gD->mScreenMem);
#ifdef _PROFILE
			int c1,c2;
			c2=8*3;
			float fac;if (prof.maxcpu) fac=50./prof.maxcpu; else fac=0;
			for (c1=0;c1<32;c1++) if (prof.calls[c1])
			{
				sprintf(ss,"%2d %6.2fms %4.1f%%               %s",c1,prof.ms[c1],prof.cpu[c1],prof.name[c1]?prof.name[c1]:"");
				drawstr(ss,gD->mScreenMem+c2*gD->mPitch);
				drawbox((short*)gD->mScreenMem,gD->mPitch/2,19*8,c2,19*8+prof.cpu[c1]*fac,c2+8,0xf000);
				drawbox((short*)gD->mScreenMem,gD->mPitch/2,19*8+prof.cpu[c1]*fac,c2,19*8+50,c2+8,0x0212);
				c2+=9;
			}
#endif
			//memset(gD->mScreenMem,-1,10000);
			PROFNAME(7,"unlock");
			gD->Unlock();
		}
		
		PROFILE(0);

		//gD->PollSound();
				
		gD->DoTick(DT_FLIPCLEAR);

		frame++;
		int time2=GetTickCount()-time1;
		if (time2>2500)
		{			
			fps=frame*1000.0f/time2;
			time1=GetTickCount();
			frame=0;
	
		}
		
	} while (!gQuit);

 
	v_deinit();

// ******/
/*
 
	do
	{
		CTexture::RestoreLostSurfaces();
		CTexture::UploadAll();
		CTexture::mLastSelected=NULL;		
		gD->mD3DD2->BeginScene();

		int a=GOURAUD->AddVertex(-5,-5,10,0x102040);
		int b=GOURAUD->AddVertex( 5,-5,10,0x102040*2);
		int c=GOURAUD->AddVertex(-5, 5,10,0x102040*4);
		GOURAUD->AddTri(a,b,c);
		GOURAUD->AddTri(c,b,a);
		GOURAUD->Draw();

		gD->mD3DD2->EndScene();
		gD->DoTick(DT_FLIPCLEAR);
	} while (!gQuit);
//*/ 

	//test3d();

	gD->DoTick(DT_FLIPCLEAR);
	
	
	herewego();

	
	if (avi) closeavi();
	gD->CloseSound();
	gD->CloseScreen();
	ShowWindow(gHWnd,SW_HIDE);
	
	CTexture::DeleteAll();
	delete gD;
	closelib();


#ifdef _DEBUG	
	_CrtMemState memstate2,memdiff;
	_CrtMemCheckpoint(&memstate2);
	if (_CrtMemDifference(&memdiff,&memstate1,&memstate2)) 
	{
		_CrtMemDumpStatistics(&memdiff);
		_CrtDumpMemoryLeaks();
		TRACE("memory damn leaks");
		MessageBox(NULL,"Memory leaks detected!\nCheck debug trace!","Memory leaks detected",MB_OK|MB_ICONINFORMATION);
	}
#endif
	return 0;	
	
}