// main
//

#include "common.h"
#include "coords.h"
#include "crtdbg.h"
#include "d3derr.h"
#include "texture.h"
#include "video.h"
#include "profile.h"

#ifdef _PROFILE
Prof prof;
#endif

#pragma  warning(disable:4244 4305)

HINSTANCE gInst;
HWND gHWnd;

char gQuit=0;
char appname[]="stxdemo";

void DDError(HRESULT error, char *context)
{
	char c2[1024];
	sprintf(c2,"Error context was:\n\n%s\n\nSorry guv'nor.\nTry a different mode/driver/computer/life",context);
	MessageBox(NULL,c2,"Direct-X Error!",MB_OK|MB_ICONERROR);
}

void SoundError()
{
	char c2[1024];
	sprintf(c2,"Sorry guv'nor.\nThere's a problem with the sound.\nTry a different mode/driver/computer/life");
	MessageBox(NULL,c2,"Direct-Sound Error!",MB_OK|MB_ICONERROR);
}



struct Camera
{
	FVector p;
	FMatrix m;
};

Camera cam;
float dalpha,dtheta;

void drawbox(short *o, int pitch, int x1, int y1, int x2, int y2, short c)
{
	short *o2;
	int x,y;
	for (y=y1;y<y2;y++)
	{
		o2=o+x1+y*pitch;
		for (x=x1;x<x2;x++) *o2++=c;
	}
}

int coltab[4]={0,10+(20<<5)+(10<<11),20+(40<<5)+(20<<11),-1};

void drawstr(char *str, char *o, int pitch=gD->mPitch, int bits=gD->mVM->mB)
{
	bits/=8;
	int x,x2,y,m,m2,i;
	static int j=0;
	static char font[256][8];
	if (!j)
	{
		j=1;
		FILE *f=fopen("font.fnt","rb");
		fread(font,256,8,f);
		fclose(f);
	}
	char *o2=o;
	while (*str)
	{
		if (*str==13 || *str==10)
		{	
			o2+=pitch*8;
			o=o2;
			str++;
			continue;
		}
		char *b=font[*str++];
		for (y=0;y<8;y++,b++)
		{
			m=*b;			
			for (x=0;x<8;x++,m<<=1,o+=bits) 
			{
				i=0;
				if (m&128) i++;
				if (i)
				{					
					for (x2=0;x2<bits;x2++) o[x2]=-1;				
				}
			}
			o+=pitch-bits*8;
		}
		o-=pitch*8-bits*8;
	}
}

LRESULT CALLBACK WndProc(HWND hwnd, UINT msg, WPARAM wparam, LPARAM lparam)
{
	switch (msg)
	{
	case WM_DESTROY:
		gQuit=1;
		break;
	case WM_KEYDOWN:
		switch ((wparam))
		{		
		case VK_LEFT:
				if (lparam&(1<<24)) dalpha=-1;
				break;
		case VK_RIGHT:
				if (lparam&(1<<24)) dalpha=1; 
				break;
		case VK_UP:
				if (lparam&(1<<24)) dtheta=-1;
				break;
		case VK_DOWN:
				if (lparam&(1<<24)) dtheta=+1;
				break;		
		}
		return 1;
	case WM_KEYUP:
		switch (toupper(wparam))
		{
		case VK_LEFT:
				if (lparam&(1<<24)) dalpha=0;
				break;
		case VK_RIGHT:
				if (lparam&(1<<24)) dalpha=0;
				break;
		case VK_UP:
				if (lparam&(1<<24)) dtheta=0;
				break;
		case VK_DOWN:
				if (lparam&(1<<24)) dtheta=0;
				break;
		}
		return 0;
	case WM_CHAR:
		switch (toupper(wparam))
		{		
		case 27:
			DestroyWindow(hwnd);
			break;		
		}		
		return 0;
	case WM_CREATE:
		return 0;	
	}
	if (gD) return gD->WndProc(hwnd,msg,wparam,lparam); else return DefWindowProc(hwnd,msg,wparam,lparam);
}



int WINAPI WinMain(HINSTANCE hinst, HINSTANCE hpinst, PSTR cmdline, int show)
{
#ifdef _DEBUG
	_CrtMemState memstate1;
	_CrtMemCheckpoint(&memstate1);
#endif

	gInst=hinst;

	// create window
	WNDCLASSEX wc={sizeof(wc),CS_HREDRAW|CS_VREDRAW,WndProc,0,0,hinst,LoadIcon(NULL,IDI_APPLICATION),
		LoadCursor(NULL,IDC_ARROW),(HBRUSH)GetStockObject(WHITE_BRUSH),NULL,appname,LoadIcon(NULL,IDI_APPLICATION)};
	RegisterClassEx(&wc);
	gHWnd=CreateWindow(appname,"dt3 player",WS_CAPTION|WS_SYSMENU|WS_BORDER,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,CW_USEDEFAULT,
						NULL,NULL,hinst,NULL);
	ShowWindow(gHWnd,SW_HIDE);	

	gD=new CD3D();

	if (gD->Init()) 
	{
		delete gD;
		return 1;
	}

	if (gD->InitScreen())
	{
		delete gD;
		return 1;
	}

	
	if (gD->InitSound())
	{
		gD->CloseScreen();
		SoundError();
		delete gD;
		return 1;
	}

	extern int InitMpegPlayer(char *fname);
	if (!InitMpegPlayer("d3d.mp3"))
	{
		gD->CloseSound();
		gD->CloseScreen();
		SoundError();
		delete gD;
		return 1;
	};

	
	
	if (gD->StartSound())
	{
		gD->CloseSound();
		gD->CloseScreen();
		SoundError();
		delete gD;
		return 1;
	}

	

	int frame=0;
	float fps=0;
	int time1=GetTickCount();


	cam.p=FVector(0,0,-500);
	cam.m.MakeID();


	CTexture::InitialiseAll(0);
	CTexture *mytex=new CTexture();

	DDPIXELFORMAT *pf;
	mytex->GetNicePixelFormat(16,0,&pf);
	mytex->Alloc(pf,256,256);

	int pitch;
	UWORD *out;


	if ((out=mytex->Lock(&pitch))!=NULL)
	{
		TRACE("locked texture %x %d\n",out,pitch);		
		for (int y=0;y<256;y++) memset(out+pitch*y,0,pitch*2);		
		mytex->Unlock();
	}
	else TRACE("error locking texture");

	// blah blah blah

	
	v_init();	
	v_load("d3d.ctl");
	v_initsection(mytex);
	
	int r;
	float alpha=0;
	float theta=-0.27f;
	float da=0;
	float dt=0;
	do
	{

		PROFNAME(1,"vstep");
		v_step(mytex);
		PROFILE(0);
		
		PROFNAME(2,"upload");
		CTexture::RestoreLostSurfaces();
		CTexture::UploadAll();
		CTexture::mLastSelected=NULL;
		PROFILE(0);
		r=gD->mD3DD2->BeginScene();
		if (r) trace_d3d_error(r);		
		
		FMatrix m1,m2;
		m1.MakeYRot(alpha);
		m2.MakeXRot(theta);
		cam.m=m2*m1;	
		if (dalpha) da=dalpha; else da*=0.95f;
		if (dtheta) dt=dtheta; else dt*=0.95f;
		
		alpha+=0.01f *da;
		theta+=0.01f*dt;
		
		cam.p=cam.m.Row[2]*-200;		
		
		mytex->Select();
	
		
		FVector p;
		float v1=(curframe&1)?1:0;		
		p=cam.m*(FVector(-200*4/3,-200,200/3)-cam.p);
		int a=mytex->AddVertex(p.X,p.Y,p.Z,0,v1, 0xffffffff);
		p=cam.m*(FVector(200*4/3,-200,200/3)-cam.p);
		int b=mytex->AddVertex(p.X,p.Y,p.Z,1,v1, 0xffffffff);
		p=cam.m*(FVector(200*4/3,200,200/3)-cam.p);
		//v1=(curframe&1)?1:0.5;		
		v1=0.5;
		int c=mytex->AddVertex(p.X,p.Y,p.Z,1,v1, 0xffffffff);
		p=cam.m*(FVector(-200*4/3,200,200/3)-cam.p);
		int d=mytex->AddVertex(p.X,p.Y,p.Z,0,v1, 0xffffffff);
		mytex->AddTri(a,b,c);mytex->AddTri(c,b,a);
		mytex->AddTri(c,d,a);mytex->AddTri(a,d,c);	

		PROFNAME(3,"drawall");

		CTexture::DrawAll();
		

		PROFNAME(4,"endscene");
		r=gD->mD3DD2->EndScene();
		PROFILE(0);
		if (r) trace_d3d_error(r);		

			
		if ((frame&7)==0)
		{
			RESULTS();
			START();
		}

		PROFNAME(5,"lock");
		
		if (!gD->Lock())
		{
			PROFNAME(6,"draw stats");

			char ss[1024];																					       
			sprintf(ss,"\n\nfps: %0.2f",fps);		
			drawstr(ss,gD->mScreenMem);
#ifdef _PROFILE
			int c1,c2;
			c2=8*3;
			float fac;if (prof.maxcpu) fac=50./prof.maxcpu; else fac=0;
			for (c1=0;c1<32;c1++) if (prof.calls[c1])
			{
				sprintf(ss,"%2d %6.2fms %4.1f%%               %s",c1,prof.ms[c1],prof.cpu[c1],prof.name[c1]?prof.name[c1]:"");
				drawstr(ss,gD->mScreenMem+c2*gD->mPitch);
				drawbox((short*)gD->mScreenMem,gD->mPitch/2,19*8,c2,19*8+prof.cpu[c1]*fac,c2+8,0xf000);
				drawbox((short*)gD->mScreenMem,gD->mPitch/2,19*8+prof.cpu[c1]*fac,c2,19*8+50,c2+8,0x0212);
				c2+=9;
			}
#endif
			//memset(gD->mScreenMem,-1,10000);
			PROFNAME(7,"unlock");
			gD->Unlock();
		}
		
		PROFILE(0);

		gD->PollSound();
				
		gD->DoTick(DT_FLIPCLEAR);

		frame++;
		int time2=GetTickCount()-time1;
		if (time2>2500)
		{			
			fps=frame*1000.0f/time2;
			time1=GetTickCount();
			frame=0;
	
		}
		
	} while (!gQuit);

 
	v_deinit();

	gD->CloseSound();
	gD->CloseScreen();

	CTexture::DeleteAll();
	delete gD;

#ifdef _DEBUG
	_CrtMemState memstate2,memdiff;
	_CrtMemCheckpoint(&memstate2);
	if (_CrtMemDifference(&memdiff,&memstate1,&memstate2)) 
	{
		_CrtMemDumpStatistics(&memdiff);
		_CrtDumpMemoryLeaks();
		MessageBox(NULL,"Memory leaks detected!\nCheck debug trace!","Memory leaks detected",MB_OK|MB_ICONINFORMATION);
	}
#endif
	return 0;	
	
}