
#include "common.h"
#include "video.h"
#include "texture.h"

int CLP(int c)
{
	return c<-128?-128:c>127?127:c;
}


//************************************************************
// constants

#define W 256
#define H 256
#define LW 8


 int QMAT[3][16]= {
			{5*256/6,4*256/6,5*256/6,6*256/6,8*256/6,10*256/6,12*256/6,14*256/6,16*256/6,18*256/6,20*256/6,23*256/6,26*256/6,29*256/6,32*256/6,35*256/6},
                        {5*2*256/6,4*2*256/6,5*2*256/6,6*2*256/6,8*2*256/6,10*2*256/6,12*2*256/6,14*2*256/6,16*2*256/6,18*2*256/6,20*2*256/6,23*2*256/6,26*2*256/6,29*2*256/6,32*2*256/6,35*2*256/6}
                        };
#define DCTTHR 1
#define Q 4
#define MAX 7		// code range is from -MAX-1 to MAX
#define OBITS 4		// number of btis needed to encode output

const int DEQUANT[]={       0,  1*Q,  4*Q,  9*Q, 16*Q,25*Q,36*Q,49*Q,
			-64*Q,-49*Q,-36*Q,-25*Q,-16*Q,-9*Q,-4*Q,-1*Q};

//************************************************************
// bitio

char *buf,*bufptr;
int bufsize;
int bitpos=1,bitcount=0;
int getbit()
{
    bitcount++;
	int i=(bufptr[0]&bitpos);
	if ((bitpos<<=1)==256) {bitpos=1;bufptr++;}
	return i;
}
int getbits(int c)
{
	int i=(((int*)bufptr)[0]>>(bitcount&7))&((1<<c)-1);
        bitcount+=c;
        if ((bitpos<<=c)>=256)
        {
                bufptr++;bitpos>>=8;
        }
	return i;
}
inline int getbits_d(int c)
{
	if (!getbit()) return 0;
	if (!getbit()) return getbit()?-1:1;
	int i=getbits(c+1);
	c=1<<c;
	if (i>=c) return i-(c<<1)-1;
	return i+2;
}
inline int getbits_s(int c)
{
	int i=getbits(c);
	c=32-c;
	return (i<<c)>>c;
}

//************************************************************
// wavelet stuff

#define _C0 (0.332671  )
#define _C1 (0.806891  )
#define _C2 (0.459877  )
#define _C3 (-0.135011 )
#define _C4 (-0.085411 )
#define _C5 (0.035226  )

#define _D0 0.035226
#define _D1 0.085411
#define _D2 -0.135011
#define _D3 -0.459877
#define _D4 0.806891
#define _D5 -0.332671

void unfilter6(float *in, float *out, int w)
{
	int c1;
	int w2=w>>1;
	float *in2=in+w2;

	// first 4 lines of matrix
	out[0]=in[0]*_C0+in2[0]*_D0+in[w2-2]*_C4+in2[w2-2]*_D4+in[w2-1]*_C2+in2[w2-1]*_D2;
	out[W]=in[0]*_C1+in2[0]*_D1+in[w2-2]*_C5+in2[w2-2]*_D5+in[w2-1]*_C3+in2[w2-1]*_D3;
	out[W*2]=in[0]*_C2+in2[0]*_D2+in[1]*_C0+in2[1]*_D0+in[w2-1]*_C4+in2[w2-1]*_D4;
	out[W*3]=in[0]*_C3+in2[0]*_D3+in[1]*_C1+in2[1]*_D1+in[w2-1]*_C5+in2[w2-1]*_D5;
	out+=W*4;
	for (c1=2;c1<w2;c1++)
	{
		out[0]=in[0]*_C4+in2[0]*_D4+in[1]*_C2+in2[1]*_D2+in[2]*_C0+in2[2]*_D0;
		out[W]=in[0]*_C5+in2[0]*_D5+in[1]*_C3+in2[1]*_D3+in[2]*_C1+in2[2]*_D1;

		in++;in2++;
		out+=W*2;
	}
}
void unfilter6b(float *in, float *out, int w)
{
	int c1;
	int w2=w>>1;
	float *in2=in+(w2<<LW);

	// first 4 lines of matrix
	*out++=in[(0)<<LW]*_C0+in2[(0)<<LW]*_D0+in[(w2-2)<<LW]*_C4+in2[(w2-2)<<LW]*_D4+in[(w2-1)<<LW]*_C2+in2[(w2-1)<<LW]*_D2;
	*out++=in[(0)<<LW]*_C1+in2[(0)<<LW]*_D1+in[(w2-2)<<LW]*_C5+in2[(w2-2)<<LW]*_D5+in[(w2-1)<<LW]*_C3+in2[(w2-1)<<LW]*_D3;
	*out++=in[(0)<<LW]*_C2+in2[(0)<<LW]*_D2+in[(1)<<LW]*_C0+in2[(1)<<LW]*_D0+in[(w2-1)<<LW]*_C4+in2[(w2-1)<<LW]*_D4;
	*out++=in[(0)<<LW]*_C3+in2[(0)<<LW]*_D3+in[(1)<<LW]*_C1+in2[(1)<<LW]*_D1+in[(w2-1)<<LW]*_C5+in2[(w2-1)<<LW]*_D5;
        c1=(w2-2)/2;
	for (;c1--;)
	{
		*out++=in[(0)<<LW]*_C4+in2[(0)<<LW]*_D4+in[(1)<<LW]*_C2+in2[(1)<<LW]*_D2+in[(2)<<LW]*_C0+in2[(2)<<LW]*_D0;
		*out++=in[(0)<<LW]*_C5+in2[(0)<<LW]*_D5+in[(1)<<LW]*_C3+in2[(1)<<LW]*_D3+in[(2)<<LW]*_C1+in2[(2)<<LW]*_D1;
                *out++=in[(1)<<LW]*_C4+in2[(1)<<LW]*_D4+in[(2)<<LW]*_C2+in2[(2)<<LW]*_D2+in[(3)<<LW]*_C0+in2[(3)<<LW]*_D0;
		*out++=in[(1)<<LW]*_C5+in2[(1)<<LW]*_D5+in[(2)<<LW]*_C3+in2[(2)<<LW]*_D3+in[(3)<<LW]*_C1+in2[(3)<<LW]*_D1;
		in+=W;in2+=W;
	}
}


//************************************************************
// dct  stuff

#include "videodct.h"

//************************************************************
// un packer

int covered[32];
inline int fsqr(int f)
{
	return (f<0)?-f*f:f*f;
}
void decode0(float *f, int q)
{
	DCTBLOCK d;
    int i,j;
	int numbits=getbits(6);

        int *zz=&zigzag[0][0];
        int *zb=&zigbits[0];
	if (q==3)
	{
                j=(numbits<36)?numbits:36;
                for (i=0;i<j;i++,zz+=2,zb++) d[zz[0]][zz[1]]=getbits_s(*zb -1);
                for (;i<numbits;i++,zz+=2) d[zz[0]][zz[1]]=getbits_d(2);
	}
        else
        if (q==0)
	{
                for (i=0;i<numbits;i++,zz+=2) d[zz[0]][zz[1]]=getbits_s(*zb++ +1);
	}
	else
	{
                for (i=0;i<numbits;i++,zz+=2) d[zz[0]][zz[1]]=getbits_s(*zb++);
	}
	for (;i<64;i++,zz+=2) d[zz[0]][zz[1]]=0;
	DCTELEM *dt=&d[0][0];
        zz=QMAT[(q==3)?1:0];
	for (i=0;i<8;i++)
	for (j=0;j<8;j++,dt++) *dt = (fsqr(*dt) * zz[i+j])>>8;

	j_rev_dct(d);

	dt=&d[0][0];
	for (j=0;j<8;j++,f+=W-8)
	for (i=0;i<8;i++) *f++=(*dt++ << 3) * 0;

}
int checkzero(float *f,int x, int y, int w, int logsc)
{

	int *cv,c2,mask;
        c2=w>>logsc;
        if (!c2) goto itsnotcovered;
        mask=((1<<c2)-1)<<(x>>logsc);
        cv=covered+(y>>logsc);
	for (;c2--;cv++) if ((*cv)&mask) goto itsnotcovered;
	return 1;	// already covered!
itsnotcovered:
	if (getbit()) return 0;
	// zero it out...
        // zero it out...
        //float *f2=f+(y<<LW)+x;
	//for (c2=w;c2--;f2+=W) memset(f2,0,w<<2);
        for (c2=y;c2<y+w;c2++) memset(f+(c2<<LW)+x,0,w*4);

	// super?
	if (logsc==3) return 1;

	if (getbit())
	{

		// aww its a super...
                c2=w>>logsc;
                mask=~mask;
                cv=covered+(y>>logsc);
	        for (;c2--;cv++) *cv &= mask;

		// zero it out recursively...
		while (logsc++<3)
		{
                        x<<=1;y<<=1;w<<=1;
                        //f2=f+(y<<LW)+x;
                        //for (c2=w;c2--;f2+=W) memset(f2,0,w<<2);
                        for (c2=y;c2<y+w;c2++) memset(f+(c2<<LW)+x,0,w*4);
		}
	}
	return 1;
}
void rebuild(float *f,int x, int y, int w, int logsc)
{
	int i,j;

	if (checkzero(f,x,y,w,logsc)) return;
	if (getbit())
	{
		if (w==4)
		{
			// store
			//mark(x,y,w,7);
			for (j=0;j<w;j++)
			for (i=0;i<w;i++)
			{
				f[(x+i)+W*(y+j)]=DEQUANT[getbits(OBITS)];
			}
		}
		else
		{
			// subdivide
			int w2=w>>1;
			rebuild(f,x,y,w2,logsc);
			rebuild(f,x+w2,y,w2,logsc);
			rebuild(f,x,y+w2,w2,logsc);
			rebuild(f,x+w2,y+w2,w2,logsc);
		}
	}
	else
	{
		// relative
		//mark(x,y,w,6);
		int alpha,flip,bdx,bdy,step,tx,ty;
		alpha=getbits_s(6);
		flip=getbits(2);
		if (logsc==0)
		{
			bdx=getbits(3);
			bdy=getbits(3);
		}
		else
		{
			bdx=getbits(4);
			bdy=getbits(4);
		}
		step=(logsc>0)?logsc-1:0;
		tx=((x&(16<<logsc))>>1)+(bdx<<step);
		ty=((y&(16<<logsc))>>1)+(bdy<<step);

		float *s=f+tx+(ty<<LW);
		f+=x+(y<<LW);
		float a=alpha/31.0f;

                switch (flip)
		{
                case 0:
			for (j=0;j<w;j++,f+=W-w,s+=W-w)
			for (i=0;i<w;i++) *f++ = a* *s++;
			return;
                case 1:
                        s+=w-1;
			for (j=0;j<w;j++,f+=W-w,s-=(w<<LW)+1)
			for (i=0;i<w;i++,s+=W) *f++ = a* *s;
			return;

		case 2:
                        s+=w-1+((w-1)<<LW);
			for (j=0;j<w;j++,f+=W-w, s-=W-w)
			for (i=0;i<w;i++) *f++ = a* *s--;
			return;
                case 3:
                        s+=(w-1)<<LW;
			for (j=0;j<w;j++,f+=W-w, s+=(w<<LW)+1)
			for (i=0;i<w;i++,s-=W) *f++ = a* *s;
			return;

		}
	}
}
void decoden(float *f,int x, int y, int w, int logsc)
{
	if (checkzero(f,x,y,w,logsc)) return;
	int sw=w>>3;if (sw<4) sw=4;
	int x2,y2;
	for (x2=x;x2<x+w;x2+=sw)
	for (y2=y;y2<y+w;y2+=sw)
	{
		rebuild(f,x2,y2,sw,logsc);
	}
}
void unpack(float *f)
{
	memset(covered,-1,sizeof(covered));
	decode0(f,0);
	decode0(f+8*W,1);
	decode0(f+8,2);
	decode0(f+8*W+8,3);
    int c3=0;
	for (int c2=16;c2<=128;c2<<=1,c3++)
	{
		decoden(f,c2,0,c2, c3);
		decoden(f,0,c2,c2, c3);
		decoden(f,c2,c2,c2, c3);
	}
}
void dewlet(float *a, float *b)
{
	int c1,c2;
	// dewavelet it
	//for (c1=0;c1<65536;c1++) a[c1]=CLP(a[c1]);	return;
    c2=4;
	for (c1=16;c1<=256;c1<<=1,c2++)
	{
		for (c2=0;c2<c1;c2++) unfilter6(a+W*c2,b+c2,c1);
         for (c2=0;c2<c1;c2++) unfilter6(b+W*c2,a+c2,c1);
                //for (c2=0;c2<c1;c2++) unfilter6b(a+c2,b+(c2<<LW),c1);
                //for (c2=0;c2<c1;c2++) unfilter6b(b+c2,a+(c2<<LW),c1);
	}
}

void showpic(int *m, int *c,int flip)
{
        int i,j,r,g,b;
        float y,cb,cr;
        for (j=0;j<H/2;j++)
        {
                for (i=0;i<W;i++)
                {
                        y=m[i+j*W];
                        cb=c[i/2+(j/2)*W];
                        cr=c[W-1-i/2+(j/2)*W];

                        //cb=cr=0;

                        r=128+ y + 1.402 * cr;
                        b=128+ y + 1.772 * cb;
                        g=128+ y - 0.34414* cb - 0.71414 * cr;

						/*

                        if (flip)
                        {
                                setpixel(i*2  ,(H/2-1-j)*3+0,r,0);
                                setpixel(i*2  ,(H/2-1-j)*3+1,g,64);
                                setpixel(i*2  ,(H/2-1-j)*3+2,b,128);
                                setpixel(i*2+1,(H/2-1-j)*3+1,r,0);
                                setpixel(i*2+1,(H/2-1-j)*3+0,g,64);
                                setpixel(i*2+1,(H/2-1-j)*3+2,b,128);

                        }
                        else
                        {
                                                setpixel(i*2+0,j*3+0,r,0);
                                                setpixel(i*2+0,j*3+1,g,64);
                                                setpixel(i*2+0,j*3+2,b,128);
                                                setpixel(i*2+1,j*3+1,r,0);
                                                setpixel(i*2+1,j*3+0,g,64);
                                                setpixel(i*2+1,j*3+2,b,128);

                        }
						*/

                }
        }        
}

#define CLIP 128
int cwlet,m1wlet,m2wlet;
float *tempbuf,*m1buf,*m2buf,*colbuf;
int curp;
int numframes;
int ytab[CLIP*2+256],crtab1[CLIP*2+256],crtab2[CLIP*2+256],cbtab1[CLIP*2+256],cbtab2[CLIP*2+256];
short redtab[CLIP*2+256],grntab[CLIP*2+256],blutab[CLIP*2+256];


void v_initcol()
{
	for (int c1=-128-CLIP;c1<127+CLIP;c1++)
	{
		ytab[c1+CLIP+128]=CLP(c1);
		crtab1[c1+CLIP+128]=CLP(c1*1.402);
		crtab2[c1+CLIP+128]=CLP(c1*0.71414);
		cbtab1[c1+CLIP+128]=CLP(c1*1.772);
		cbtab2[c1+CLIP+128]=CLP(c1*0.34414);
	}
}

void v_initrgb(int rc,int rp, int gc, int gp, int bc, int bp)
{
	rc=1<<rc;
	gc=1<<gc;
	bc=1<<bc;
	for (int c1=-128-CLIP;c1<127+CLIP;c1++)
	{
		redtab[c1+CLIP+128]=(((CLP(c1)+128)*rc)/256)<<rp;
		grntab[c1+CLIP+128]=(((CLP(c1)+128)*gc)/256)<<gp;
		blutab[c1+CLIP+128]=(((CLP(c1)+128)*bc)/256)<<bp;
	}
}
void v_initrgb(DDPIXELFORMAT *pf)
{
	v_initrgb(countbits(pf->dwRBitMask),countzeros(pf->dwRBitMask),
			  countbits(pf->dwGBitMask),countzeros(pf->dwGBitMask),
			  countbits(pf->dwBBitMask),countzeros(pf->dwBBitMask));
}
int v_init(char *fname)
{
	v_initcol();
	// read file

	int w,h,numpages,thrcol,thrmono;
	FILE *f=fopen(fname,"rb");		//film\\temp.ctl
	if (!f) return -1;
	numpages=w=h=thrmono=thrcol=0;
	fread(&numpages,1,2,f);
	fread(&w,1,2,f);if (w!=W) return -1;
	fread(&h,1,2,f);if (w!=H) return -1;
	fread(&thrmono,1,2,f);
	fread(&thrcol,1,2,f);
	fseek(f,0,SEEK_END);
	bufsize=ftell(f)-10;
	fseek(f,10,SEEK_SET);
	bitpos=1;bitcount=0;
	bufptr=buf=new char[bufsize];
	fread(buf,1,bufsize,f);
	fclose(f);

	// initialise

	m1buf=new float [W*H];
	colbuf=new float [W*H];
	tempbuf=new float[W*H];
    m2buf=new float [W*H];
	curp=0;
	
	return numframes=(numpages/3)*4;
}

void unpack2frame(int f)
{
	if (f>=numframes) return;
	if (f==0)
	{
		// reset buffer
		bitpos=1;bitcount=0;bufptr=buf;
		curp=0;
	}
	int p=f/2+1;
	while (p>curp) 
	{
		if (curp&1)
		{
			// just mono 2
			unpack(m2buf);
			m2wlet=0;
		}
		else
		{
			// mono 1 and col
			unpack(m1buf);
			unpack(colbuf);
			m1wlet=cwlet=0;
		}
		curp++;
	}
}


void viewframe(int f, short *out, int pitch)
{
	int i,j,cb,cr,y,crcb;
	float *buf,*cbuf,*cbuf2;

	unpack2frame(f);
	if (cwlet==0) {dewlet(colbuf,tempbuf);cwlet=1;}
	if ((f&2)==0)
	{
		if (m1wlet==0) dewlet(m1buf,tempbuf);
		m1wlet=1;
		buf=m1buf;
	}
	else
	{
		if (m2wlet==0) dewlet(m2buf,tempbuf);
		m2wlet=1;
		buf=m2buf;
	}
	cbuf=colbuf+(f&3)*W*(H/4);
	buf+=(f&1)*W*H/2;
	/*
	if (f&1)
	{
		// upside down...
		buf+=W*H/2-W;
		cbuf+=W*H/4-W;		
		cbuf2=cbuf+W/2;
		for (j=0;j<H/4;j++)
		{
			for (i=0;i<W/2;i++)
			{
				cb=cbtab1[CLIP+128+int(*cbuf)];
				cr=crtab1[CLIP+128+int(*cbuf2)];
				crcb=cbtab2[CLIP+128+int(*cbuf++)]+crtab2[CLIP+128+int(*cbuf2--)];
				
				y=ytab[CLIP+128+int(buf[0])]+CLIP+128;			
				out[0]=redtab[y+cr]|grntab[y-crcb]|blutab[y+cb];
				y=ytab[CLIP+128+int(buf[1])]+CLIP+128;			
				out[1]=redtab[y+cr]|grntab[y-crcb]|blutab[y+cb];				
				y=ytab[CLIP+128+int(buf[-W])]+CLIP+128;			
				out[pitch+0]=redtab[y+cr]|grntab[y-crcb]|blutab[y+cb];
				y=ytab[CLIP+128+int(buf[-W+1])]+CLIP+128;			
				out[pitch+1]=redtab[y+cr]|grntab[y-crcb]|blutab[y+cb];
				
				buf+=2;
				out+=2;
			}
			buf-=W*3;
			out+=pitch*2-W;
			cbuf-=W+W/2;
			cbuf2-=W/2;
		}
	}
	else
	*/
	{
		// sunny side up...
		cbuf2=cbuf+W-1;
		for (j=0;j<H/4;j++)
		{
			for (i=0;i<W/2;i++)
			{
				/*
				cb=cbtab1[CLIP+128+int(*cbuf)];
				cr=crtab1[CLIP+128+int(*cbuf2)];
				crcb=cbtab2[CLIP+128+int(*cbuf++)]+crtab2[CLIP+128+int(*cbuf2--)];
				//cr=cb=crcb=0;
				
				y=ytab[CLIP+128+int(buf[0])]+CLIP+128;			
				y=CLP(y-128-CLIP)+128+CLIP;
				out[0]=redtab[y+cr]|grntab[y-crcb]|blutab[y+cb];
				y=ytab[CLIP+128+int(buf[1])]+CLIP+128;			
				y=CLP(y-128-CLIP)+128+CLIP;
				out[1]=redtab[y+cr]|grntab[y-crcb]|blutab[y+cb];				
				y=ytab[CLIP+128+int(buf[W])]+CLIP+128;			
				y=CLP(y-128-CLIP)+128+CLIP;
				out[pitch+0]=redtab[y+cr]|grntab[y-crcb]|blutab[y+cb];
				y=ytab[CLIP+128+int(buf[W+1])]+CLIP+128;			
				y=CLP(y-128-CLIP)+128+CLIP;
				out[pitch+1]=redtab[y+cr]|grntab[y-crcb]|blutab[y+cb];
				*/

				y=CLP(buf[0])+128+CLIP;
				out[0]=redtab[y]|grntab[y]|blutab[y];
				y=CLP(buf[1])+128+CLIP;
				out[1]=redtab[y]|grntab[y]|blutab[y];
				y=CLP(buf[W])+128+CLIP;
				out[pitch]=redtab[y]|grntab[y]|blutab[y];
				y=CLP(buf[W+1])+128+CLIP;
				out[pitch+1]=redtab[y]|grntab[y]|blutab[y];
				
				buf+=2;
				out+=2;
			}
			buf+=W;
			out+=pitch*2-W;
			cbuf+=W/2;
			cbuf2+=W/2+W;
		}
	}
}

	


/*

int main(int argc, char *argv)
{
	// read file

	int w,h,numpages,thrcol,thrmono;
	FILE *f=fopen("film\\temp.ctl","rb");
	if (!f) return 1;
	numpages=w=h=thrmono=thrcol=0;
	fread(&numpages,1,2,f);
	fread(&w,1,2,f);if (w!=W) return 1;
	fread(&h,1,2,f);if (w!=H) return 1;
	fread(&thrmono,1,2,f);
	fread(&thrcol,1,2,f);
	fseek(f,0,SEEK_END);
	bufsize=ftell(f)-10;
	fseek(f,10,SEEK_SET);
	bitpos=1;bitcount=0;
	bufptr=buf=new char[bufsize];
	fread(buf,1,bufsize,f);
	fclose(f);

	// initialise
        int c1,c2,c3,c4,c5,c6;

	float *m1=new float [W*H];
        float *m2=new float [W*H];
        float *n1=new float [W*H];
	int *temp=new int [W*H];

        int *mt=multab;
        for (c1=-MULTABS;c1<MULTABS;c1++) *mt++= _C0 *c1 + 0.5;
        for (c1=-MULTABS;c1<MULTABS;c1++) *mt++= _C1 *c1 + 0.5;
        for (c1=-MULTABS;c1<MULTABS;c1++) *mt++= _C2 *c1 + 0.5;
        for (c1=-MULTABS;c1<MULTABS;c1++) *mt++= _C3 *c1 + 0.5;
        for (c1=-MULTABS;c1<MULTABS;c1++) *mt++= _C4 *c1 + 0.5;
        for (c1=-MULTABS;c1<MULTABS;c1++) *mt++= _C5 *c1 + 0.5;


#define SHOW
#ifdef SHOW
	_setvideomode(_VRES256COLOR);

	outp(0x3c8,0);
	for (c1=0;c1<64;c1++) {outp(0x3c9,c1);outp(0x3c9,0);outp(0x3c9,0);}
        for (c1=0;c1<64;c1++) {outp(0x3c9,0);outp(0x3c9,c1);outp(0x3c9,0);}
        for (c1=0;c1<64;c1++) {outp(0x3c9,0);outp(0x3c9,0);outp(0x3c9,c1);}
        for (c1=0;c1<64;c1++) {outp(0x3c9,c1);outp(0x3c9,c1);outp(0x3c9,c1);}
	int i=_imagesize(0,0,XMAX-1,YMAX-1);
	image=new char[i];
	_getimage(0,0,XMAX-1,YMAX-1,image);

#endif

        int numf=0;
        int t=Gettime();
        for (c2=0;c2<20;c2++)
	{
	bufptr=buf;bitpos=1;bitcount=0;
	for (c1=0;c1<numpages-15;c1+=3)
	{

                if (kbhit()) break;

		unpack(m1,thrmono);
                unpack(n1,thrcol);
                unpack(m2,thrmono);

                //dewlet(m1,(float*)temp);
                //dewlet(n1,(float*)temp);
                //dewlet(m2,(float*)temp);


                dewletnew(m1,temp);
                dewletnew(n1,temp);
                dewletnew(m2,temp);


                numf+=4;

#ifdef SHOW



                showpic((int*)m1,(int*)n1,0);
                showpic((int*)m1+W*H/2,(int*)n1+W*H/4,1);
                showpic((int*)m2,(int*)n1+2*W*H/4,0);
                showpic((int*)m2+W*H/2,(int*)n1+3*W*H/4,1);
#endif


	}
        }
#ifdef SHOW
       _setvideomode(3);
#endif


        t=Gettime()-t;
        float fps;
        printf("%6.3f ms\n%d frames, %6.3f fps\n",t*1024.0/300000.0f,numf,fps=numf*1000/(t*1024.0/300000.0f));

        printf("%6.3f %% cpu\n",1000.f/fps);
	return 0;

}

*/