/* 256x256x32bits TEXTURE GENERATOR
 * decode routine - optimized for size
 * code by dake/calodox - July 99
 */


#include "main.h"
#include "nmlcol.h"
#include "nmldec.h"
#include "nmlflt.h"
#include "nmlfx.h"
#include "nmlgen.h"

 #include "savehead.h"

#define uchar unsigned char 


void ol_error( const char *msg, ... ) {
	va_list arglist;
	char bla[256];

	va_start(arglist, msg);

	vsprintf(bla,msg,arglist);
	MessageBox(NULL,bla,"Jimmy Hendrix's dead",MB_OK|MB_ICONERROR);
	va_end(arglist);	

}

void ol_error_number( int number ) {
	va_list arglist;
	char bla[256];

	sprintf(bla,"%d",number);
	MessageBox(NULL,bla,"Elvis Presley's dead",MB_ICONERROR);	

}

void ol_error_fnumber( float number ) {
	va_list arglist;
	char bla[256];

	sprintf(bla,"%f",number);
	MessageBox(NULL,bla,"Jim's dead",MB_ICONERROR);	

}

void ol_error_number2( int n1, int n2 ) {
	va_list arglist;
	char bla[256];

	sprintf(bla,"%d  %d",n1, n2);
	MessageBox(NULL,bla,"Kurt Cobain's dead",MB_ICONERROR);	

}



void NML_memcopy(uchar *source, uchar *dest, int sizeb)
     {
     int n;
       for (n=0;n<sizeb;n++)
           {
           dest[n]=source[n];
           }
     }

void NML_decode_texture(uchar *texture, uchar *nml_buffer, int nml_size)
     {
     uchar temp[256*256*4];
     int   nml_ptr=3,n;
     uchar read_byte;
     int   p[20];  //parameters
     float pp1, pp2, pp3;


      for (n=0;n<256*256*4;n++) texture[n]=0;

       //printf("newtexture\n");
       do {

          checkagain:;

          if (nml_ptr>=nml_size) return;

          read_byte=nml_buffer[nml_ptr];
          if (read_byte==0xFF && nml_buffer[nml_ptr+1]==0xFF) return;


            /*****************************************/
            if (read_byte==CHUNK_GEN_PLASMA)
            {
            p[1]=nml_buffer[nml_ptr+1];         //freqx
            p[2]=nml_buffer[nml_ptr+2];         //freqy
            p[3]=nml_buffer[nml_ptr+3];         //offx
            p[4]=nml_buffer[nml_ptr+4];         //offy
            p[5]=nml_buffer[nml_ptr+5];         //plasmr
            p[6]=nml_buffer[nml_ptr+6];         //plasmg
            p[7]=nml_buffer[nml_ptr+7];         //plasmb
            p[8]=nml_buffer[nml_ptr+8];         //plasma
            p[9]=nml_buffer[nml_ptr+9];         //plasmblend

            nml_ptr+=10;

            NML_GENPLASMA(texture, p[3], p[4], p[1], p[2],
                          p[5], p[6], p[7], p[8], p[9]);

            //printf("1");

			ol_error( "plasma");
            goto checkagain;
            }
            /*****************************************/
            /*****************************************/
             if (read_byte==CHUNK_GEN_NOISE)
                {
                 p[1]=nml_buffer[nml_ptr+1];                 //typenoise
                 p[2]=*((short*)&nml_buffer[nml_ptr+2]);     //seed
                 p[3]=nml_buffer[nml_ptr+4];                 //noise amount
                 nml_ptr+=5;
                 NML_GENNOISE(texture, p[3], p[1]);

            //printf("2");
				ol_error( "noise");
                goto checkagain;
                }
            /*****************************************/
            /*****************************************/
            if (read_byte==CHUNK_GEN_FILL)
               {
                p[1]=nml_buffer[nml_ptr+1];                 //R
                p[2]=nml_buffer[nml_ptr+2];                 //G
                p[3]=nml_buffer[nml_ptr+3];                 //B
                nml_ptr+=4;
                NML_GENCOLOR(texture, p[1], p[2], p[3]);

            //printf("3");

				ol_error( "fill");
                goto checkagain;
               }
            /*****************************************/
            /*****************************************/
            if (read_byte==CHUNK_FX_SINUS)
               {
                p[1]=nml_buffer[nml_ptr+1];                 //xamp
                p[2]=nml_buffer[nml_ptr+2];                 //yamp
                p[3]=nml_buffer[nml_ptr+3];                 //xfreq
                p[4]=nml_buffer[nml_ptr+4];                 //xfreq
                nml_ptr+=5;
                NML_FXSINUS(texture, temp, (float) p[1], (float) p[3],
                           (float) p[2], (float) p[4]);
                NML_memcopy(temp, texture, 256*256*4);

				ol_error( "sinus");
            //printf("4");

                goto checkagain;
               }
            /*****************************************/
            /*****************************************/
            if (read_byte==CHUNK_FX_BUMP)
               {
                pp1=*((float*) &nml_buffer[nml_ptr+1]);                
                pp2=*((float*) &nml_buffer[nml_ptr+5]);               
                pp3=*((float*) &nml_buffer[nml_ptr+9]);            
                nml_ptr+=13;
                NML_FXBUMP(texture, temp, pp1, pp2, pp3);
                NML_memcopy(temp, texture, 256*256*4);

				ol_error( "bump");
            //printf("5");

                goto checkagain;
               }
            /*****************************************/
            /*****************************************/
            if (read_byte==CHUNK_FX_DILATE)
               {
                pp1=*((float*) &nml_buffer[nml_ptr+1]);                
                nml_ptr+=5;
                NML_FXDILATE(texture, temp, pp1);
                NML_memcopy(temp, texture, 256*256*4);

				ol_error( "dilate");
            //printf("6");

                goto checkagain;
               }
            /*****************************************/
            /*****************************************/
            if (read_byte==CHUNK_FX_DISPLACE)
               {
                p[1]=nml_buffer[nml_ptr+1];         //DX             
                p[2]=nml_buffer[nml_ptr+2];         //DY        
                nml_ptr+=3;
                NML_FXDISPLACE(texture, temp, p[1], p[2]);
                NML_memcopy(temp, texture, 256*256*4);

				ol_error( "displace");
            //printf("7");

                goto checkagain;
               }
            /*****************************************/
            /*****************************************/
            if (read_byte==CHUNK_FILT_GAUSSIAN)
               {
                p[1]=nml_buffer[nml_ptr+1];         //passes.            
                nml_ptr+=2;
                for (p[2]=0;p[2]<p[1];p[2]++)       //gaussian loop
                        {
                         NML_FILTBLUR(texture);
                        }

            //printf("8");
				
				ol_error( "gaussian");

                goto checkagain;
               }
            /*****************************************/
            /*****************************************/
            if (read_byte==CHUNK_FILT_SHARPEN)
               {
                nml_ptr+=1;
                NML_FILTSHARPEN(texture);

            //printf("9");

				ol_error( "sharpen");
                goto checkagain;
               }
            /*****************************************/
            /*****************************************/
            if (read_byte==CHUNK_FILT_STRIPES)
               {
                nml_ptr+=1;
                NML_FILTSTRIPES(texture, temp);
                NML_memcopy(temp, texture, 256*256*4);
            //printf("10");

				ol_error( "stripes");
			
                goto checkagain;
               }
            /*****************************************/
            /*****************************************/
            if (read_byte==CHUNK_FILT_EMBOSS)
               {
                nml_ptr+=1;
                NML_FILTEMBOSS(texture, temp);
                NML_memcopy(temp, texture, 256*256*4);
            //printf("11");

				ol_error( "emboss");


                goto checkagain;
               }
            /*****************************************/
            /*****************************************/
            if (read_byte==CHUNK_FILT_CONTOUR)
               {
                nml_ptr+=1;
                NML_FILTCONTOUR(texture, temp);
                NML_memcopy(temp, texture, 256*256*4);
            //printf("12");
				ol_error( "contour");


                goto checkagain;
               }
            /*****************************************/
            /*****************************************/
            if (read_byte==CHUNK_COL_INVERT)
               {
                nml_ptr+=1;
                NML_COLINVERT(texture);
            //printf("13")
				ol_error( "invert");


                goto checkagain;
               }
            /*****************************************/
            /*****************************************/
            if (read_byte==CHUNK_COL_GREYSCALE)
               {
                nml_ptr+=1;
                NML_COLGREYSCALE(texture);
            //printf("14");

				ol_error( "greyscale");

                goto checkagain;
               }
            /*****************************************/
            /*****************************************/
            if (read_byte==CHUNK_COL_BRIGHTCONT)
               {
				return;


                pp1=*((float*) &nml_buffer[nml_ptr+1]);     //b               
                pp2=*((float*) &nml_buffer[nml_ptr+5]);     //c           
                nml_ptr+=9;
                NML_COLCONTRAST(texture,pp2,pp1);
            //printf("15");


				ol_error( "bctst");
                goto checkagain;
               }
            /*****************************************/
            /*****************************************/
            if (read_byte==CHUNK_COL_RGB)
               {
                p[1]=nml_buffer[nml_ptr+1];         //R             
                p[2]=nml_buffer[nml_ptr+2];         //G
                p[3]=nml_buffer[nml_ptr+3];         //B
                nml_ptr+=4;
                NML_COLRGB(texture,(float) p[1],(float) p[2],(float)p[3]);
			ol_error( "rgb");
            //printf("16");

                goto checkagain;
               }

             //printf("ERROR IN TEXTURTE ! %d\n", read_byte);
            /*****************************************/
     
		//	nml_ptr++;
       }while(nml_ptr<nml_size); 


	   
	   ol_error( "end of t");

     }


