//
//                       __      __      _  __ 
//                   .: (__ (__ (--) >-< ( (-_ :.
//
//
// (c) Copyright 1997 Mikko E. Mononen <memon@inside.org>
//


#ifndef __MISC_HH__
#define __MISC_HH__

#include "clax.h"

extern long  sqrttab[];

float  vec_apxlength( c_VECTOR *a );
void   vec_apxnormalize( c_VECTOR *a, c_VECTOR *res );
float  vec_fastlength( c_VECTOR *a );
void   vec_fastnormalize( c_VECTOR *a, c_VECTOR *res );
int32  mat_inverse_c (c_MATRIX a, c_MATRIX out);
float  fsqrt( float a );
int32  insideViewCone( float ratioX, float ratioY, c_VECTOR* vec, float r );


void
ffabs( float* num );
#pragma aux ffabs = \
 "mov eax, [ebx]"\
 "and eax, 7fffffffh"\
 "mov [ebx], eax"\
 parm [ebx]\
 modify [eax ebx];

long
isneg( float* num );
#pragma aux isneg = \
 "  mov  eax, [ebx]          "\
 "  xor  ebx, ebx            "\
 "  cmp  eax, 80000000h      "\
 "  jb   @@isnneg            "\
 "  dec  ebx                 "\
 "@@isnneg:                  "\
 parm [ebx] \
 value [ebx] \
 modify [eax ebx];

long
ispos( float* num );
#pragma aux ispos = \
 "  mov  eax, [ebx]          "\
 "  xor  ebx, ebx            "\
 "  cmp  eax, 80000000h      "\
 "  ja  @@isnpos             "\
 "  dec  ebx                 "\
 "@@isnpos:                  "\
 parm [ebx] \
 value [ebx] \
 modify [eax ebx];

long
iszero( float* num );
#pragma aux iszero = \
 "  mov  eax, [ebx]          "\
 "  xor  ebx, ebx            "\
 "  add  eax, eax            "\
 "  jnz  @@isnzero           "\
 "  dec  ebx                 "\
 "@@isnzero:                 "\
 parm [ebx] \
 value [ebx] \
 modify [eax ebx];


inline
void
mat_mulvecto (c_MATRIX a, c_VECTOR *b, c_VECTOR *out)
{
  out->x = b->x*a[X][X] + b->y*a[X][Y] + b->z*a[X][Z] + a[X][W];
  out->y = b->x*a[Y][X] + b->y*a[Y][Y] + b->z*a[Y][Z] + a[Y][W];
  out->z = b->x*a[Z][X] + b->y*a[Z][Y] + b->z*a[Z][Z] + a[Z][W];
}

inline
void
mat_mulnormto (c_MATRIX a, c_VECTOR *b, c_VECTOR *out)
{
  out->x = b->x*a[X][X] + b->y*a[X][Y] + b->z*a[X][Z];
  out->y = b->x*a[Y][X] + b->y*a[Y][Y] + b->z*a[Y][Z];
  out->z = b->x*a[Z][X] + b->y*a[Z][Y] + b->z*a[Z][Z];
}

inline
float
pow2( float a )
{
  return a * a;
}

#endif