#include <stdlib.h>
#include <math.h>
#include <conio.h>
#include "hires256.h"
#include "stuff.h"
#include "phongpal.h"
#include "obj3d.h"
#include "triangle.h"
#include "polygons.h"
#include "vectors.h"
#include "scenes.h"
#include "cameras.h"
#include "knots.h"

//picture files
#include "antalla5.h"

// 3d files
#include "toro1.h"
#include "toro2.h"
#include "toro3.h"
#include "toro4.h"


// fast float to int conversion
#ifndef DTOI_MAGIK
#define DTOI_MAGIK ((((65536.0 * 65536.0 * 16) + (65536.0 * 0.5)) * 65536.0))

int dtoi(double n) {
	double temp = DTOI_MAGIK + n;
	return ((*(int *)&temp) - 0x80000000);
}
#endif


#define NumKnots 10

TScene *KnotsScene;
TPalette KnotsPal[16];

void Knots_Setup() {
        TObject3D *o;
        TPalette pal;
        double a;

        KnotsScene = new TScene();
        for (int i = 0; i < NumKnots; i++) {
                o = new TObject3D();
                switch (i % 4) {
                        case 0: Read3DObject(TORO1_VKX, o); break;
                        case 1: Read3DObject(TORO2_VKX, o); break;
                        case 2: Read3DObject(TORO3_VKX, o); break;
                        case 3: Read3DObject(TORO4_VKX, o); break;
                }
                o->Centre();
                o->FitSphere(1.0);
                o->Rotate(rand() % 1440, rand() % 1440, rand() % 1440);
                a = i * 3.0 * Pi / (double)NumKnots;
                o->origin.SetP((2.0 + i / 3.0) * cos(a), (2.0 + i / 3.0) * sin(a), 1);
                o->Traslate(0, (i + 1) * 0.5, -(i + 1) * 0.5);
                o->SetColor(128 + (i % 4) * 32, 15);
                o->SetStyle(c_flatshaded);
                KnotsScene->AddObject(o);
        }

        CopyPalette(ANTALLA5_PAL, pal, 0, 127);
        PhongPal(0.0, 0.7, 1.0, 0, 0.2, 1.0, 0.0, 0.1, 1.0, 10, pal, 128, 32);
        PhongPal(0.0, 0.2, 1.0, 0, 0.7, 1.0, 0.0, 0.1, 1.0, 10, pal, 160, 32);
        PhongPal(0.0, 0.7, 1.0, 0, 0.7, 1.0, 0.0, 0.1, 1.0, 10, pal, 192, 32);
        PhongPal(0.0, 0.7, 1.0, 0, 0.2, 1.0, 0.0, 0.8, 1.0, 10, pal, 224, 32);

        for (i = 0; i < 16; i++) {
                CopyPalette(pal, KnotsPal[i], 0, 255);
                FadePalette(pal, 0, 127);
                FadePalette(pal, 0, 127);
                FadePalette(pal, 0, 127);
                FadePalette(pal, 0, 127);
        }
}

void Knots_Free() {
        delete KnotsScene;
}


void Knots() {
        TVirtual *vs = new TVirtual;
        TPalette pal;
        int i;
        double a = 0.0, ang, z = 0;

        CopyPalette(ANTALLA5_PAL, pal, 0, 127);
        PhongPal(0.0, 0.7, 1.0, 0, 0.2, 1.0, 0.0, 0.1, 1.0, 10, pal, 128, 32);
        PhongPal(0.0, 0.2, 1.0, 0, 0.7, 1.0, 0.0, 0.1, 1.0, 10, pal, 160, 32);
        PhongPal(0.0, 0.7, 1.0, 0, 0.7, 1.0, 0.0, 0.1, 1.0, 10, pal, 192, 32);
        PhongPal(0.0, 0.7, 1.0, 0, 0.2, 1.0, 0.0, 0.8, 1.0, 10, pal, 224, 32);

        HClearScreen(0, SCREEN_OFF);
        HCopyScreen((unsigned int)ANTALLA5, (unsigned int)vs);
        SetPalette(pal);
        camera->location.SetP(0, 0, -5);
        SetLightPosition(1, 1, -1.5);

        GetMusicInfo();
        while ((position == 28) || (row < 48)) {
                camera->location.SetP(0, 0, -5.0 + 1.0 * sin(z));
                z += 0.1;
                camera->az = (camera->az + 4) % 1440;

                KnotsScene->Draw((unsigned int)vs);

                SetPalette(pal);
                HCopyAndCopy((unsigned int)vs, SCREEN_OFF, (unsigned int)ANTALLA5);

                for (i = 0; i < NumKnots; i++) {
                        ang = a + i * 0.5;
                        KnotsScene->obj[i]->FlatRotate( dtoi(10.0 * cos(ang)),
                                                        dtoi(10.0 * sin(ang)), 
                                                        dtoi(10.0 * sin(ang * 2.0)));
                }

                a += 0.01;
                Light.Rotate(0, 0, -8);

                if ((row & 31) < 15) FadePalette(pal, 0, 127);
                else FadePaletteTo(pal, ANTALLA5_PAL, 0, 127);

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        for (i = 0; i < NumKnots; i++) {
                KnotsScene->obj[i]->SetColor(128 + (i % 4) * 32 + 24, 15);
                KnotsScene->obj[i]->SetStyle(c_wireframe);
        }

        while (position < 30) {
                camera->location.SetP(0, 0, -5.0 + 1.0 * sin(z));
                z += 0.1;
                camera->az = (camera->az + 4) % 1440;
                KnotsScene->Draw((unsigned int)vs);

                SetPalette(pal);
                HCopyAndCopy((unsigned int)vs, SCREEN_OFF, (unsigned int)ANTALLA5);

                for (i = 0; i < NumKnots; i++) {
                        ang = a + i * 0.5;
                        KnotsScene->obj[i]->FlatRotate( dtoi(10.0 * cos(ang)),
                                                        dtoi(10.0 * sin(ang)), 
                                                        dtoi(10.0 * sin(ang * 2.0)));
                }

                a += 0.01;
                Light.Rotate(0, 0, -8);

                if ((row & 31) < 15) FadePalette(pal, 0, 127);
                else FadePaletteTo(pal, ANTALLA5_PAL, 0, 127);

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        for (i = 0; i < NumKnots; i++) {
                KnotsScene->obj[i]->SetColor(128 + (i % 4) * 32, 15);
                KnotsScene->obj[i]->SetStyle(c_flatshaded);
        }

        while (row < 32) {
                camera->location.SetP(0, 0, -5.0 + 1.0 * sin(z));
                z += 0.1;
                camera->az = (camera->az + 4) % 1440;
                KnotsScene->Draw((unsigned int)vs);

                SetPalette(KnotsPal[rand() & 15]);
                HCopyAndCopy((unsigned int)vs, SCREEN_OFF, (unsigned int)ANTALLA5);

                for (i = 0; i < NumKnots; i++) {
                        ang = a + i * 0.5;
                        KnotsScene->obj[i]->FlatRotate( dtoi(10.0 * cos(ang)),
                                                        dtoi(10.0 * sin(ang)), 
                                                        dtoi(10.0 * sin(ang * 2.0)));
                }

                a += 0.01;
                Light.Rotate(0, 0, -8);

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        for (i = 0; i < NumKnots; i++) {
                KnotsScene->obj[i]->SetColor(128 + (i % 4) * 32 + 24, 15);
                KnotsScene->obj[i]->SetStyle(c_wireframe);
        }

        while (row < 40) {
                camera->location.SetP(0, 0, -5.0 + 1.0 * sin(z));
                z += 0.1;
                camera->az = (camera->az + 4) % 1440;
                KnotsScene->Draw((unsigned int)vs);

                SetPalette(KnotsPal[rand() & 15]);
                HCopyAndCopy((unsigned int)vs, SCREEN_OFF, (unsigned int)ANTALLA5);

                for (i = 0; i < NumKnots; i++) {
                        ang = a + i * 0.5;
                        KnotsScene->obj[i]->FlatRotate( dtoi(10.0 * cos(ang)),
                                                        dtoi(10.0 * sin(ang)), 
                                                        dtoi(10.0 * sin(ang * 2.0)));
                }

                a += 0.01;
                Light.Rotate(0, 0, -8);

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        for (i = 0; i < NumKnots; i++) {
                KnotsScene->obj[i]->SetColor(128 + (i % 4) * 32, 15);
                KnotsScene->obj[i]->SetStyle(c_flatshaded);
        }

        while ((position == 30) || (row < 32)) {
                camera->location.SetP(0, 0, -5.0 + 1.0 * sin(z));
                z += 0.1;
                camera->az = (camera->az + 4) % 1440;
                KnotsScene->Draw((unsigned int)vs);

                SetPalette(KnotsPal[rand() & 15]);
                HCopyAndCopy((unsigned int)vs, SCREEN_OFF, (unsigned int)ANTALLA5);

                for (i = 0; i < NumKnots; i++) {
                        ang = a + i * 0.5;
                        KnotsScene->obj[i]->FlatRotate( dtoi(10.0 * cos(ang)),
                                                        dtoi(10.0 * sin(ang)), 
                                                        dtoi(10.0 * sin(ang * 2.0)));
                }

                a += 0.01;
                Light.Rotate(0, 0, -8);

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        while (position < 32) {
                camera->location.SetP(0, 0, -5.0 + 1.0 * sin(z));
                z += 0.1;
                camera->az = (camera->az + 4) % 1440;
                KnotsScene->Draw((unsigned int)vs);

                SetPalette(KnotsPal[(row - 32) >> 1]);
                HCopyAndCopy((unsigned int)vs, SCREEN_OFF, (unsigned int)ANTALLA5);

                for (i = 0; i < NumKnots; i++) {
                        ang = a + i * 0.5;
                        KnotsScene->obj[i]->FlatRotate( dtoi(10.0 * cos(ang)),
                                                        dtoi(10.0 * sin(ang)), 
                                                        dtoi(10.0 * sin(ang * 2.0)));
                }

                a += 0.01;
                Light.Rotate(0, 0, -8);

                GetMusicInfo();
                if (kbhit() && (getch() == 27)) { lastresult = NOT_OK; return; }
        }

        delete vs;
}
