
// CHARSET.H

#ifndef _CHARSET_
#define _CHARSET_

#include "mode13.h"

typedef struct { int x, y; } TCharInfo;

typedef struct {
	TCharInfo Chars[256];
	unsigned char SizeX, SizeY;
	char charmap[13];
} TCharSetInfo;


class TTextInfo {
	public:
		char txt[81];
		int x, y, hs;
		TTextInfo *next;
		
		TTextInfo(int nx, int ny, char *s, int nhs);
		~TTextInfo();
};


class TCharSet {
	public:
		TCharSetInfo Info;
		unsigned int MapOff;
		TTextInfo *AllText;
		TPalette Palette;
	
		TCharSet();
		~TCharSet();
		
		void PrintChar(int x, int y, char c, unsigned int where);
                void PrintString(int y, char *s, int hs, unsigned int where);
		void PrintRight(int y, char *s, int hs, unsigned int where);
		void AddText(int x, int y, char *s, int hs);
		void ClearText();
		void PrintAll(unsigned int where);
};

#endif
