
unit INNAdraw;

interface

uses FVektor2, Mode13, XMS;

var HBig : XMSHandle;

type PTRotoZoom = ^TRotoZoom;
     TRotoZoom = object
                private
                       map : PTTexture;
                       StartX, StartY : word;
                       Ux, Uy, Vx, Vy : Fixed;

                public
                      palette : TPalette;

                      constructor Init(newmap : PTTexture; newpal : TPalette);

                      procedure Draw(where, off : word);
                      procedure DrawFull(where, off : word; lines : byte);
                      procedure Move(sx, sy : word);
                      procedure Rotate(az : integer);
                      procedure Scale(fs : Fixed);
                      procedure ScaleUV(us, vs : single);
                end;

{ Scaling procs }

procedure Scale(sx1, sy1, sx2, sy2, source, dx1, dy1, dx2, dy2, dest : word);
procedure TransScale(sx1, sy1, sx2, sy2, source, dx1, dy1, dx2, dy2, dest : word);
procedure ScaleScreen(src, dst : word);

{ Drawing procs }

procedure DrawPicture(pic : pointer; xsize, ysize, start, offadd, where : word);
procedure FadeBlurTo0(step : byte; where : word);
procedure FadeBlurTo128(step : byte; where : word);

{ Other procs }
procedure MapSection(xs, ys : longint; where : word);

implementation

constructor TRotoZoom.Init(newmap : PTTexture; newpal : TPalette);
begin
     map := newmap;
     palette := newpal;
     StartX := 0;
     StartY := 0;
     Ux := 65536;
     Uy := 0;
     Vx := 0;
     Vy := -65536;
end;

procedure TRotoZoom.Draw(where, off : word);
var mu, mv, dux, duy, dvx, dvy, ui, vi : Fixed;
    mapseg : word;
begin
     mu := (FSquare(ux) + FSquare(uy)) shl 8;
     mv := (FSquare(vx) + FSquare(vy)) shl 8;

     dux := FDiv(ux, mu);
     duy := -FDiv(uy, mu);
     dvx := FDiv(vx, mv);
     dvy := -FDiv(vy, mv);

     ui := -StartX * dux - StartY * duy;
     vi := -StartX * dvx - StartY * dvy;

     mapseg := seg(map^);
     asm
        mov ax, mapseg
        mov es, where
        mov di, off
        db $8E, $E0  { mov fs, ax }
        mov ch, 100

        @loopy:  mov si, word ptr [vi]
                 mov dx, word ptr [ui]
                 mov cl, 80   { contador x }

        @loopx:  mov bx, si
                 db long; add si, word ptr [dvx]
                 mov bl, dh
                 db long; add dx, word ptr [dux]
                 db $64, $8A, $07   { mov al, fs:[bx] }

                 mov bx, si
                 db long; add si, word ptr [dvx]
                 mov bl, dh
                 db long; add dx, word ptr [dux]
                 db $64, $8A, $27   { mov ah, fs:[bx] }
                 db long; shl ax, 16;

                 mov bx, si
                 db long; add si, word ptr [dvx]
                 mov bl, dh
                 db long; add dx, word ptr [dux]
                 db $64, $8A, $07   { mov al, fs:[bx] }

                 mov bx, si
                 db long; add si, word ptr [dvx]
                 mov bl, dh
                 db long; add dx, word ptr [dux]
                 db $64, $8A, $27   { mov ah, fs:[bx] }
                 add di, 4
                 db long; rol ax, 16
                 db long; mov word ptr es:[di], ax
                 dec cl
                 jnz @loopx

                 db long; mov bx, word ptr [duy]
                 db long; mov ax, word ptr [dvy]
                 add di, 320
                 db long; add word ptr [ui], bx
                 db long; add word ptr [vi], ax
                 dec ch
                 jnz @loopy
     end;
end;

procedure TRotoZoom.DrawFull(where, off : word; lines : byte);
var mu, mv, dux, duy, dvx, dvy, ui, vi : Fixed;
    mapseg : word;
begin
     mu := (FSquare(ux) + FSquare(uy)) shl 8;
     mv := (FSquare(vx) + FSquare(vy)) shl 8;

     dux := FDiv(ux, mu);
     duy := -FDiv(uy, mu);
     dvx := FDiv(vx, mv);
     dvy := -FDiv(vy, mv);

     ui := -StartX * dux - StartY * duy;
     vi := -StartX * dvx - StartY * dvy;

     mapseg := seg(map^);
     asm
        mov ax, mapseg
        mov es, where
        mov di, off
        db $8E, $E0  { mov fs, ax }
        mov ch, lines

        @loopy:  mov si, word ptr [vi]
                 mov dx, word ptr [ui]
                 mov cl, 80   { contador x }

        @loopx:  mov bx, si
                 db long; add si, word ptr [dvx]
                 mov bl, dh
                 db long; add dx, word ptr [dux]
                 db $64, $8A, $07   { mov al, fs:[bx] }

                 mov bx, si
                 db long; add si, word ptr [dvx]
                 mov bl, dh
                 db long; add dx, word ptr [dux]
                 db $64, $8A, $27   { mov ah, fs:[bx] }
                 db long; shl ax, 16;

                 mov bx, si
                 db long; add si, word ptr [dvx]
                 mov bl, dh
                 db long; add dx, word ptr [dux]
                 db $64, $8A, $07   { mov al, fs:[bx] }

                 mov bx, si
                 db long; add si, word ptr [dvx]
                 mov bl, dh
                 db long; add dx, word ptr [dux]
                 db $64, $8A, $27   { mov ah, fs:[bx] }
                 add di, 4
                 db long; rol ax, 16
                 db long; mov word ptr es:[di], ax
                 dec cl
                 jnz @loopx

                 db long; mov bx, word ptr [duy]
                 db long; mov ax, word ptr [dvy]
                 db long; add word ptr [ui], bx
                 db long; add word ptr [vi], ax
                 dec ch
                 jnz @loopy
     end;
end;

procedure TRotoZoom.Move(sx, sy : word);
begin
     StartX := sx;
     StartY := sy;
end;


procedure TRotoZoom.Rotate(az : integer);
var nx, ny : FIxed;
begin
     if az < 0 then inc(az, 360);
     nx := FMul(ux, cost[az]) - FMul(uy, sint[az]);
     ny := FMul(ux, sint[az]) + FMul(uy, cost[az]);
     ux := nx;
     uy := ny;
     nx := FMul(vx, cost[az]) - FMul(vy, sint[az]);
     ny := FMul(vx, sint[az]) + FMul(vy, cost[az]);
     vx := nx;
     vy := ny;
end;


procedure TRotoZoom.Scale(fs : Fixed);
begin
     ux := FMul(ux, fs);
     uy := FMul(uy, fs);
     vx := FMul(vx, fs);
     vy := FMul(vy, fs);
end;

procedure TRotoZoom.ScaleUV(us, vs : single);
var ss : Fixed;
begin
     ss := round(us * 65536);
     ux := FMul(ux, ss);
     uy := FMul(uy, ss);
     ss := round(vs * 65536);
     vx := FMul(vx, ss);
     vy := FMul(vy, ss);
end;


{ Scaling procs }
procedure Scale(sx1, sy1, sx2, sy2, source, dx1, dy1, dx2, dy2, dest : word);
var dsx, dsy, ddx, ddy, stepx, stepy, tempy, tempx : Fixed;
    tempdx : word;
begin
     dsx := Fixed(sx2 - sx1) shl 16;
     dsy := Fixed(sy2 - sy1) shl 16;
     ddx := Fixed(dx2 - dx1) shl 16;
     ddy := Fixed(dy2 - dy1) shl 16;
     stepx := FDiv(dsx, ddx);
     stepy := FDiv(dsy, ddy);
     tempx := Fixed(sx1) shl 16;
     tempy := Fixed(sy1) shl 16;
     tempdx := dx2 - dx1;
     asm
        mov ax, source
        mov es, dest
        mov bx, dy1
        shl bx, 1
        mov di, word ptr [YOffset + bx]
        db $8E, $E8      { mov gs, ax }
        db long; xor ax, ax  { xor eax, eax }
        db long; xor si, si  { xor esi, esi }
        add di, dx1
        mov dh, byte ptr [ddy + 2]

        @loopy:  db long; mov bx, word ptr [tempy]
                 db long; shr bx, 16
                 shl bx, 1
                 db long; mov si, word ptr [tempx]
                 mov ax, word ptr [YOffset + bx]
                 mov cx, word ptr [ddx + 2]

        @loopx:  db long; mov bx, si
                 db long; add si, word ptr [stepx]
                 db long; shr bx, 16
                 add bx, ax
                 db $65; mov dl, [bx]  { mov dl, gs:[bx] }
                 mov es:[di], dl
                 inc di
                 dec cx
                 jnz @loopx

                 add di, 320
                 db long; mov bx, word ptr [stepy]
                 db long; add word ptr [tempy], bx
                 sub di, tempdx
                 dec dh
                 jnz @loopy
     end;
end;

procedure TransScale(sx1, sy1, sx2, sy2, source, dx1, dy1, dx2, dy2, dest : word);
var dsx, dsy, ddx, ddy, stepx, stepy, tempy, tempx : Fixed;
    tempdx : word;
begin
     dsx := Fixed(sx2 - sx1) shl 16;
     dsy := Fixed(sy2 - sy1) shl 16;
     ddx := Fixed(dx2 - dx1) shl 16;
     ddy := Fixed(dy2 - dy1) shl 16;
     stepx := FDiv(dsx, ddx);
     stepy := FDiv(dsy, ddy);
     tempx := Fixed(sx1) shl 16;
     tempy := Fixed(sy1) shl 16;
     tempdx := dx2 - dx1;
     asm
        mov ax, source
        mov es, dest
        mov bx, dy1
        shl bx, 1
        mov di, word ptr [YOffset + bx]
        db $8E, $E8      { mov gs, ax }
        db long; xor ax, ax  { xor eax, eax }
        db long; xor si, si  { xor esi, esi }
        add di, dx1
        mov dh, byte ptr [ddy + 2]

        @loopy:  db long; mov bx, word ptr [tempy]
                 db long; shr bx, 16
                 shl bx, 1
                 db long; mov si, word ptr [tempx]
                 mov ax, word ptr [YOffset + bx]
                 mov cx, word ptr [ddx + 2]

        @loopx:  db long; mov bx, si
                 db long; add si, word ptr [stepx]
                 db long; shr bx, 16
                 add bx, ax
                 db $65; mov dl, [bx]  { mov dl, gs:[bx] }
                 or dl, dl
                 jz @jump
                 mov es:[di], dl
        @jump:   inc di
                 dec cx
                 jnz @loopx

                 add di, 320
                 db long; mov bx, word ptr [stepy]
                 db long; add word ptr [tempy], bx
                 sub di, tempdx
                 dec dh
                 jnz @loopy
     end;
end;

    procedure ScaleScreen(src, dst : word);
    begin
         Scale(0, 0, 319, 199, src, 40, 25, 120, 75, dst);
         HLine(39, 121, 24, 255, dst);
         HLine(39, 121, 76, 255, dst);
         asm
            mov es, dst
            mov di, 7719
            mov al, 255
            mov cx, 52
            @loopy:  mov es:[di], al
                     mov es:[di+82], al
                     add di, 320
                     dec cx
                     jnz @loopy
         end;
    end;


{ Drawing procs }
{ Dibujo de imgenes estticas transparentes }
procedure DrawPicture(pic : pointer; xsize, ysize, start, offadd,
                      where : word); assembler;
asm
   push ds
   mov es, where
   mov di, start
   mov bx, offadd
   mov ds, word ptr [pic + 2]
   mov si, word ptr [pic]
   mov dx, ysize
   @loopy:   mov cx, xsize
   @loopx:   mov al, [si]
             or al, al
             jz @jump
             mov es:[di], al
   @jump:    inc di
             inc si
             dec cx
             jnz @loopx
             add di, bx
             dec dx
             jnz @loopy
             pop ds
end;

{ Estela de movimiento }
procedure FadeBlurTo0(step : byte; where : word); assembler;
asm
   mov es, where
   xor di, di
   mov bl, step
   mov cx, 64000
   @loop: mov al, es:[di]
          sub al, bl
          jns @skip
          xor al, al
   @skip: mov es:[di], al
          inc di
          dec cx
          jnz @loop
end;

procedure FadeBlurTo128(step : byte; where : word); assembler;
asm
   mov es, where
   xor di, di
   mov bl, step
   mov cx, 64000
   @loop: mov al, es:[di]
          sub al, bl
          test al, $80
          jnz @skip
          mov al, $80
   @skip: mov es:[di], al
          inc di
          dec cx
          jnz @loop
end;

{ Dibujo de una seccin de 'inna.001' }
procedure MapSection(xs, ys : longint; where : word);
var y : integer;
    srcoff : longint;
    dstoff : word;
    temp : pointer;
    cs : XMSstruct;
begin
     cs.size := 320;
     cs.dsthandle := 0;
     cs.dstoffset := ptr(where, 0);
     cs.srchandle := HBig;
     srcoff := ys * 968 + xs;
     dstoff := 0;
     for y := 0 to 199 do
     begin
          asm
             db long; mov ax, word ptr [srcoff]
             db long; mov word ptr [temp], ax
          end;
          cs.srcoffset := temp;
          XMSCopy(cs);
          inc(srcoff, 968);
          inc(dstoff, 320);
          cs.dstoffset := ptr(where, dstoff);
     end;
end;


{ Other procs }


begin
end.
