
#include "writer.h"
#include "stext.h"
#include <tcscr.h>

#include <jclib.h>
#include <llkey.h>
#include <stdlib.h>
#include <stdio.h>
#include <ctype.h>

static FILE *File = NULL;
static long BegPos, ActPos;

static int PageTime = 0;
static int Pos = -1;
static struct {
    int x, y;
    char s[100];
} Text[2][20], *Tnow = Text[0], *Tprev = Text[1];

extern bool InitWriter(const char *fname) {
    File = JCLIB_OpenText(fname);
    if (File == NULL)
        return FALSE;
    Pos = -1;
    BegPos = ftell(File);
    ActPos = BegPos;
    memset(Text, 0, sizeof(Text));

    return TRUE;
}

extern void EndWriter(void) {
    if (File != NULL)
        JCLIB_Close(File);
    File = NULL;
}

static char *CleanLine(char *dest, const char *src) {
    char *j;
    int incomment = 0;
    int algo = 0;

    if (src == NULL) {
        *dest='\0';
        return NULL;
    }

    while ( *src && (iscntrl(*src) || isspace(*src)) ) src++;
    if (!*src) {
        *dest = '\0';
        return dest;
    }
    j = dest;
    while (*src)
        if (!iscntrl(*src)) {
            if (incomment && *src == '*' && src[1] == '/') {
                src += 2;
                incomment--;
            } else if (*src == '/' && src[1] == '*') {
                src+=2;
                incomment++;
            } else if (!incomment && (algo || !isspace(*src))) {
                algo = 1;
                *j++ = *src++;    /* Aqu est seguro de que hay algo. */
            } else src++;
        } else
            src++;
    if (j==dest) {
        *dest = '\0';
        return dest;
    }
    while (isspace(*(--j)) );
    j[1] = '\0';
    return dest;
}

static int SplitLine(char *ppc[], int nstr, char *src) {
    char *p = src;
    int  n = 0;

    if (src == NULL || ppc == NULL || nstr == 0)
        return 0;
    do {
        while (*p == ' ' || *p == '\t')
            p++;
        if (*p == '\0')
            return n;
        if (*p == '\"' || *p == '\'') {
            char del = *p++;
            *ppc++ = p;
            n++;
            if ( (p = strchr(p, del)) == NULL)
                return n;
            if (*p == '\0')
                return n;
             *p++ = '\0';
        } else {
            *ppc++ = p;
            while (*p != ' ' && *p != '\t' && *p != '\0')
                p++;
            n++;
            if (*p == '\0' || n >= nstr)
                return n;
            *p++ = '\0';
        }
    } while (*p != '\0' && n < nstr);
    if (*p != '\0')
        *ppc = p;
    return n;
}



extern void DoWriter(int time) {
    int ink, i;

    if (Pos < 0) {
        char line[200];
        char *tok[3];
        int ntok;
        int nt;

        {
            void *k;
            k = Tnow; Tnow = Tprev; Tprev = k;
        }

        PageTime = 70*10;
        memset(Tnow, 0, sizeof(*Text));
        nt = 0;
        fseek(File, ActPos, SEEK_SET);
        for (;;) {
            if (feof(File) || fgets(line, sizeof(line), File) == EOF) {
                ActPos = BegPos;
                break;
            }
            CleanLine(line, line);
            if (line[0] == '\0' || strchr(";:#", line[0]) != NULL)
                continue;

            ActPos = ftell(File);

            ntok = SplitLine(tok, 3, line);
            if (ntok != 3) {
                if (stricmp(tok[0], "ENDPAGE") == 0) {
                    if (ntok == 2)
                        PageTime = atoi(tok[1])*70;
                    break;
                } else if (stricmp(tok[0], "ENDTEXT") == 0) {
                    if (ntok == 2)
                        PageTime = atoi(tok[1])*70;
                    ActPos = BegPos;
                    break;
                }
            } else {
                if (nt < SIZEARRAY(*Text)) {
                    Tnow[nt].x = atoi(tok[0]);
                    Tnow[nt].y = atoi(tok[1]);
                    strncpy(Tnow[nt].s, tok[2], sizeof(Tnow[nt].s));
                    Tnow[nt].s[sizeof(Tnow[nt].s)-1] = '\0';
                    if (Tnow[nt].x < 0) {
                        int w;
                        w = GetTextExtent(&FONT_System, Tnow[nt].s);
                        Tnow[nt].x = (TCS_Width - w)/2;
                    }
                    if (Tnow[nt].y < 0 && nt > 0) {
                        Tnow[nt].y = Tnow[nt-1].y + 19;
                    }
                    nt++;
                }
            }
        }
        Pos = time;
    }

    for (i = 0; i < SIZEARRAY(*Text); i++) {
        ink = (time - Pos)*2 - i*50;
        if (ink > 0xEF)
            ink = 0xEF;
        else if (ink < 0)
            ink = 0;
        if (ink > 0)
            WriteText(&FONT_System, Tnow[i].x, Tnow[i].y, Tnow[i].s, (byte)ink);
        ink = 0xEF - ink;
        if (ink > 0)
            WriteText(&FONT_System, Tprev[i].x, Tprev[i].y, Tprev[i].s, (byte)ink);
    }
    if ((time - Pos) > PageTime)
        Pos = -1;
}

