/*
**
**		CFX Implementation here.
**
*/


#include "FX.hpp"




CFX::CFX(FX *f, unsigned long s, unsigned long e)
{
	fx = f;
	start = s;
	end = e;
	enabled = true;
}


bool CFX::Init(Loader* l)
{ 
	return fx->Init(l); 
}


void CFX::Disable(void)
{
	enabled = false;
}


void CFX::Enable(void)
{
	enabled = true;
}


void CFX::DoFX(unsigned int msecs, const Demo *env)
{

	if ( ( msecs >= start ) && ( msecs <= end ) && enabled && ( end != INFINITY ) )
	{
		float t = (float)(msecs-start)/(float)(end-start);
		fx->Render(t, env);
	}
	else
	{
		if ( end == INFINITY )
		{
			fx->Render( (float) msecs , env );
		}
	}

}


CFX::~CFX()
{
	fx->DeInit();
	delete fx;
	fx = NULL;
}


void CFX::PushFX( unsigned long type, float value)
{
	if ( fx != NULL )
		fx->Push( type, value );
}

/*	Some qewl stuff to get number of CPU cycles elapsed since computer startup...

qword getCycles()
{
qword cycles;
__asm{
Push Eax
Push Edx
_emit 0fh ;RDTSC
_emit 31h

Mov dword ptr cycles,Edx
Shl cycles,32
Or dword ptr cycles,Eax

Pop Edx
Pop Eax
}

return cycles;

}
*/