/*
**
**		FX Header
**		by FirEdge / Ethereal
**		CFX by pompy / ethereal
**
*/


#ifndef _FX_HPP_
#define _FX_HPP_


#define INFINITY		1000000000

#include "typedefs.h"
#include "Loader.hpp"
#include "Music.hpp"
#include "demoengine.hpp"

// Push types definition

#define PUSH_BASS 1
#define PUSH_PERC 2
#define PUSH_CYMB 3
#define PUSH_MELO 4
#define PUSH_BLEH 5


/* Effect */
class FX
{
private:
public:
	virtual bool Init(const Loader* l) = 0;					
	// time is between 0.0 and 1.0, where 0 is the beginning and 1.0 is the end
	virtual void Render(float time, const Demo *env) = 0;	
	virtual void Push(ud type, float value) = 0;					
	virtual void DeInit() = 0;										
};



/* Effects Controler */

class CFX {

	unsigned long start, end;
	bool enabled;

public:
	FX* fx;

	CFX(FX *f, unsigned long s, unsigned long e);
	bool Init(Loader *l);
	void Disable(void);
	void Enable(void);
	void DoFX(unsigned int msecs, const Demo *env);
	void PushFX( unsigned long type, float value);
	~CFX();
};




#endif