///////////////////////////////////////////////////////////////////////////////////
//-----------------------------------startDlg.c----------------------------------//
//                                                                               //
// The application's About dialog.                                               //
//                                                                               //
// Created by: Darren Hodges (Hodglim)                                           //
// Created on: 06/03/2001                                                        //
//                                                                               //
///////////////////////////////////////////////////////////////////////////////////

#include "DemoEngine.hpp"
#include "resource.h"


//------------------------------Function Prototypes------------------------------//
BOOL startDlg_OnInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam);
void startDlg_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify);
 
 
///////////////////////////////////////////////////////////////////////////////////
//---------------------------------startDlgProc()--------------------------------//
//                                                                               //
// Process messages sent to this dialog box.                                     //
//                                                                               //
//-----------------------------------Parameters----------------------------------//
//                                                                               //
// hwnd   - handle to dialog box                                                 //
// msg    - message                                                              //
// wparam - message parameter                                                    //
// lparam - message parameter                                                    //
//                                                                               //
//------------------------------------Returns------------------------------------//
//                                                                               //
// Typically, the dialog box procedure should return TRUE if it processed the    //
// message, and FALSE if it did not. If the dialog box procedure returns FALSE,  //
// the dialog manager performs the default dialog operation in response to the   //
// message.                                                                      //
//                                                                               //
///////////////////////////////////////////////////////////////////////////////////
LRESULT CALLBACK startDlgProc(HWND hwnd,
							  UINT msg,
							  WPARAM wparam,
							  LPARAM lparam)
{
	switch(msg)
	{
		case WM_INITDIALOG:
			return HANDLE_WM_INITDIALOG(hwnd, wparam, lparam, startDlg_OnInitDialog);

		case WM_COMMAND:
			return HANDLE_WM_COMMAND(hwnd, wparam, lparam, startDlg_OnCommand);

		default:
			//message was not handled
			return FALSE;
	}

} //end startDlgProc()


///////////////////////////////////////////////////////////////////////////////////
//----------------------------startDlg_OnInitDialog()----------------------------//
//                                                                               //
// Initialise the dialog box.                                                    //
//                                                                               //
//-----------------------------------Parameters----------------------------------//
//                                                                               //
// hwnd      - handle to dialog box                                              //
// hwndFocus -																	 //
// lparam    - message parameter                                                 //
//                                                                               //
//------------------------------------Returns------------------------------------//
//                                                                               //
// True if the dialog box was initialised successfully.                          //
//                                                                               //
///////////////////////////////////////////////////////////////////////////////////
BOOL startDlg_OnInitDialog(HWND hwnd, HWND hwndFocus, LPARAM lParam)
{
	RECT dlgRt;
	GetWindowRect( hwnd, &dlgRt );

	//Initialise controls
	//Add some dummy demo names into list (this will parse the demo folder for installed demos)
//	SendMessage(GetDlgItem(hwnd, IDC_DEMOLIST), LB_ADDSTRING, 0, (LPARAM)(LPCTSTR)"Dark Motion");
//	SendMessage(GetDlgItem(hwnd, IDC_DEMOLIST), LB_ADDSTRING, 0, (LPARAM)(LPCTSTR)"Demo 2");
//	SendMessage(GetDlgItem(hwnd, IDC_DEMOLIST), LB_ADDSTRING, 0, (LPARAM)(LPCTSTR)"Demo 3");
//	SendMessage(GetDlgItem(hwnd, IDC_DEMOLIST), LB_ADDSTRING, 0, (LPARAM)(LPCTSTR)"Demo 4");
	//Select first demo in list
//	SendMessage(GetDlgItem(hwnd, IDC_DEMOLIST), LB_SETCURSEL, (WPARAM)0, 0);

	//Select 800x600 as default (we should store user settings in a config file)
	SendMessage(GetDlgItem(hwnd, IDC_RESRADIO2), BM_SETCHECK, (WPARAM)BST_CHECKED, 0);

	//Select 32bpp colour depth (again this should be stored in a config file)
	SendMessage(GetDlgItem(hwnd, IDC_BPP32), BM_SETCHECK, (WPARAM)BST_CHECKED, 0);

	//Select 16bpp zbuffer depth (again this should be stored in a config file)
	SendMessage(GetDlgItem(hwnd, IDC_Z16), BM_SETCHECK, (WPARAM)BST_CHECKED, 0);


	//Check fullscreen mode (yep, this should come from config too :)
	SendMessage(GetDlgItem(hwnd, IDC_FULLSCREEN), BM_SETCHECK, (WPARAM)BST_CHECKED, 0);
	
	//Center dialog
	MoveWindow( hwnd,((GetSystemMetrics( SM_CXSCREEN ) -
                       dlgRt.right ) / 2 + 4) & ~7,
                      (GetSystemMetrics( SM_CYSCREEN ) -
                       dlgRt.bottom) / 2,
                       dlgRt.right, dlgRt.bottom, 0 );

	return TRUE;

} //end startDlg_OnInitDialog()


///////////////////////////////////////////////////////////////////////////////////
//-----------------------------startDlg_OnCommand()------------------------------//
//                                                                               //
// Process command messages sent to this dialog box.                             //
//                                                                               //
//-----------------------------------Parameters----------------------------------//
//                                                                               //
// hwnd       - handle to dialog box                                             //
// id         -																	 //
// hwndCtl    -																	 //
// codeNotify -																	 //
//                                                                               //
///////////////////////////////////////////////////////////////////////////////////
void startDlg_OnCommand(HWND hwnd, int id, HWND hwndCtl, UINT codeNotify)
{	
	switch(id)
	{
		case IDC_RESRADIO1:
		{
			g_width  = 1024;
			g_height = 768;
		} break;

		case IDC_RESRADIO2:
		{
			g_width  = 800;
			g_height = 600;
		} break;

		case IDC_RESRADIO3:
		{
			g_width  = 640;
			g_height = 480;
		} break;

		case IDC_RESRADIO4:
		{
			g_width  = 512;
			g_height = 384;
		} break;

		case IDC_RESRADIO5:
		{
			g_width  = 320;
			g_height = 240;
		} break;

		case IDC_BPP32:
		{
			g_bpp = 32;
		} break;

		case IDC_BPP16:
		{
			g_bpp = 16;
		} break;

		case IDC_BPP24:
		{
			g_bpp = 24;
		} break;

		case IDC_Z16:
		{
			g_zbuffer = 16;
		};

		case IDC_Z24:
		{
			g_zbuffer = 24;
		};

		case IDC_Z32:
		{
			g_zbuffer = 32;
		};

		case IDC_FULLSCREEN:
		{
			g_fullscreen = SendMessage(hwndCtl, BM_GETCHECK, 0, 0) == BST_CHECKED;
		} break;

		case IDOK:
		{
            EndDialog(hwnd, TRUE);
		} break;

		case IDCANCEL:
		{
            EndDialog(hwnd, FALSE);
		} break;
	}

} //end startDlg_OnCommand()


///////////////////////////////////////////////////////////////////////////////////
//--------------------------------showStartDlg()---------------------------------//
//                                                                               //
// Call this function to display the startup dialog box.                         //
//                                                                               //
//-----------------------------------Parameters----------------------------------//
//                                                                               //
// hInstance - application instance												 //
// hwnd     - parent window.                                                     //
//                                                                               //
//------------------------------------Returns------------------------------------//
//                                                                               //
// Value passed into EndDialog.													 //
//                                                                               //
///////////////////////////////////////////////////////////////////////////////////
int showStartDlg(HINSTANCE hInstance)
{
	return DialogBox(hInstance, MAKEINTRESOURCE(IDD_STARTUP), GetDesktopWindow(), (DLGPROC)startDlgProc);

} //end showStartDlg()

///////////////////////////////////////////////////////////////////////////////////
//-----------------------------------startDlg.c----------------------------------//
///////////////////////////////////////////////////////////////////////////////////