//Land.cpp, copyright Keith Sibson (as if you would).

//Uncompilable as is, but anyone should be able to plug
//in their own replacement primitive fns.
//Compiled under BC3.1 or something.

//Maybe I'll optimise this someday

typedef int bool;

#include <math.h>
#include <conio.h>
#include <stdlib.h>
#include <iostream.h>
#include <time.h>

#include "sincos.h"
#include "plasma.h"
#include "mode13h.h"
#include "k.h"

#define TRUE 1
#define FALSE 0

#define d 200		       //Distance from observer to view plane

#define x_offs 160
#define y_offs 100

#define MAPSIZE 150

const int MX=MAPSIZE;	       //Dimensions of the map
const int MZ=MAPSIZE;

keyb* k;		       //Keyboard handler

#define XMAX 319
#define YMAX 199
#define XMIN 0
#define YMIN 0

unsigned char** map;


class vpoint			//VGA point : a point in the view plane
{
 public:	int vx,vy;
		vpoint(int x,int y) : vx(x),vy(y) {};
		vpoint() : vx(0),vy(0) {};
};

class point			//Point in 3 dimensional space
{
 public:
	int x,y,z;
	int xc,yc,zc;		//current values
	point(int X,int Y,int Z) : x(X),y(Y),z(Z),xc(X),yc(Y),zc(Z) {};
	point() : x(0),y(0),z(0) {};
};

//Projection onto the view plane.
vpoint Project(point pnt)
{
 vpoint vp;
 vp.vy=((-d*(pnt.yc))/(pnt.zc));	//+d to invert y axis
 vp.vx=((d*(pnt.xc))/(pnt.zc));		//-d to keep orientation correct
 return vp;
}

//This is a general point translation function
point Translate(point p,int x,int y,int z)
{
 return (point(p.x+x,p.y+y,p.z+z));
}

class landscape
{
 friend main(); //Hehe, didn't yer mother teach you good OO design?

 private:
		int width;
		int depth;

		int base;

		int smx;
		int smz;

		int mapx,mapz;

		point** points;

		vpoint** vpoints;

		landscape(const landscape&);
 public:

		landscape(int x,int y,int z,int mx,int mz);
		~landscape();

		int ang;

		void Project();
		void DisplayPoints();
		void DisplayLines();
		void Move(int xdelta,int zdelta);
		void Rotate();
		void Translate(int x,int y,int z);

		void Map();
};

landscape::landscape(int x,int y,int z,int mx,int mz) : ang(0),mapx(mx),mapz(mz)
{
 width=40;
 depth=40;

 smx=x+width; //2*width/2	since points defined with spacing of 2
 smz=z+depth;

 if(mx>MX-width || mz>MZ-depth) exit(0);

 base=y;			//Lowest height

 points =new point *[width];
 vpoints=new vpoint*[width];

 for(int m=0;m<width;m++) {
	points[m]=new point[depth];
	vpoints[m]=new vpoint[depth]; }

 for(int i=0;i<width;i++)
	for(int j=0;j<depth;j++) {
		points [i][j]=point(x+i*2,map[mapx+i][mapz+j]+base,z+j*2);
		vpoints[i][j]=vpoint(::Project(points[i][j])); }
}

landscape::~landscape()
{
 for(int i=0;i<width;i++) {
	delete points[i];
	delete vpoints[i]; }

 delete points;
 delete vpoints;
}

void landscape::Project()
{
 for(int i=0;i<width;i++)
	for(int j=0;j<depth;j++)
		vpoints[i][j]=::Project(points[i][j]);
}

void landscape::DisplayLines()
{
 register int i,j;

 for(i=1;i<width;i++)
	for(j=1;j<depth;j++) {
		int c=3*map[mapx+i][mapz+j];
		int x1=vpoints[i][j].vx+x_offs;
		int y1=vpoints[i][j].vy+y_offs;
		if(x1>XMIN && x1<XMAX && y1>YMIN && y1<YMAX) {
			int x2=vpoints[i][j-1].vx+x_offs;
			int y2=vpoints[i][j-1].vy+y_offs;
			if(x2>XMIN && x2<XMAX && y2>YMIN && y2<YMAX)
				DrawLine(x1,x2,y1,y2,c);
			x2=vpoints[i-1][j].vx+x_offs;
			y2=vpoints[i-1][j].vy+y_offs;
			if(x2>XMIN && x2<XMAX && y2>YMIN && y2<YMAX)
				DrawLine(x1,x2,y1,y2,c); } }

}

void landscape::DisplayPoints()
{
 for(int i=0;i<width;i++)
	for(int j=0;j<depth;j++) {
		int x=vpoints[i][j].vx+x_offs;
		int y=vpoints[i][j].vy+y_offs;

		if(x>XMIN && x<XMAX && y>YMIN && y<YMAX)
		MemPutPixelVirtual(x,y,3*map[mapx+i][mapz+j]); }
}


void landscape::Move(int xdelta,int zdelta)
{
 int newmx=mapx+xdelta;
 int newmz=mapz+zdelta;
 if(newmx>=0 && newmz>=0 && newmx<MX-width && newmz<MZ-depth) {
	mapx=newmx;
	mapz=newmz;
	for(int i=0;i<width;i++)		//Update landscape
		for(int j=0;j<depth;j++)
			points[i][j].yc=map[mapx+i][mapz+j]+base;
	 }	       //update .y also (-need to if rotating about x or z later
}

//Rotation of land as an object around a central y axis
void landscape::Rotate()
{
 register int i,j;

 for(i=0;i<width;i++)
	for(j=0;j<depth;j++) {
		int rx=points[i][j].x-smx;
		int rz=points[i][j].z-smz;
		int tmpx,tmpz;
		tmpx=((long)rx*KCos(ang)+(long)rz*KSin(ang))>>16;
		tmpz=((long)rz*KCos(ang)-(long)rx*KSin(ang))>>16;
		points[i][j].xc=(int)tmpx+smx;
		points[i][j].zc=(int)tmpz+smz; }
}

void landscape::Translate(int x,int y,int z)
{
 smx+=x;
 smz+=z;
 base+=y;

 for(int i=0;i<width;i++)
	for(int j=0;j<depth;j++){
		points[i][j].xc=points[i][j].xc+x;
		points[i][j].yc=points[i][j].yc+y;
		points[i][j].zc=points[i][j].zc+z;
		points[i][j].x=points[i][j].x+x;
		points[i][j].y=points[i][j].y+y;
		points[i][j].z=points[i][j].z+z; }
}

void landscape::Map()
{
 for(int i=0;i<MX;i++)
	for(int j=0;j<MZ;j++)
		MemPutPixelVirtual(i,j,map[i][j]*3);

 DrawHorizLine(mapx,mapz,width,0);
 DrawHorizLine(mapx,mapz+depth,width,0);
 DrawVertLine (mapx,mapz,depth,0);
 DrawVertLine (mapx+width,mapz,depth,0);
}

void SetPallete()
{
 int i;

 for(i=0;i<27;i++) {
	SetDAC(i,i*2,0,0);
	SetDAC(i+27,54,i*2,0);
	SetDAC(i+54,54,54,i*2);
	SetDAC(i+54+27,54,54,54); }

 SetDAC(1,0,0,54);  //3 is base colour of map (over 0)
 SetDAC(2,0,0,54);
 SetDAC(3,0,0,54);
}

main()
{
 cout<<"OK, here's the keys:"<<endl;
 cout<<"\tQ,A,O,P : move in scape"<<endl;
 cout<<"\tW,S,K,L : move scape"<<endl;
 cout<<"\tSPC     : rotate scape"<<endl;
 cout<<"\tM       : map scape"<<endl;
 cout<<"\tESC     : e scape"<<endl;

 InitTrigTables();

 int x,z;

 randomize();

 map=(unsigned char**)GeneratePlasma(MAPSIZE);

 for(x=0;x<MAPSIZE;x++)
	for(z=0;z<MAPSIZE;z++)
		map[x][z]=map[x][z]/9+1; //have sea level at 1


 landscape land(-40,-30,35,40,40);

 getch();

 EnterMode();

 SetPallete();

 //Now set up the keyboard, use scan codes, not chars

 char keys[]={ 16, 30, 24, 25, 57, 17, 31, 37, 38, 1, 50 };

 k=new keyb(keys,11);

#define _Q_   0
#define _A_   1
#define _O_   2
#define _P_   3
#define ___   4
#define _W_   5
#define _S_   6
#define _K_   7
#define _L_   8
#define _ESC_ 9
#define _M_  10

 char c=TRUE;

 unsigned long frames=0;

 clock_t start=clock();

 while(c) {			//Main loop
	 WaitRetrace();

	 FlipVirtual();

	 FillVirtual(0);

	 if(k->KeyDown(_Q_)) land.Move(0, 1);
	 if(k->KeyDown(_A_)) land.Move(0,-1);
	 if(k->KeyDown(_O_)) land.Move(-1,0);
	 if(k->KeyDown(_P_)) land.Move( 1,0);
	 if(k->KeyDown(___)) { land.ang+=5;
				   land.Rotate(); }
	 if(k->KeyDown(_W_)) land.Translate(0,0,1);
	 if(k->KeyDown(_S_)) land.Translate(0,0,-1);
	 if(k->KeyDown(_K_)) land.Translate(-1,0,0);
	 if(k->KeyDown(_L_)) land.Translate(1,0,0);

	 if(k->KeyDown(_ESC_)) c=FALSE;

	 if(k->KeyDown(_M_)) land.Map();

	 land.Project();
	 land.DisplayLines();
	 frames++;  }

 clock_t end=clock();

 ExitMode();

 delete k;		//Do this or die

 cout<<"FPS: "<<(frames*CLK_TCK)/(end-start)<<endl;

 return(0);
}
