; Macro to clear the keyboard buffer (which is a ring buffer) by setting its
; start and end equal
; https://jeffpar.github.io/kbarchive/kb/060/Q60140/
; https://board.flatassembler.net/topic.php?t=1836
; https://retrocomputing.stackexchange.com/questions/9484/
;         whats-the-fastest-way-to-ignore-keypresses

;------------------------------------------------------------------------------
;macro to clear the keyboard buffer
;ax, es, ed, di, si destroyed
;no result
;------------------------------------------------------------------------------
ClearKeyBuffer MACRO
     mov ax,  0040h       ;flush keybord buffer
     mov es,  ax
     mov ds,  ax
     mov di,  001Ah
     mov si,  001Ch
     movsw
ENDM

ClearKeyBufferSmall MACRO
     mov ax,         0040h
     mov ds,         ax
     mov ax,         ds:[001Ah]
     mov ds:[001Ch], ax
ENDM