; This file can be assembled into a .com file which is binarily identical to
; the original work by Resident. It was obtained by dissasembly and refatoring
; intro macros. The original work can be found at the following links.
; https://www.pouet.net/prod.php?which=11661
; https://www.residentland.info
; http://www.7dx-party.org

      DOSSEG              ;assembler directives necessary for .com linking
     .MODEL tiny
     .286
     .CODE
      ORG 100h

     INCLUDE mode13h.asm
     INCLUDE clearpal.asm
     INCLUDE text.asm
     INCLUDE colcycle.asm
     INCLUDE retrace.asm
     INCLUDE textmode.asm
     INCLUDE terminat.asm

     NumColors   = 30h
     NumRows     = 19h
     NumColumns  = 28h
     PaletteStep = 08h
     SkipMode    = 00h
     KeyPort     = 60h

Main:
     Mode13h 01h
     ClearPalPorts
     xor  dx, dx

     CreateText NumRows NumColumns PaletteStep SkipMode
     
     xor  ax, ax          ;contains the palette index to start with
MainLoop:                 ;color cycling loop starts here
     ColorCycle NumColors ;destroys cx, dx

     push ax
     WaitRetrace          ;destroys al, dx
     in   al, KeyPort     ;read keyboard,
     dec  al              ;if escape (scancode 1) is pressed,
     jz   Termination     ;then terminate
     pop  ax

     inc  ax              ;increment palette starting index
     jmp  MainLoop

Termination:
     Textmode             ;destroys ax
     Terminate

     END Main
