//
// TinyPTC by Gaffer
// www.gaffer.org/tinyptc
//

#include "tinyptc.h"
#include <windows.h>

#define width 320
#define height 200
#define size width*height
   
static int noise;
static int carry;
static int index;
static int seed = 0x12345;
static int pixel[size];

void WinMainCRTStartup()
{
    if (!ptc_open("test",width,height)) return;
    while (1)
    {
        for (index=0; index<size; index++)
        {
            noise = seed;
            noise >>= 3;
            noise ^= seed;
            carry = noise & 1;
            noise >>= 1;
            seed >>= 1;
            seed |= (carry << 30);
            noise &= 0xFF;
            pixel[index] = (noise<<16) | (noise<<8) | noise;
        }
        ptc_update(pixel);
    }
    ptc_close();
}
