#include <stdio.h>
#include <fstream.h>
#include <stdlib.h>
#include <math.h>

int main(int argc, char *argv[])
{
  int raw [81921];
  int charset [65536];
  int frame;
  int xco;
  int xco2;
  int yco;
  int yco2;
  int lastbyte;
  int maxlines;
  int numberoflines[255];
  int offset=177-8;
  bool notused;

  FILE *in;
  FILE *out;

  //input charsetdata

  int counter   =0;
  int counter2  =0;
  int inputbyte =0;
  int numberofframes;
  int temp =0;
  int specialcount=0;
  int lastsaved=0;
  bool frames;

  // open raw data

  in = fopen ("angles.raw","rb");    // open charset

  while(feof(in)==0) {
      raw[counter]=fgetc(in);
      counter++;
  }

  cout << counter << " bytes read." << endl;

  fclose(in);                          // close stream

  //clear output data

  for(counter=0;counter<65536;counter++){
      charset[counter]=0;
  }//for

  //check max # of lines used..
  maxlines=0;
  numberofframes=0;

  frame=0;
  frames=true;
  while (frames){
    for (xco=0;xco<(36-6);xco++){
        notused=true;
        for (yco=0;yco<64;yco++){
            if ((raw[xco+6+4+(frame&3)*10*4+(((int)(frame/4))*64+yco)*160])!=85){
               notused=false;
               numberoflines[frame]=xco;
               if (xco>maxlines){maxlines=xco;}
               yco=64;
            } //if raw
        }//for yco
        if(notused){
          xco=100;
        }//if
    }//for xco
    if (numberoflines[frame]==0){frames=false;}
    cout << "number of lines used in frame " << frame << " : " << numberoflines[frame] << endl;
    frame++;
  }//while
  numberofframes=frame-1;

  cout << "maximal # of lines detected : " << maxlines << endl;
  cout << "# of frames detected        : " << numberofframes << endl;

  cout << "encoding data" << endl;
  //encode normal lines
  counter=0;

  for (frame=0;frame<numberofframes;frame++){
      for(xco=0;xco<numberoflines[frame];xco++){
          yco=0;
          while(raw[xco+6+4+(frame&3)*10*4+(((int)(frame/4))*64+yco)*160]==85){yco++;}
          charset[counter]=yco+offset;
          counter++;
          charset[counter]=raw[xco+6+4+(frame&3)*10*4+(((int)(frame/4))*64+yco)*160];
          counter++;
          while(raw[xco+6+4+(frame&3)*10*4+(((int)(frame/4))*64+yco)*160]!=85){yco++;}
          charset[counter]=yco-1+offset;
          counter++;
          charset[counter]=raw[xco+6+4+(frame&3)*10*4+(((int)(frame/4))*64+(yco-1))*160];
          counter++;
       }//for
       charset[counter]=254; // mark end of normal lines;
       counter++;
       //write last used line
       yco=0;
       xco=numberoflines[frame];
       //write first pair
       lastbyte=charset[counter]=raw[xco+6+4+(frame&3)*10*4+(((int)(frame/4))*64+yco)*160];
       counter++;
       while (yco<64){
           while( (raw[xco+6+4+(frame&3)*10*4+( ( (int)(frame/4) )*64+yco)*160]==lastbyte)  & (yco<64) ){yco++;}

           if (yco!=64){
               charset[counter]=yco+offset;
               lastbyte=charset[counter+1]=raw[xco+6+4+(frame&3)*10*4+(((int)(frame/4))*64+yco)*160];
               counter+=2;
           }//if
       }//while
       charset[counter]=255;
       counter++;

  }//for
  charset[counter]=0; // make last byte 0, for sbc trick

  // make output file
  out=fopen("../../sources/flipdata.txt","w");
  fputs(";flipdata\n",out);
  fputs("\nflipcollisionlow\n        .byte ",out);

  for (counter=numberofframes;counter>1;counter--){
       fprintf(out,"<frame%idata,",counter);
  }//for
  fprintf(out,"<frame%idata\n\nflipcollisionhigh\n        .byte ",counter);
  for (counter=numberofframes;counter>1;counter--){
       fprintf(out,">frame%idata,",counter);
  }//for
  fprintf(out,">frame%idata\n\n",counter);

  counter=0;
  for (frame=0;frame<numberofframes;frame++){

        fprintf(out,"frame%idata\n",frame+1);

        // output normal lines
        while(charset[counter]!=254){
            fprintf(out,"        .byte %i,%i,%i,%i\n",charset[counter],charset[counter+2],charset[counter+1],charset[counter+3]);
            counter+=4;
        }//while
        counter++; // skip end of normal lines marker
        //outputspecialline
        specialcount=0;
        fprintf(out,"lastline%i\n",frame+1);
        while (charset[counter+1]!=255){
              if (specialcount==0) {
                fprintf(out,"        .byte %i\n",charset[counter+1]);
                lastsaved++;
              }//if
              if (specialcount == 1) {
                fprintf(out,"        .byte %i,%i\n",charset[counter],charset[counter+1]);
                temp=charset[counter+1];
              }//if
              if (specialcount > 1) {
                fprintf(out,"        .byte %i,%i\n",charset[counter],charset[counter+1]-temp);
                temp=charset[counter+1];
              }//if
              specialcount++;
              counter+=2;
        }//while
        if ((charset[counter+1]-temp)<=charset[counter+2]) {
          fprintf(out,"        .byte %i;,%i\n",charset[counter],charset[counter+1]-temp);
          lastsaved++;
        }//if
        else{
          fprintf(out,"        .byte %i,%i\n",charset[counter],charset[counter+1]-temp);
        }
        counter+=2;
        fprintf(out,"\n;=============================\n");
  }//for

  cout << "output file is " << counter+numberofframes*2-numberofframes-lastsaved << " bytes long." << endl;

  // write maxmultiply thingie..

  fprintf(out,"\n;maxmultiply .byte ");
  for (counter=0;counter<numberofframes;counter++){
    fprintf(out,"%i*2",numberoflines[numberofframes-counter-1]);
    if (counter<numberofframes-1){fprintf(out,",");}
  }//for
  fclose(out);

  return 0;
}

