#include <windows.h>
#include <stdarg.h>
#include <gl/gl.h>
#include <gl/glu.h>

#include "imageLoad.h"
#include "demo.h"
#include "win32/Window.h"
#include "win32/soundsystem.h"
#include "statemachine.h"

#define DEBUG_LINE_COLOR 1,1,0
#define DEBUG_CAPT_COLOR 0,1,0
#define DEBUG_TEXT_COLOR 1,1,1

#define KP_TIME 25

static int debTime=0;
static int fsTime=0;
static __int32 tc=0;
static __int32 tcs=0;
static __int32 fpsframes=0;

int TDemo::run(__int32 tOffset) {
  timerOffs=tOffset;
  return run();
}

int TDemo::run()
{
  MSG		msg;
	bool	done=false;
  bool  showfps=true;
  TScene *currentScene;
  int frames = 0;
  int p=0;
  
  setup();
#ifndef EXCLUDE_DEBUGGER
  debug->setup();
#endif
  if (!win->show())
    return 1;

  TGLState::initStatus();
  sharedTextures->uploadTextures();
  sceneFactory->setupScenes(REASON_AFTERTEXTURES);
#ifndef EXCLUDE_DEBUGGER
  debug->buildFont();
#endif

  // Start the timer.
  if(musicLoaded)
    music->play();
  timer->start();
	while(!done)
	{
    p=0;
		if (PeekMessage(&msg,NULL,0,0,PM_REMOVE))
    {
			if (msg.message==WM_QUIT)
			{        
				done=TRUE;
        break;
			}
			else
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);
			}
		}
		else
		{
			// Gets the currents run scenes      
      sceneFactory->setupRunScenes(timer->getMs()+timerOffs);
      // Execute run metod of actives scenes in this time.
      while ((currentScene = sceneFactory->getNextOfRunScenes()) != NULL)
      {
        if (!currentScene->run((timer->getMs()+timerOffs)-currentScene->startTime)) {
          done=TRUE;
        } else {
#ifndef EXCLUDE_DEBUGGER
          debug->drawText(0,48+p*16,DEBUG_TEXT_COLOR," %02d  %-20s %7d %7d %7d ", p+1, currentScene->sceneName, currentScene->startTime, currentScene->endTime, (timer->getMs()+timerOffs)-currentScene->startTime);
          debug->drawText(0,48+p*16,DEBUG_LINE_COLOR," %2s |%-20s|%7s|%7s|%7s|", "","","","","");
          debug->drawText(0,48+p*16,DEBUG_CAPT_COLOR,"#%2s: %-20s %7s %7s %7s ", "","","","","");
#endif
          p++;
        }
      }
      if (win->keys[VK_ESCAPE] || timer->getMs()+timerOffs>=endtime)
			{
        PostQuitMessage(0);
      } else if (win->keys[VK_F12] && !debTime) {
        win->keys[VK_F12]=FALSE;
#ifndef EXCLUDE_DEBUGGER
        debug->showDebug=!debug->showDebug;
        debug->setInfo("Debug mode %s", debug->showDebug?"enabled":"disabled");
#endif
        debTime=KP_TIME;
        
      } else if (win->keys[VK_F11] && !fsTime) {
        fsTime=KP_TIME;
        win->keys[VK_F11]=FALSE;

        int w, h;
        w=win->width;
        h=win->height;
        char title[256];
        
        strcpy(title, win->title);
#ifndef EXCLUDE_DEBUGGER
        debug->killFont();
#endif        
        bool fullscreenflag = !win->fullscreen;
        win->close();
        delete win;
        win=NULL;

#ifndef EXCLUDE_DEBUGGER
        debug->setInfo("Switching to %s mode", fullscreenflag?"fullscreen":"windowed");
#endif
        win = new TWindow(NULL);        
        if (!win->create(title, w, h, 32, fullscreenflag))
          return 1;

        TGLState::initStatus();
        sharedTextures->uploadTextures();
        sceneFactory->setupScenes(REASON_MODESWITCH);
        sceneFactory->setupScenes(REASON_AFTERTEXTURES);
        if (!win->show())
          return 1;
#ifndef EXCLUDE_DEBUGGER
        debug->buildFont();
#endif
      } else {    
        if(fsTime) fsTime--;
        if(debTime) debTime--;

#ifndef EXCLUDE_DEBUGGER
        debug->drawText(0,32,DEBUG_LINE_COLOR,"   --    -----------------     ---   -----     ---");
        debug->drawText(0,32,DEBUG_CAPT_COLOR,"num  name                 start   end     count");
        debug->drawText(0,48+p*16,DEBUG_LINE_COLOR,"--------------------------------------------------");
#endif
        tcs=(timer->getMs()+timerOffs)-tc;
        if(tcs>1000) {
          tc=timer->getMs()+timerOffs;
          fpsframes=0;
        }
    	  __int32 tt=timer->getMs()+timerOffs;
    	  int h=((tt/1000)/60)/60;
    	  int m=((tt/1000)/60)%60;
    	  int s=(tt/1000)%60;
        int msd=(tt%1000);
        GLfloat fps;
        if(tcs==0)
          fps=0;
        else
          fps = fpsframes/((GLfloat)tcs/1000.0f);
#ifndef EXCLUDE_DEBUGGER
        debug->drawText(0,0,DEBUG_LINE_COLOR,"-    ----   -----        -----   -----------------");
        debug->drawText(0,0,DEBUG_CAPT_COLOR," time    ms.     ms.total     fps               ");
        debug->drawText(0,16,DEBUG_TEXT_COLOR,"%02d:%02d:%02d %7d %12d %4.02f", h, m, s, msd, timer->getMs()+timerOffs, fps);
        debug->drawText(0,16,DEBUG_LINE_COLOR,"%2s %2s %2s|%7s|%12s|%5s", "", "", "", "", "", "");
            

        debug->dumpDebugScreen();
#endif

        frames++;
        fpsframes++;
        win->update();
			}
		}
	}

	// Shutdown 
  music->stop();
#ifndef EXCLUDE_DEBUGGER
  debug->free();
#endif

	return (msg.wParam);							// Exit The Program

}

TDemo::TDemo(char *title, int width, int height, int bits, bool fullscreen)
{
  timerOffs=0;
  endtime=0;
  sharedTextures = new TTextureRepository;
  sceneFactory = new TSceneFactory;
  timer = new TTimer;
  win = new TWindow(NULL);
  music = new TSoundSystem;
#ifndef EXCLUDE_DEBUGGER
  debug = new TDemoDebug;
#endif
  sceneFactory->sharedTextures = sharedTextures;
  

  if (title == NULL)
  {
    if (!win->create("OGL", width, height, bits, fullscreen))
      win = NULL;
  }
  else
  {
    if (!win->create(title, width, height, bits, fullscreen))
      win = NULL;
  }
  musicLoaded=false;
  music->init();
}

void TDemo::setMusic(char *filename, int type) {
  music->load(filename, TMODTYPE_MODULE);  
  musicLoaded=true;
}

TDemo::~TDemo() 
{
  if(sharedTextures) delete sharedTextures;
  if(sceneFactory) delete sceneFactory;
  if(timer) delete timer;
}

void TDemo::addScene(TScene *scene, __int32 startTime, __int32 endTime)
{
  scene->startTime = startTime;
  scene->endTime = endTime;
  if(endTime>this->endtime) this->endtime=endTime;
  sceneFactory->registerScene(scene);

}


int TDemo::setup()
{
  TScene *temp;
  if ((temp = sceneFactory->setupScenes()) != NULL)
  {
    char *msg = new char[512];
    sprintf(msg, "Failed Initializing scene. Scene name: %s", temp->sceneName);
    MessageBox(NULL, msg,"Error", 0);
    return 0;
  }
  return 1;
}

void TDemo::free()
{
  if(win) {
    win->close();
    delete win;
  }
  sceneFactory->freeScenes();
}




