//------------------------------------------------------------------------------------------
// ====
//  || olemaC - Elerium Core and Unknown Productions
//-------------------------------------------------------------------------------------------
// Scene Factory(NTM)
//         by tolemaC and Jcl.
//-------------------------------------------------------------------------------------------
// This file is a component of Scene Factory.
//-------------------------------------------------------------------------------------------

#ifndef __LIST_H_
#define __LIST_H_

#include <windows.h>

template <class T>
class TNode {
protected:
  T value;
public:
  T getValue() {
    return value;
  }
  TNode *next;
  TNode(T v){
    this->value = v;
  }
  ~TNode(){
  }
};

/*
   Lista del tipo:
        front                    rear
        N -> N -> N -> N -> N -> N -> NULL
*/

template <class T>
class TList {
private:
  TNode <T>*temp;
  TNode <T>*aux;
  TNode <T>*currentNode;
  void reset();  
public:
  TNode <T>*front;
  TNode <T>*rear;

  __int32 count;
  
  TList() {
    front = NULL;
    rear = NULL;
    currentNode = NULL;
    count = 0;
  }
  T getFirst();
  T getNext();

  void insert(T value);
  bool extract(T &value);
  T extractItem(T value);
  T find(T value);
  void clear();

  T operator [] (int index);
};


template <class T>
T TList<T>::operator [] (int index)
{
  temp = NULL;
  aux = NULL;
  int i;
  for (temp = front, i = 0; temp != NULL; temp = temp->next, i++)
  {
    if (i == index)
      return temp->getValue();
  }
  return NULL;
}

template <class T>
void TList<T>::reset()
{
  currentNode = front;
}

template <class T>
T TList<T>::getFirst()
{
  reset();

  return (currentNode == NULL) ? 0 : currentNode->getValue();
}

template <class T>
T TList<T>::getNext()
{
  if (currentNode == NULL)      
    return getFirst();

  currentNode = currentNode->next;
  
  return (currentNode == NULL) ? 0 : currentNode->getValue();
}


template <class T>
void TList<T>::insert(T value)
{
  temp = new TNode<T>(value);
  temp->next = NULL;
  if (front == NULL && rear == NULL)
    front = temp;   
  else
    rear->next = temp;

  count++;
  rear = temp;
}

template <class T>
bool TList<T>::extract(T &value)
{
  if (front == NULL)
    return false;
  temp = front;
  front = temp->next;
  value = temp->getValue();
  if (front == NULL)
    front = rear = NULL;
  delete temp;

  count--;  
  return true;
}

template <class T>
T TList<T>::extractItem(T value)
{
  temp = NULL;
  aux = NULL;
  T result;
  for (temp = front; temp != NULL; temp = temp->next)
  {
    if (temp->getValue() == value)
    {
      result = temp->getValue();
      if (aux == NULL)
        front = front->next;
      else
        aux->next = temp->next;

      delete temp;
      return result;
    }
    aux = temp;
  }
  count--;
  return NULL;
}

template <class T>
T TList<T>::find(T value)
{
  for (temp = front; temp != NULL; temp = temp->next)
    if (temp->getValue() == value)
      return temp;
  return NULL;
}

template <class T>
void TList<T>::clear()
{
  T result;
  while (extract(result));
  count = 0;
}

#endif