#include <windows.h>
#include <string.h>
#include "SceneFactory.h"

TSceneFactory::TSceneFactory()
{
  scenes = new TList<TScene*>;
  runScenes = new TList<TScene*>;
  currentScene = NULL;
}

TScene *TSceneFactory::getNextOfRunScenes()
{
  if (currentScene == NULL)
    currentScene = runScenes->front;
  else
    currentScene = currentScene->next;

  if (currentScene == NULL)
    return NULL;
  else
    return (currentScene->getValue());
}

void TSceneFactory::setupRunScenes(__int32 time)
{
  TNode <TScene*>*temp;

  runScenes->clear();
  currentScene = NULL;

  for (temp = scenes->front; temp != NULL; temp = temp->next)
  {
    if (temp->getValue()->startTime <= time && temp->getValue()->endTime > time)
    {
      runScenes->insert(temp->getValue());
    }     
  }
}

TScene * TSceneFactory::getScene(char *name)
{
  TNode <TScene*>*temp;

  for (temp = scenes->front; temp != NULL; temp = temp->next)
  {
    if (stricmp(((TScene*)temp->getValue())->sceneName, name) == 0)
      return temp->getValue();
  }

  return NULL;
}

void TSceneFactory::registerScene(TScene *scene)
{
  scenes->insert(scene);
}

TScene *TSceneFactory::setupScenes()
{
  TNode <TScene*>*temp;

  for (temp = scenes->front; temp != NULL; temp = temp->next)
  {
    temp->getValue()->sharedTextures=this->sharedTextures;   

    if (!((TScene*)temp->getValue())->setup())
      return (TScene*)temp->getValue();
    //temp->getValue()->demo=this->demo;    
  }
  return NULL;
}

TScene *TSceneFactory::setupScenes(int reason)
{
  TNode <TScene*>*temp;

  for (temp = scenes->front; temp != NULL; temp = temp->next)
  {
    temp->getValue()->sharedTextures=this->sharedTextures;   

    if (!((TScene*)temp->getValue())->setup(reason))
      return (TScene*)temp->getValue();
  }
  return NULL;
}


void TSceneFactory::freeScenes()
{
  TNode <TScene*>*temp;
  for (temp = scenes->front; temp != NULL; temp = temp->next)
    ((TScene*)temp->getValue())->free();

}
