#include <stdlib.h>

#include "../stuff/math_hlp.h"
#include "../resource.h"
#include "scnCredits.h"

TScnCredits::TScnCredits() 
{
}


#define POSZ -20
#define QUAD_SIZE 8

int TScnCredits::run(__int32 time) {
  
  TGLState::disable(GL_TEXTURE_2D);
  TGLState::disable(GL_ALPHA_TEST);
  TGLState::disable(GL_LIGHTING);
  TGLState::disable(GL_LIGHT0);
  glDepthMask(true);
  TGLState::enable(GL_DEPTH_TEST);
  
  
  glClear(GL_DEPTH_BUFFER_BIT);	// Clear The Screen And The Depth Buffer

 	// Reset FOV, just in case
  glMatrixMode(GL_PROJECTION);
  glPushMatrix();
 	glLoadIdentity();
  GLfloat param[4];
  glGetFloatv(GL_VIEWPORT, &param[0]);

	gluPerspective(45.0f,param[2]/param[3],0.1f,90);
	glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

  GLfloat code_alpha=0;
  GLfloat cr=(time-10000)*0.002f;
  if(time>10000) {
    code_alpha=(time-10000)*0.0005f;
    if(code_alpha>1.0f) code_alpha=1.0f;
  }
  if(time>20000) {
    code_alpha=(time-20000)*0.0005f;
    if(code_alpha>1.0f) code_alpha=1.0f;
    code_alpha=1-code_alpha;
  }
  GLfloat muzak_alpha=0;
  GLfloat mr=(time-25000)*0.002f;
  if(time>25000) {
    muzak_alpha=(time-25000)*0.0005f;
    if(muzak_alpha>1.0f) muzak_alpha=1.0f;
    code_alpha=0;
  }
  if(time>35000) {
    muzak_alpha=(time-35000)*0.0005f;
    if(muzak_alpha>1.0f) muzak_alpha=1.0f;
    muzak_alpha=1-muzak_alpha;
    code_alpha=0;
  }
  GLfloat gfx_alpha=0;
  GLfloat gr=(time-40000)*0.002f;
  if(time>40000) {
    gfx_alpha=(time-40000)*0.0005f;
    if(gfx_alpha>1.0f) gfx_alpha=1.0f;
    code_alpha=0;
    muzak_alpha=0;
  }
  if(time>50000) {
    gfx_alpha=(time-50000)*0.0005f;
    if(gfx_alpha>1.0f) gfx_alpha=1.0f;
    gfx_alpha=1-gfx_alpha;
    code_alpha=0;
    muzak_alpha=0;
  }

 	glLoadIdentity();
  glDepthMask(true);
  TGLState::disable(GL_ALPHA_TEST);
  TGLState::disable(GL_DEPTH_TEST);
  TGLState::enable(GL_BLEND);
  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
  
  glColor4f(1,1,1,code_alpha);
  TGLState::enable(GL_TEXTURE_2D);
  sharedTextures->bindTexture(CREDITS_CODE_TGA);
  glPushMatrix();
    glTranslatef(0,0,POSZ);
    glRotatef(cr, 1, 0, 0);
    glRotatef(cr, 0, 1, 0);
    glBegin(GL_QUADS);
    	glNormal3f( 0.0f, 0.0f,  1.0f);
			glTexCoord2f(0.0f, 0.0f); glVertex3f(-QUAD_SIZE,-QUAD_SIZE, 0);
			glTexCoord2f(1.0f, 0.0f); glVertex3f(+QUAD_SIZE,-QUAD_SIZE, 0);
			glTexCoord2f(1.0f, 1.0f); glVertex3f(+QUAD_SIZE,+QUAD_SIZE, 0);
			glTexCoord2f(0.0f, 1.0f); glVertex3f(-QUAD_SIZE,+QUAD_SIZE, 0);
	  glEnd();
  glPopMatrix();

  glColor4f(1,1,1,muzak_alpha);
  TGLState::enable(GL_TEXTURE_2D);
  sharedTextures->bindTexture(CREDITS_MUSIC_TGA);
  glPushMatrix();
    glTranslatef(0,0,POSZ+0.01f);
    glRotatef(mr, 1, 0, 0);
    glRotatef(mr, 0, 1, 0);
    glBegin(GL_QUADS);
    	glNormal3f( 0.0f, 0.0f,  1.0f);
			glTexCoord2f(0.0f, 0.0f); glVertex3f(-QUAD_SIZE,-QUAD_SIZE, 0);
			glTexCoord2f(1.0f, 0.0f); glVertex3f(+QUAD_SIZE,-QUAD_SIZE, 0);
			glTexCoord2f(1.0f, 1.0f); glVertex3f(+QUAD_SIZE,+QUAD_SIZE, 0);
			glTexCoord2f(0.0f, 1.0f); glVertex3f(-QUAD_SIZE,+QUAD_SIZE, 0);
	  glEnd();
  glPopMatrix();

  glColor4f(1,1,1,gfx_alpha);
  TGLState::enable(GL_TEXTURE_2D);
  sharedTextures->bindTexture(CREDITS_GFX_TGA);
  glPushMatrix();
    glTranslatef(0,0,POSZ+0.02f);
    glRotatef(gr, 1, 0, 0);
    glRotatef(gr, 0, 1, 0);
    glBegin(GL_QUADS);
    	glNormal3f( 0.0f, 0.0f,  1.0f);
			glTexCoord2f(0.0f, 0.0f); glVertex3f(-QUAD_SIZE,-QUAD_SIZE, 0);
			glTexCoord2f(1.0f, 0.0f); glVertex3f(+QUAD_SIZE,-QUAD_SIZE, 0);
			glTexCoord2f(1.0f, 1.0f); glVertex3f(+QUAD_SIZE,+QUAD_SIZE, 0);
			glTexCoord2f(0.0f, 1.0f); glVertex3f(-QUAD_SIZE,+QUAD_SIZE, 0);
	  glEnd();
  glPopMatrix();
  
 	glMatrixMode(GL_PROJECTION);
  glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
  glPopMatrix();

  return 1;
}

int TScnCredits::setup(int reason)
{
  strcpy(sceneName, "Credits");
  
  if(reason==REASON_INIT) {
    sharedTextures->insertTexture(CREDITS_CODE_TGA, USE_ALPHA);
    sharedTextures->insertTexture(CREDITS_MUSIC_TGA, USE_ALPHA);
    sharedTextures->insertTexture(CREDITS_GFX_TGA, USE_ALPHA);
  }
  
  return 1;
}

void TScnCredits::free() 
{
}
