#include <stdlib.h>
#include <math.h>
#include "scnDeformMesh.h"
#include "../resource.h"
#include "../scenefactory/debug.h"

TScnDeformMesh::TScnDeformMesh() 
{
}

typedef struct {
  GLfloat x,y,z;
} s3dp;

#define GRID_SIZE 10

static s3dp grid[(GRID_SIZE+1)*(GRID_SIZE+1)];

static void initGrid(GLfloat offs, GLfloat offs2, GLfloat rad) {
  GLfloat scale=10;
  for(int a=0;a<GRID_SIZE;a++) {
    for(int b=0;b<GRID_SIZE;b++) {
      GLfloat posx=(float)b/GRID_SIZE;
      GLfloat posy=(float)a/GRID_SIZE;
      GLfloat spos=(float)a*256/GRID_SIZE+offs;
      GLfloat spos2=(float)b*256/GRID_SIZE+offs2;
      
      grid[b+a*GRID_SIZE].x=(-scale/2)+posx*scale;
      grid[b+a*GRID_SIZE].y=(-scale/2)+posy*scale;
      grid[b+a*GRID_SIZE].z=(float)sin(spos*3.141592/256)*rad;
      grid[b+a*GRID_SIZE].z*=(float)cos(spos2*3.141592/256)*rad;
    }
  }
}

static void drawGrid(void) {
  int a;
  
  glBegin(GL_QUADS);
  for(a=0;a<GRID_SIZE-1;a++) {
    for(int b=0;b<GRID_SIZE-1;b++) {      
      GLfloat posx=(float)b/(GRID_SIZE-1);
      GLfloat posy=(float)a/(GRID_SIZE-1);
      
      glTexCoord2f(posx,posy);
      glVertex3f(grid[b+a*GRID_SIZE].x,grid[b+a*GRID_SIZE].y,grid[b+a*GRID_SIZE].z);

      posx=((float)b+1)/(GRID_SIZE-1);
      posy=(float)a/(GRID_SIZE-1);
      
      glTexCoord2f(posx,posy);
      glVertex3f(grid[(b+1)+a*GRID_SIZE].x,grid[(b+1)+a*GRID_SIZE].y,grid[(b+1)+a*GRID_SIZE].z);

      posx=((float)b+1)/(GRID_SIZE-1);
      posy=((float)a+1)/(GRID_SIZE-1);
      
      glTexCoord2f(posx,posy);
      glVertex3f(grid[(b+1)+(a+1)*GRID_SIZE].x,grid[(b+1)+(a+1)*GRID_SIZE].y,grid[(b+1)+(a+1)*GRID_SIZE].z);

      posx=((float)b)/(GRID_SIZE-1);
      posy=((float)a+1)/(GRID_SIZE-1);
      
      glTexCoord2f(posx,posy);
      glVertex3f(grid[b+(a+1)*GRID_SIZE].x,grid[b+(a+1)*GRID_SIZE].y,grid[b+(a+1)*GRID_SIZE].z);
    }
  }
  glEnd();
}

static GLfloat rx, ry, rz;
static GLfloat srx, sry, srz;
static GLfloat srx2, sry2, srz2;
static GLfloat sep=2.0f;

int TScnDeformMesh::run(__int32 time) 
{
  rx = time * 0.01f;  
  ry = time * 0.005f;  
  rz = time * 0.015f;  

  srx = time * 0.1f;  
  sry = time * 0.05f;  
  srz = time * 0.15f;  

  srx2 = time * 0.01f;  
  sry2 = time * 0.005f;  
  srz2 = time * 0.015f;  

  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// Clear The Screen And The Depth Buffer

 	glMatrixMode(GL_PROJECTION);
  glPushMatrix();
 	glLoadIdentity();
  GLfloat param[4];
  glGetFloatv(GL_VIEWPORT, &param[0]);

	gluPerspective(45.0f,param[2]/param[3],0.1f,90);
	glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

  glLoadIdentity();
  gluLookAt(
      -0.5f,0,12.0f, 
      -0.5f,0,0,
      
      0,1,0);

  TGLState::disable(GL_TEXTURE_2D);
  TGLState::enable(GL_BLEND);
  glBlendFunc(GL_ONE_MINUS_SRC_ALPHA, GL_SRC_ALPHA);
  TGLState::disable(GL_DEPTH_TEST);
	glColor4f(0.0f, 0.0f, 0.0f, 0.9f);
  glBegin(GL_QUADS);
    glVertex3f(-10,-10,0);
    glVertex3f( 10,-10,0);
    glVertex3f( 10, 10,0);
    glVertex3f(-10, 10,0);
  glEnd();
  
  TGLState::disable(GL_DEPTH_TEST);
  TGLState::enable(GL_TEXTURE_2D);
  TGLState::disable(GL_LIGHTING);
  TGLState::enable(GL_BLEND);


	
  
  GLfloat back_alpha=0;
  if(time<2000) {
    back_alpha=time/2000.0f;
  } else {
    back_alpha=1;
  }
  GLfloat greetz_alpha=0;
  if(time>2000 && time<4000) {
    greetz_alpha=(time-2000)/2000.0f;
  } else if(time>=4000) {
    greetz_alpha=1;
  }
  GLfloat were_alpha=0;
  if(time>10000 && time<12000) {
    greetz_alpha=1.0f-((time-10000)/2000.0f);
    were_alpha=(time-10000)/2000.0f;
  } else if(time>=12000) {
    greetz_alpha=0;
    were_alpha=1;
  }


  sharedTextures->bindTexture(BACKEND_TGA);			// Select Our Texture  
  glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
  glColor4f(1.0f, 1.0f, 1.0f, back_alpha);
  initGrid(srz2,srx2,2);
  drawGrid();
 
  sharedTextures->bindTexture(GREETZ_TGA);			// Select Our Texture  
  glBlendFunc(GL_SRC_ALPHA, GL_ONE);
  glColor4f(1.0f, 1.0f, 1.0f, greetz_alpha);
  initGrid(srx,sry,1);
  drawGrid();

  
  sharedTextures->bindTexture(WERE_TGA);			// Select Our Texture  
  glBlendFunc(GL_SRC_ALPHA, GL_ONE);
  glColor4f(1.0f, 1.0f, 1.0f, were_alpha);
  initGrid(srx,sry,1);
  drawGrid();

  return 1;
}


int TScnDeformMesh::setup(int reason)
{
  strcpy(sceneName, "Greets & Stuff");

  if(reason==REASON_INIT) {
    initGrid(0,0,0);
    sharedTextures->insertTexture(BACKEND_TGA, NOT_USE_ALPHA);
    sharedTextures->insertTexture(GREETZ_TGA, NOT_USE_ALPHA);
    sharedTextures->insertTexture(WERE_TGA, NOT_USE_ALPHA);
  } else if(reason==REASON_AFTERTEXTURES) {
  }

  return 1;
}

void TScnDeformMesh::free() 
{
}
