#include <stdlib.h>
#include "scnFlares.h"
#include "../resource.h"

#define CUBEY 6
#define CUBEX 6
#define CUBEZ 6

#define FLARESEPARATIONX 2.0f
#define FLARESEPARATIONY 2.0f
#define FLARESEPARATIONZ 2.0f

#define NUM_FLARES (CUBEX*CUBEY*CUBEZ)


static GLfloat agx[NUM_FLARES], spdx[NUM_FLARES];

TScnFlares::TScnFlares() 
{
}


static GLfloat rx, ry, rz;
static GLfloat rp=(CUBEZ)*(FLARESEPARATIONZ);


int TScnFlares::run(__int32 time) 
{

//  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// Clear The Screen And The Depth Buffer
  TGLState::disable(GL_LIGHTING);
  TGLState::disable(GL_DEPTH_TEST);
  TGLState::disable(GL_ALPHA_TEST);
  TGLState::enable(GL_BLEND);
  glBlendFunc(GL_SRC_ALPHA, GL_ONE);
  TGLState::enable(GL_TEXTURE_2D);
  sharedTextures->bindTexture(FLARE1_TGA);			// Select Our Texture  
  glColor4f(1,1,1,1);

  GLfloat t_alpha=1;
  if(time>25500) {
    GLfloat tt=(GLfloat)time-25500.0f;
    GLfloat et=5000;
    t_alpha=1.0f-tt/et;
  }

  rx = time * 0.01f;  
  ry = time * 0.005f;  
  rz = time * 0.015f;  
  rp = (CUBEZ)*(FLARESEPARATIONZ) + ((GLfloat)time * -0.001f);
  if(rp<-5) rp=-5;

  glLoadIdentity();
  glTranslatef(0,0,rp);  
  glRotatef(rx, 1, 0, 0);
  glRotatef(ry, 0, 1, 0);
  glRotatef(rz, 0, 0, 1);
  
  glColor4f(1,1,0,t_alpha);

  for (int z = (-CUBEZ / 2); z < (CUBEZ / 2); z++)
    for (int y = -CUBEY / 2; y < CUBEY / 2; y++)
      for (int x = -CUBEX / 2; x < CUBEX / 2; x++)
      {
        GLfloat xS = (x+0.5f) * FLARESEPARATIONX;
        GLfloat yS = (y+0.5f) * FLARESEPARATIONY;
        GLfloat zS = (z+0.5f) * FLARESEPARATIONZ;

        glPushMatrix();
        glTranslatef(xS, yS, zS);
        glRotatef(-rz, 0, 0, 1);
        glRotatef(-ry, 0, 1, 0);
        glRotatef(-rx, 1, 0, 0);
        glRotatef(agx[(x+(CUBEX/2))*(y+(CUBEY/2))*(z+(CUBEZ/2))], 0, 0, 1);
			  glBegin(GL_QUADS);
      		glNormal3f( 0.0f, 0.0f,  1.0f);
				  glTexCoord2f(0.0f, 0.0f); glVertex3f(-1.0f,-1.0f, 0);
				  glTexCoord2f(1.0f, 0.0f); glVertex3f(+1.0f,-1.0f, 0);
				  glTexCoord2f(1.0f, 1.0f); glVertex3f(+1.0f,+1.0f, 0);
				  glTexCoord2f(0.0f, 1.0f); glVertex3f(-1.0f,+1.0f, 0);
			  glEnd();
        glPopMatrix();
      }

  for(int i=0;i<NUM_FLARES; i++) {
    agx[i]=spdx[i]*time;
  }
 
  return 1;
}

int TScnFlares::setup(int reason)
{
  strcpy(sceneName, "Flares");
 
  if(reason==REASON_INIT) {
    sharedTextures->insertTexture(FLARE1_TGA, NOT_USE_ALPHA);

  
    for(int i=0;i<NUM_FLARES; i++) {
      agx[i]=0.0f;
      spdx[i]=1/(GLfloat)(rand()%100);
    }
  }

  return 1;
}

void TScnFlares::free() 
{
}
