#include <stdlib.h>
#include "../stuff/math_hlp.h"
#include "../resource.h"
#include "scnLightball.h"

static GLUquadricObj *quadratic;
static GLUquadricObj *backsphere;

TScnLightball::TScnLightball() 
{
}


static GLfloat rx=0, ry=0, rz=0, posz=30;
static GLfloat brx=0, bry=0, brz=0;

int TScnLightball::run(__int32 time) {
  quadratic=gluNewQuadric();
	gluQuadricNormals(quadratic, GLU_SMOOTH);
	gluQuadricTexture(quadratic, GL_TRUE);	
  backsphere=gluNewQuadric();
	gluQuadricNormals(backsphere, GLU_SMOOTH);
	gluQuadricTexture(backsphere, GL_TRUE);	

  
	//  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// Clear The Screen And The Depth Buffer
  TGLState::disable(GL_TEXTURE_2D);
  TGLState::disable(GL_ALPHA_TEST);
  TGLState::disable(GL_LIGHTING);
  TGLState::disable(GL_LIGHT0);
  glDepthMask(true);
  TGLState::enable(GL_DEPTH_TEST);

  GLfloat LightAmbient[]=		{ 0.0f, 0.0f, 0.0f, 1.0f };
  GLfloat LightDiffuse[]=		{ 1.0f, 1.0f, 1.0f, 1.0f };
  GLfloat LightDirection[]=	{ 1.0f, 0.0f, 0.0f };
  GLfloat LightPosition[]=	{ 0.0f, 0.0f, 0.0f, 1.0f };

 	glMatrixMode(GL_PROJECTION);
  glPushMatrix();
 	glLoadIdentity();
  GLfloat param[4];
  glGetFloatv(GL_VIEWPORT, &param[0]);

	gluPerspective(45.0f,param[2]/param[3],0.1f,90);
	glMatrixMode(GL_MODELVIEW);
  glPushMatrix();

  glLoadIdentity();

  GLfloat motionblurFactor=1.0;
  if(time>10000) {
    motionblurFactor=(time-10000)*0.00004f;
    motionblurFactor=1-motionblurFactor;
  }
  if(motionblurFactor<0.1f) motionblurFactor=0.1f;
  GLfloat color=0;
  if(time>55000) {
    color=(time-55000)*0.0001f;
    if(color>1.0f) color=1.0f;
    color=1.0f-color;
    glColor4f(color,color,color,motionblurFactor);
  } else if(time>5000) {
    color=(time-5000)*0.0001f;
    if(color>1.0f) color=1.0f;
    glColor4f(color,color,color,motionblurFactor);
  } else if(time<5000) {
    glColor4f(0,0,0,motionblurFactor);
  } else {
    glColor4f(1,1,1,motionblurFactor);
  }

  posz=30-(GLfloat)time*0.01f;
  if(posz<-20) posz=-20;

  if(time>65000)
    posz=-20+(GLfloat)(time-65000)*0.01f;
  if(posz>30) posz=30;

  brx=time*0.02f;
  bry=time*0.03f;
  brz=time*0.05f;
  rx=time*0.01f;
  ry=time*0.02f;
  rz=time*0.03f;


    glPushMatrix();
      glTranslatef(0,0,posz);
      TGLState::enable(GL_LIGHTING);
      TGLState::enable(GL_LIGHT0);
      glLightfv(GL_LIGHT0, GL_AMBIENT, LightAmbient);
      glLightfv(GL_LIGHT0, GL_DIFFUSE, LightDiffuse);
      glLightfv(GL_LIGHT0, GL_POSITION, LightPosition);
      glLightf(GL_LIGHT0, GL_CONSTANT_ATTENUATION, 5.0f);
    glPopMatrix();

    TGLState::disable(GL_DEPTH_TEST);
    TGLState::enable(GL_BLEND);
    glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);

    TGLState::enable(GL_TEXTURE_2D);
    sharedTextures->bindTexture(BACKSPHERE_TGA);
    gluQuadricDrawStyle(backsphere, GLU_FILL);
    gluQuadricOrientation(backsphere, GLU_INSIDE);
  
    glPushMatrix();
      glRotatef(brx, 1, 0, 0);
      glRotatef(bry, 0, 1, 0);
      glRotatef(brz, 0, 0, 1);
      gluSphere(backsphere,70.0f,32,32);
    glPopMatrix();

    glTranslatef(0,0,posz);

    TGLState::disable(GL_BLEND);
    TGLState::disable(GL_TEXTURE_2D);


    GLfloat t_alpha=mFabs(mSin((GLfloat)time*0.05f));
  
    GLfloat tx[6]={  0,  0, 10,-10,  0,  0};
    GLfloat ty[6]={  0,  0,  0,  0, 10,-10};
    GLfloat tz[6]={-10, 10,  0,  0,  0,  0};

    for(int i=0;i<6;i++) {
      glLoadIdentity();
      glTranslatef(0,0,posz);
      glRotatef(rx, 1, 0, 0);
      glRotatef(ry, 0, 1, 0);
      glRotatef(rz, 0, 0, 1);

      glTranslatef(tx[i],ty[i],tz[i]);

      glRotatef(rx, 1,0,0);
      glRotatef(ry, 0,1,0);
      glRotatef(rz, 0,0,1);
      gluQuadricOrientation(quadratic, GLU_OUTSIDE);
    
      glDepthMask(false);
      TGLState::enable(GL_DEPTH_TEST);

      gluQuadricTexture(quadratic, GL_TRUE);	
      TGLState::enable(GL_BLEND);
      glBlendFunc(GL_SRC_ALPHA, GL_ONE);
      glColor4f(1,1,1,0.9f);
      TGLState::enable(GL_TEXTURE_2D);
      sharedTextures->bindTexture(BACKSPHERE_TGA);
      gluQuadricDrawStyle(quadratic, GLU_FILL);
      gluSphere(quadratic,1.3f,32,8); 
      TGLState::disable(GL_TEXTURE_2D);

      gluQuadricTexture(quadratic, GL_FALSE);	
      glBlendFunc(GL_SRC_ALPHA, GL_ONE);
   
      glColor4f(1,1,1,t_alpha);
      gluQuadricDrawStyle(quadratic, GLU_SILHOUETTE);
      gluSphere(quadratic,1.5f,32,8);

    
      gluQuadricDrawStyle(quadratic, GLU_FILL);

      glColor4f(1,1,1,color/10.0f);
      glBlendFunc(GL_SRC_ALPHA, GL_ONE);
      gluQuadricOrientation(quadratic, GLU_INSIDE);
      glPushMatrix();
        gluCylinder(quadratic,0.001f,50.0f,500.0f,4,1);
        glRotatef(90, 1, 0, 0);
        gluCylinder(quadratic,0.001f,50.0f,500.0f,4,1);
        glRotatef(90, 1, 0, 0);
        gluCylinder(quadratic,0.001f,50.0f,500.0f,4,1);
        glRotatef(90, 1, 0, 0);
        gluCylinder(quadratic,0.001f,50.0f,500.0f,4,1);
      glPopMatrix();

      glPushMatrix();
        glRotatef(90, 0, 1, 0);
        gluCylinder(quadratic,0.001f,50.0f,500.0f,4,1);
        glRotatef(180, 0, 1, 0);
        gluCylinder(quadratic,0.001f,50.0f,500.0f,4,1);
      glPopMatrix();
    }

 	glMatrixMode(GL_PROJECTION);
  glPopMatrix();
	glMatrixMode(GL_MODELVIEW);
  glPopMatrix();

  TGLState::disable(GL_LIGHT0);

  gluDeleteQuadric(backsphere);
  gluDeleteQuadric(quadratic);
  return 1;
}

int TScnLightball::setup(int reason)
{
  strcpy(sceneName, "Lightball");
  
  if(reason==REASON_INIT)
    sharedTextures->insertTexture(BACKSPHERE_TGA, NOT_USE_ALPHA);
  
  return 1;
}

void TScnLightball::free() 
{
}
