#include <stdlib.h>
#include "../stuff/math_hlp.h"
#include "../stuff/vectors.h"
#include "../resource.h"
#include "../scenefactory/statemachine.h"
#include "scnTunnel.h"

#define Z_SEGMENTS 9
#define TUNNEL_LENGTH 90.0f
#define TUNNEL_RADIUS 2.0f
#define Y_SEGMENTS 5
#define TUNNEL_SPEED 0.01f

typedef struct {
  GLfloat radius;
  GLfloat posx[Z_SEGMENTS], posy[Z_SEGMENTS], posz[Z_SEGMENTS];

  GLfloat x[Y_SEGMENTS], y[Y_SEGMENTS], z[Y_SEGMENTS];
  GLfloat x2[Y_SEGMENTS], y2[Y_SEGMENTS], z2[Y_SEGMENTS];

  GLfloat speed;
  GLfloat segmentSize;
  vector3t normals[Z_SEGMENTS][Y_SEGMENTS];
} TGLTunnel;


static TGLTunnel tunnel;

static GLuint filter;						// Which Filter To Use
static GLuint fogMode[]= { GL_EXP, GL_EXP2, GL_LINEAR };	// Storage For Three Types Of Fog
static GLuint fogfilter= 2;					// Which Fog To Use
static GLfloat fogColor[4]= {0.0f, 0.0f, 0.0f, 1.0f};		// Fog Color


TScnTunnel::TScnTunnel() 
{
}


static GLfloat rz=0;
static GLfloat ral=0;
static GLfloat rFov=0;

static bool doUpdateTunnel=true;

static void getNormal(vector3t p, vector3t q, vector3t *normal) {

}

int TScnTunnel::run(__int32 time) 
{
  if(time>=39500) {
  	glMatrixMode(GL_PROJECTION);
  	glLoadIdentity();
    GLfloat param[4];
    glGetFloatv(GL_VIEWPORT, &param[0]);

    ral=(time-39500)*0.1f;
    GLfloat ang=45.0f+ral;
    if(ang>150) ang=150;
  	gluPerspective(ang,param[2]/param[3],0.1f,90.0f);
  	glMatrixMode(GL_MODELVIEW);
  } else {
  	glMatrixMode(GL_PROJECTION);
  	glLoadIdentity();
    GLfloat param[4];
    glGetFloatv(GL_VIEWPORT, &param[0]);

  	gluPerspective(45.0f,param[2]/param[3],0.1f,TUNNEL_LENGTH-tunnel.segmentSize*2);
    ral+=1.0f;    
  	glMatrixMode(GL_MODELVIEW);
  }

  glDepthMask(true);
  glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);	// Clear The Screen And The Depth Buffer
  TGLState::enable(GL_TEXTURE_2D);
  TGLState::enable(GL_DEPTH_TEST);
  TGLState::disable(GL_ALPHA_TEST);
  TGLState::disable(GL_BLEND);
  TGLState::enable(GL_LIGHTING);
	TGLState::enable(GL_LIGHT0);					
  glColor4f(1,1,1,1);

  GLfloat LightAmbient[]=		{ 0.0f, 0.0f, 0.0f, 1.0f };
  GLfloat LightDiffuse[]=		{ 1.0f, 1.0f, 1.0f, 1.0f };
  GLfloat LightSpecular[]=	{ 1.0f, 1.0f, 1.0f, 1.0f };
  GLfloat LightPosition[]=	{ 0.0f, 0.0f, 0.0f, 1.0f };

  LightPosition[1]=mSin(ral)*(TUNNEL_RADIUS-0.5f);
  LightPosition[0]=mCos(ral)*(TUNNEL_RADIUS-0.5f);
  ral=time*0.1f;

  sharedTextures->bindTexture(TUNNEL_TGA);

  glLightfv(GL_LIGHT0, GL_AMBIENT, LightAmbient);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, LightDiffuse);
	glLightfv(GL_LIGHT0, GL_SPECULAR, LightSpecular);
  glLightf(GL_LIGHT0, GL_CONSTANT_ATTENUATION, 1.0f);

  glShadeModel(GL_SMOOTH);

 
  glLoadIdentity();
	glLightfv(GL_LIGHT0, GL_POSITION,LightPosition);	// Position The Light
  
  GLfloat tt=(GLfloat) time/1000.0f;
  glTranslatef(0,0,0);
  glRotatef(rz,0,0,1);
  rz=time*0.01f;

  GLfloat t_alpha=1;
  if(time>60000) {
    GLfloat tt=(GLfloat)time-60000.0f;
    GLfloat et=5000;
    t_alpha=1.0f-tt/et;
  }
  GLfloat s_alpha=mFabs(mSin((GLfloat)time*0.05f)/3)*t_alpha;


  for(int i=0;i<Z_SEGMENTS-1;i++) {

    GLfloat t=(GLfloat)Y_SEGMENTS/2;

    for(int a=0;a<Y_SEGMENTS;a++) {
      tunnel.x[a]=(GLfloat)sin((GLfloat)a*3.141592/t)*tunnel.radius;
      tunnel.y[a]=(GLfloat)cos((GLfloat)a*3.141592/t)*tunnel.radius;
      int p=i-1;
      if(p<0) p=Y_SEGMENTS-1;
      tunnel.x2[a]=tunnel.x[a]+tunnel.posx[p];
      tunnel.y2[a]=tunnel.y[a]+tunnel.posy[p];
      tunnel.x[a]+=tunnel.posx[i];
      tunnel.y[a]+=tunnel.posy[i];

      tunnel.z[a]=tunnel.posz[i];
      tunnel.z2[a]=tunnel.posz[i]+tunnel.segmentSize;
    }
    for(a=0;a<Y_SEGMENTS;a++) {
      GLfloat x1, y1, z1;
      GLfloat x2, y2, z2;
      GLfloat x3, y3, z3;
      GLfloat x4, y4, z4;

      x1=tunnel.x[a];
      y1=tunnel.y[a];
      z1=tunnel.z[a];
      x2=tunnel.x2[a];
      y2=tunnel.y2[a];
      z2=tunnel.z2[a];
      x3=tunnel.x[(a+1)%Y_SEGMENTS];
      y3=tunnel.y[(a+1)%Y_SEGMENTS];
      z3=tunnel.z[(a+1)%Y_SEGMENTS];
      x4=tunnel.x2[(a+1)%Y_SEGMENTS];
      y4=tunnel.y2[(a+1)%Y_SEGMENTS];
      z4=tunnel.z2[(a+1)%Y_SEGMENTS];

    	glColor3f (t_alpha, t_alpha, t_alpha);
      TGLState::enable(GL_TEXTURE_2D);
      glBegin(GL_QUADS);
        glNormal3f(tunnel.normals[i][a].v[0], tunnel.normals[i][a].v[1], tunnel.normals[i][a].v[2]);
			  glTexCoord2f(0.0f, 0.0f); glVertex3f(x4,y4,z4);
			  glTexCoord2f(1.0f, 0.0f); glVertex3f(x2,y2,z2);
			  glTexCoord2f(1.0f, 1.0f); glVertex3f(x1,y1,z1);
			  glTexCoord2f(0.0f, 1.0f); glVertex3f(x3,y3,z3);
			glEnd();
      TGLState::disable(GL_TEXTURE_2D);
      TGLState::disable(GL_DEPTH_TEST);
      TGLState::enable(GL_BLEND);
      glBlendFunc(GL_SRC_ALPHA, GL_ONE);
    	glColor4f (0, 1, 0, s_alpha);
      glLineWidth(2);
      glBegin(GL_LINES);
        glVertex3f(x1,y1,z1);
			  glVertex3f(x2,y2,z2);

        glVertex3f(x3,y3,z3);
			  glVertex3f(x4,y4,z4);
        
			  glVertex3f(x2,y2,z2);
        glVertex3f(x4,y4,z4);

        glVertex3f(x1,y1,z1);
			  glVertex3f(x3,y3,z3);

        glVertex3f(x1,y1,z1);
			  glVertex3f(x4,y4,z3);
        
        glVertex3f(x2,y2,z1);
			  glVertex3f(x3,y3,z3);
      glEnd();
      glLineWidth(1);
      TGLState::disable(GL_BLEND);
    }   
  }

  TGLState::disable(GL_LIGHT0);
  TGLState::disable(GL_LIGHTING);

  GLfloat time_t;

  if(time>5000) doUpdateTunnel=false;


  for(i=0;i<Z_SEGMENTS;i++) {
    if(doUpdateTunnel) {    
      time_t=time*tunnel.speed;
      while(time_t>TUNNEL_LENGTH-tunnel.segmentSize) time_t-=TUNNEL_LENGTH-tunnel.segmentSize;
      tunnel.posz[i]=(GLfloat)i*-tunnel.segmentSize + time_t;
      while(tunnel.posz[i]>=0/*tunnel.segmentSize*/) {
        tunnel.posx[i]=0.0f;
        tunnel.posy[i]=0.0f;
        tunnel.posz[i]-=TUNNEL_LENGTH-tunnel.segmentSize;
      }
    } else {
      time_t=time*tunnel.speed;
      while(time_t>TUNNEL_LENGTH-tunnel.segmentSize) time_t-=TUNNEL_LENGTH-tunnel.segmentSize;
      tunnel.posz[i]=(GLfloat)i*-tunnel.segmentSize + time_t;
      if(tunnel.posz[i]>=0/*tunnel.segmentSize*/) {
        tunnel.posx[i]=0.0f;
        tunnel.posy[i]=0.0f;
        tunnel.posz[i]-=TUNNEL_LENGTH-tunnel.segmentSize;
      }
    }
  }

  return 1;
}


int TScnTunnel::setup(int reason)
{
  strcpy(sceneName, "Tunnel");

  if(reason==REASON_INIT) {
    sharedTextures->insertTexture(TUNNEL_TGA, NOT_USE_ALPHA);

	  tunnel.segmentSize=(GLfloat)TUNNEL_LENGTH/(GLfloat)Z_SEGMENTS;
    tunnel.radius=TUNNEL_RADIUS;
    tunnel.speed=TUNNEL_SPEED;  
    for(int i=0;i<Z_SEGMENTS;i++) {
      tunnel.posx[i]=0.0f;
      tunnel.posy[i]=0.0f;
      tunnel.posz[i]=(GLfloat)i*-tunnel.segmentSize;
    }


    for(i=0;i<Z_SEGMENTS-1;i++) {
      GLfloat t=(GLfloat)Y_SEGMENTS/2;
      for(int a=0;a<Y_SEGMENTS;a++) {
        tunnel.x[a]=(GLfloat)sin((GLfloat)a*3.141592/t)*tunnel.radius;
        tunnel.y[a]=(GLfloat)cos((GLfloat)a*3.141592/t)*tunnel.radius;
        int p=i-1;
        if(p<0) p=Y_SEGMENTS-1;
        tunnel.x2[a]=tunnel.x[a]+tunnel.posx[p];
        tunnel.y2[a]=tunnel.y[a]+tunnel.posy[p];
        tunnel.x[a]+=tunnel.posx[i];
        tunnel.y[a]+=tunnel.posy[i];

        tunnel.z[a]=tunnel.posz[i];
        tunnel.z2[a]=tunnel.posz[i]+tunnel.segmentSize;
      }
      for(a=0;a<Y_SEGMENTS;a++) {
        GLfloat x1, y1, z1;
        GLfloat x2, y2, z2;
        GLfloat x3, y3, z3;
        GLfloat x4, y4, z4;

        x1=tunnel.x[a];
        y1=tunnel.y[a];
        z1=tunnel.z[a];
        x2=tunnel.x2[a];
        y2=tunnel.y2[a];
        z2=tunnel.z2[a];
        x3=tunnel.x[(a+1)%Y_SEGMENTS];
        y3=tunnel.y[(a+1)%Y_SEGMENTS];
        z3=tunnel.z[(a+1)%Y_SEGMENTS];
        x4=tunnel.x2[(a+1)%Y_SEGMENTS];
        y4=tunnel.y2[(a+1)%Y_SEGMENTS];
        z4=tunnel.z2[(a+1)%Y_SEGMENTS];

  // Create the normals for this face
        vector3t verts[3];
        verts[0].v[0]=x4;
        verts[0].v[1]=y4;
        verts[0].v[2]=z4;
        verts[1].v[0]=x2;
        verts[1].v[1]=y2;
        verts[1].v[2]=z2;
        verts[2].v[0]=x1;
        verts[2].v[1]=y1;
        verts[2].v[2]=z1;
        vector3t p = verts[1] - verts[0];
        vector3t q = verts[2] - verts[0];

        vector3t l_normal;
        l_normal.Cross(p, q);
        l_normal.Normalize();
        tunnel.normals[i][a]=l_normal;
      }
    }
  }

  
  return 1;
}

void TScnTunnel::free() 
{
}
