#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

char str[256];
struct _ATOM
{
	float x,y,z,s;
	char a,idx,pad[2];
} atm[4096];
int bnd[4096][2];
int numa=0;
int numb=0;
FILE *fi;
FILE *fo;


char atomidx(char a)
{
	a=toupper(a);
	switch (a)
	{
	case 'H':
		return 0;
	case 'C':
		return 1;
	case 'O':
		return 2;
	case 'N':
		return 3;
	case 'P':
		return 4;
	default:
		return 5;
	}

}

float atomsize(char a)
{
	float sizes[8]={1,2,3};
	a=atomidx(a);
	return sizes[a];
}

readmdl()
{
	numa=numb=0;
	while (!feof(fi))
	{
		fgets(str,128,fi);
		if (strnicmp(str,"ATOM",4)==0 || strnicmp(str,"HETATM",6)==0)
		{
			int c1;
			char a;
			float x,y,z;
			char tempstr[123];
			sscanf(str,"%s %d %c %f %f %f",tempstr,&c1,&a,&x,&y,&z);
			if (c1!=numa+1) {printf("mismatched atom");exit(1);}
			printf("%d %f %f %f %c\n",numa,x,y,z,a);
			atm[numa].x=x;
			atm[numa].y=y;
			atm[numa].z=z;
			atm[numa].a=a;
			atm[numa].s=atomsize(a);
			atm[numa].idx=atomidx(a);
			numa++;
		}
		if (strnicmp(str,"CONECT",6)==0)
		{
			char tempstr[123];
			int n,d[8],s,c1;
			n=sscanf(str,"%s %d %d %d %d %d %d %d",tempstr,&s,d,d+1,d+2,d+3,d+4,d+5,d+6);
			n-=2;
			for (c1=0;c1<n;c1++) if (d[c1])
			{
				bnd[numb][0]=s-1;
				bnd[numb][1]=d[c1]-1;
				printf("%d %d %d\n",numb,bnd[numb][0],bnd[numb][1]);
				if (bnd[numb][0]>=numa || bnd[numb][1]>=numa) {printf("error in bond");exit(2);};
				numb++;
			}
		}

	}
}

readmol()
{
	numa=numb=0;
	do
	{
		fgets(str,128,fi);
		if (strlen(str)>32)
		{
			float x,y,z;
			char a;
			sscanf(str,"%f %f %f %c",&x,&y,&z,&a);
			printf("%d %f %f %f %c\n",numa,x,y,z,a);
			atm[numa].x=x;
			atm[numa].y=y;
			atm[numa].z=z;
			atm[numa].a=a;
			atm[numa].s=atomsize(a);
			atm[numa].idx=atomidx(a);
			numa++;
		}
	} while (strlen(str)>32);

	do
	{
		memmove(str+4,str+3,3);
		str[3]=' ';
		str[7]=0;
		sscanf(str,"%d %d",&bnd[numb][0],&bnd[numb][1]);
		bnd[numb][0]--;
		bnd[numb][1]--;
		printf("%d %d %d\n",numb,bnd[numb][0],bnd[numb][1]);
		if (bnd[numb][0]>=numa || bnd[numb][1]>=numa) {printf("error in bond");exit(2);};
		numb++;
		fgets(str,128,fi);
	} while (strlen(str)>6 && !feof(fi));
	printf("%d %d\n",numa,numb);


}

void process()
{
	float minx,miny,minz;
	float maxx,maxy,maxz;

	minx=miny=minz=1e20;
	maxx=maxy=maxz=-1e20;
	for (int c1=0;c1<numa;c1++)
	{
		if (atm[c1].x<minx) minx=atm[c1].x;if (atm[c1].x>maxx) maxx=atm[c1].x;
		if (atm[c1].y<miny) miny=atm[c1].y;if (atm[c1].y>maxy) maxy=atm[c1].y;
		if (atm[c1].z<minz) minz=atm[c1].z;if (atm[c1].z>maxz) maxz=atm[c1].z;
	}

	fwrite(&numa,1,4,fo);
	fwrite(&numb,1,4,fo);
	fwrite(&minx,1,4,fo);
	fwrite(&miny,1,4,fo);
	fwrite(&minz,1,4,fo);
	fwrite(&maxx,1,4,fo);
	fwrite(&maxy,1,4,fo);
	fwrite(&maxz,1,4,fo);

	printf("%8.2f, %8.2f, %8.2f\n%8.2f, %8.2f, %8.2f\n",minx,miny,minz,maxx,maxy,maxz);

	fwrite(atm,numa,sizeof(ATOM),fo);
	fwrite(bnd,numb,8,fo);

	fclose(fi);
	fclose(fo);
}

main(int argc,char *argv[])
{
	char stri[1024];
	char stri2[1024];
	char stro[1024];

	if (argc!=2) exit(1);
	sprintf(stri,"data\\%s.mol",argv[1]);
	sprintf(stri2,"data\\%s.mdl",argv[1]);
	sprintf(stro,"data\\%s.m",argv[1]);

	fi=fo=NULL;
	fi=fopen(stri,"r");
	if (fi)
	{
		fo=fopen(stro,"wb");
		if (fi && fo)
		{
			readmol();
			process();
		}
	}
	else
	{
		fi=fopen(stri2,"r");
		if (fi)
		{
			fo=fopen(stro,"wb");
			if (fi && fo)
			{
				readmdl();
				process();
			}
		}
	}
}