
// ------------------------------------------------------------------------------------------------
//  LineBlend.cpp - Blending Lines.
//  Copyright (C) 2001. Remage / Fresh!mindworkz.
// ------------------------------------------------------------------------------------------------

#include <StdIO.h>
#include <Windows.h>
#include <D3D8.h>
#include "D3DU8.h"

#include "Main.h"
#include "Fmath.h"
#include "TxGen.h"
#include "Rand.h"

// ------------------------------------------------------------------------------------------------

#define D3DFVF_LINEBLEND_VERTEX1 (D3DFVF_XYZ|D3DFVF_DIFFUSE)

typedef struct _LINEBLEND_VERTEX1
  {
    D3DVECTOR Vertex;
    DWORD Diffuse;
   } LINEBLEND_VERTEX1;

LPDIRECT3DVERTEXBUFFER8 LineBlend_VertexBuffer1, LineBlend_VertexBuffer2;
LINEBLEND_VERTEX1 *LineBlend_LockedVertexBuffer1, *LineBlend_LockedVertexBuffer2;

#define LINES 16
float Lines[LINES][4];

// ------------------------------------------------------------------------------------------------

int LineBlend_Initialize( void )
  {
    int I;
    RandSeed = 0;
    for ( I=0; I<LINES; I++ )
      {
        Lines[ I ][0] = 160.0f + 40.0f * Fsin( (float) ( Rand() & 511 ) / 511.0f * Fmath_2Pi );
        Lines[ I ][1] = Fsqr( Fsqr( (float) ( Rand() & 511 ) / 511 ));
        Lines[ I ][2] = (float) ( Rand() & 511 ) / 511.0f;
        Lines[ I ][3] = (float) ( Rand() & 511 ) / 511.0f;
       }

    // --- VertexBuffer1.
    if ( Direct3DDevice->CreateVertexBuffer( 8*sizeof( LINEBLEND_VERTEX1 ), 0, D3DFVF_LINEBLEND_VERTEX1,
      D3DPOOL_DEFAULT, &LineBlend_VertexBuffer1 ) != D3D_OK ) return 0;
    if ( LineBlend_VertexBuffer1->Lock( 0, 8*sizeof( LINEBLEND_VERTEX1 ), (BYTE**) &LineBlend_LockedVertexBuffer1, 0 ) != D3D_OK ) return 0;

    D3DUVec3Create( &LineBlend_LockedVertexBuffer1[ 0 ].Vertex, 0.0f, 320.0f, 1.0f );
      LineBlend_LockedVertexBuffer1[ 0 ].Diffuse = 0x101010;
    D3DUVec3Create( &LineBlend_LockedVertexBuffer1[ 1 ].Vertex, 640.0f, 320.0f, 1.0f );
      LineBlend_LockedVertexBuffer1[ 1 ].Diffuse = 0x101010;
    D3DUVec3Create( &LineBlend_LockedVertexBuffer1[ 2 ].Vertex, 0.0f, 384.0f, 1.0f );
      LineBlend_LockedVertexBuffer1[ 2 ].Diffuse = 0x000000;
    D3DUVec3Create( &LineBlend_LockedVertexBuffer1[ 3 ].Vertex, 640.0f, 384.0f, 1.0f );
      LineBlend_LockedVertexBuffer1[ 3 ].Diffuse = 0x000000;
    D3DUVec3Create( &LineBlend_LockedVertexBuffer1[ 4 ].Vertex, 0.0f, 384.0f, 1.0f );
      LineBlend_LockedVertexBuffer1[ 4 ].Diffuse = 0x101010;
    D3DUVec3Create( &LineBlend_LockedVertexBuffer1[ 5 ].Vertex, 640.0f, 384.0f, 1.0f );
      LineBlend_LockedVertexBuffer1[ 5 ].Diffuse = 0x101010;
    D3DUVec3Create( &LineBlend_LockedVertexBuffer1[ 6 ].Vertex, 0.0f, 420.0f, 1.0f );
      LineBlend_LockedVertexBuffer1[ 6 ].Diffuse = 0x0E0E0E;
    D3DUVec3Create( &LineBlend_LockedVertexBuffer1[ 7 ].Vertex, 640.0f, 420.0f, 1.0f );
      LineBlend_LockedVertexBuffer1[ 7 ].Diffuse = 0x0E0E0E;

    LineBlend_VertexBuffer1->Unlock();

    // --- VertexBuffer2.
    if ( Direct3DDevice->CreateVertexBuffer( LINES * 6 * sizeof( LINEBLEND_VERTEX1 ), 0, D3DFVF_LINEBLEND_VERTEX1,
      D3DPOOL_DEFAULT, &LineBlend_VertexBuffer2 ) != D3D_OK ) return 0;

    return 1;
   }

// ------------------------------------------------------------------------------------------------

void  LineBlend_Cleanup( void )
  {
    if ( LineBlend_VertexBuffer1 ) LineBlend_VertexBuffer1->Release();
    if ( LineBlend_VertexBuffer2 ) LineBlend_VertexBuffer2->Release();
   }

// ------------------------------------------------------------------------------------------------
//  Assume that most settings is correct (matrices, etc.). 
//  Should be called right after SphereBack render routine.

void LineBlend_Render( float Time )
  {
    float Move, Light, Time2 = Time / 30.0f;
    int I;

    if ( Time <= 0.0f ) Light = 0.0f;
    if (( Time > 0.0f ) && ( Time <= 128.0f )) Light = Time / 128.0f;
    if (( Time > 128.0f ) && ( Time <= 29.0f * 64.0f )) Light = 1.0f;
    if (( Time > 29.0f * 64.0f ) && ( Time <= 30.0f * 64.0f )) Light = ( 30.0f * 64.0f - Time ) / 64.0f;
    if ( Time > 30.0f * 64.0f ) Light = 0.0f;
      
    Direct3DDevice->SetRenderState( D3DRS_TEXTUREFACTOR, 0x010101 * Fround( 127.0f * Light ));

    Direct3DDevice->SetRenderState( D3DRS_LIGHTING, FALSE );
    Direct3DDevice->LightEnable( 0, FALSE );

    // --- Setup.
    Direct3DDevice->SetRenderState( D3DRS_ZENABLE, FALSE );
    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, TRUE );
    Direct3DDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_ONE );
    Direct3DDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_ONE );

    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLOROP, D3DTOP_MODULATE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_DIFFUSE );
    Direct3DDevice->SetTextureStageState( 0, D3DTSS_COLORARG1, D3DTA_TFACTOR );

    Direct3DDevice->SetTextureStageState( 1, D3DTSS_COLOROP, D3DTOP_DISABLE );

    Direct3DDevice->SetVertexShader( D3DFVF_LINEBLEND_VERTEX1 );
    
    // --- Setup Matrices.
    Direct3DDevice->SetTransform( D3DTS_WORLD, &D3DUMatrixIdentity );

    D3DUVec3Create( &D3DVector_CameraPosition, 319.5f, 240.5f, -1.0f );
    D3DUVec3Create( &D3DVector_CameraTarget, 319.5f, 240.5f, 0.0f );
    D3DUVec3Create( &D3DVector_Up, 0.0f, -1.0f, 0.0f );
    D3DUMatrixLookAtLH( &D3DMatrix_View, &D3DVector_CameraPosition, &D3DVector_CameraTarget, &D3DVector_Up );
    Direct3DDevice->SetTransform( D3DTS_VIEW, &D3DMatrix_View );

    D3DUMatrixOrthoLH( &D3DMatrix_Projection, 640.0f, 360.0f, 0.1f, 10.0f );
    Direct3DDevice->SetTransform( D3DTS_PROJECTION, &D3DMatrix_Projection );

    // --- Render.
    Direct3DDevice->SetStreamSource( 0, LineBlend_VertexBuffer1, sizeof( LINEBLEND_VERTEX1 ));
    Direct3DDevice->DrawPrimitive( D3DPT_TRIANGLESTRIP, 0, 6 );

    // === Dark Lines.

    if ( LineBlend_VertexBuffer2->Lock( 0, LINES * 6 * sizeof( LINEBLEND_VERTEX1 ), (BYTE**) &LineBlend_LockedVertexBuffer2, 0 ) != D3D_OK ) return;
    for ( I=0; I<LINES; I++ )
      {
        if ( Time <= I + 15.5f * 64.0f ) Move = 0.0f;
        if (( Time > I + 15.5f * 64.0f ) && ( Time <= I + 16.5f * 64.0f )) Move = 1.0f - Fcos(( Time - I - 15.5f * 64.0f ) / 64.0f * Fmath_Pi );
        if (( Time > I + 16.5f * 64.0f ) && ( Time <= I + 24.5f * 64.0f )) Move = 2.0f;
        if (( Time > I + 24.5f * 64.0f ) && ( Time <= I + 25.5f * 64.0f )) Move = 1.0f - Fcos(( I + 25.5f * 64.0f - Time ) / 64.0f * Fmath_Pi );
        if ( Time > I + 25.5f * 64.0f ) Move = 0.0f;

        Move *= 160.0f;
  
        // 0x010101 * Fround( 20.0f * ( 1.0f - Lines[ I ][1] ));

        D3DUVec3Create( &LineBlend_LockedVertexBuffer2[ 6*I+0 ].Vertex, 
            Move + Lines[ I ][0] + 80.0f * Lines[ I ][2] * Fsin(( Lines[ I ][2] + Lines[ I ][3] * Time2 ) * Fmath_2Pi ) - 80.0f * Lines[ I ][1], 60.0f, 1.0f );
          LineBlend_LockedVertexBuffer2[ 6*I+0 ].Diffuse = ( Fround( 20.0f * ( 1.0f - Lines[ I ][1] )) << 24 );
        D3DUVec3Create( &LineBlend_LockedVertexBuffer2[ 6*I+1 ].Vertex, 
            Move + Lines[ I ][0] + 80.0f * Lines[ I ][2] * Fsin(( Lines[ I ][2] + Lines[ I ][3] * Time2 ) * Fmath_2Pi ) + 80.0f * Lines[ I ][1], 60.0f, 1.0f );
          LineBlend_LockedVertexBuffer2[ 6*I+1 ].Diffuse = ( Fround( 20.0f * ( 1.0f - Lines[ I ][1] )) << 24 );
        D3DUVec3Create( &LineBlend_LockedVertexBuffer2[ 6*I+2 ].Vertex,
            Move + Lines[ I ][0] + 80.0f * Lines[ I ][2] * Fsin(( Lines[ I ][2] + Lines[ I ][3] * Time2 ) * Fmath_2Pi ) - 80.0f * Lines[ I ][1], 420.0f, 1.0f );
          LineBlend_LockedVertexBuffer2[ 6*I+2 ].Diffuse = ( Fround( 20.0f * ( 1.0f - Lines[ I ][1] )) << 24 );
        D3DUVec3Create( &LineBlend_LockedVertexBuffer2[ 6*I+3 ].Vertex,
            Move + Lines[ I ][0] + 80.0f * Lines[ I ][2] * Fsin(( Lines[ I ][2] + Lines[ I ][3] * Time2 ) * Fmath_2Pi ) + 80.0f * Lines[ I ][1], 60.0f, 1.0f );
          LineBlend_LockedVertexBuffer2[ 6*I+3 ].Diffuse = ( Fround( 20.0f * ( 1.0f - Lines[ I ][1] )) << 24 );
        D3DUVec3Create( &LineBlend_LockedVertexBuffer2[ 6*I+4 ].Vertex,
            Move + Lines[ I ][0] + 80.0f * Lines[ I ][2] * Fsin(( Lines[ I ][2] + Lines[ I ][3] * Time2 ) * Fmath_2Pi ) - 80.0f * Lines[ I ][1], 420.0f, 1.0f );
          LineBlend_LockedVertexBuffer2[ 6*I+4 ].Diffuse = ( Fround( 20.0f * ( 1.0f - Lines[ I ][1] )) << 24 );
        D3DUVec3Create( &LineBlend_LockedVertexBuffer2[ 6*I+5 ].Vertex,
            Move + Lines[ I ][0] + 80.0f * Lines[ I ][2] * Fsin(( Lines[ I ][2] + Lines[ I ][3] * Time2 ) * Fmath_2Pi ) + 80.0f * Lines[ I ][1], 420.0f, 1.0f );
          LineBlend_LockedVertexBuffer2[ 6*I+5 ].Diffuse = ( Fround( 20.0f * ( 1.0f - Lines[ I ][1] )) << 24 );
/*
        Lines[ I ][0] = 420.0f + 40.0f * Fsin( (float) ( Rand() & 511 ) / 511.0f * Fmath_2Pi );
        Lines[ I ][1] = Fsqr( Fsqr( (float) ( Rand() & 511 ) / 511 ));
        Lines[ I ][2] = (float) ( Rand() & 511 ) / 511.0f;
        Lines[ I ][3] = (float) ( Rand() & 511 ) / 511.0f;
*/
       }

    LineBlend_VertexBuffer2->Unlock();

    Direct3DDevice->SetRenderState( D3DRS_SRCBLEND, D3DBLEND_SRCALPHA );
    Direct3DDevice->SetRenderState( D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA );

    // --- Render.
    Direct3DDevice->SetStreamSource( 0, LineBlend_VertexBuffer2, sizeof( LINEBLEND_VERTEX1 ));
    Direct3DDevice->DrawPrimitive( D3DPT_TRIANGLELIST, 0, LINES*2 );

    // --- Cleanup.
    Direct3DDevice->SetRenderState( D3DRS_ALPHABLENDENABLE, FALSE );
    Direct3DDevice->SetRenderState( D3DRS_ZENABLE, TRUE );
   }
