        .386p
code32  segment para public use32
        assume cs:code32, ds:code32

include pmode.inc

public  _vrt_rout, _vrt_timer, _vrt_palptr, _vrt_pallen, _vrt_palindex

public  _vrt_init, _vrt_uninit, _vrt_settimer

;
; DATA
;
align 4
ormirq0vect     dd      ?
opmirq0vect     dd      ?

_vrt_rout       dd      _ret            ; routine to call on every retrace
_vrt_timer      dd      0               ; incrementing timer per retrace
_vrt_palptr     dd      ?               ; ptr to RGB data for pal setting
_vrt_pallen     dw      ?               ; number of colors to set left
_vrt_palindex   db      ?               ; next color to set

;
; CODE
;

;
align 4
vrtirqpm:
        push eax edx
        mov dx,3dah
        in al,dx
        push ds
        mov ds,cs:_seldata
        and eax,8
        dec eax
        neg eax
        add vrtv,ax
        in al,dx
        test al,8
        jz $-3
        mov ax,vrtv
        out 40h,al
        mov al,ah
        out 40h,al
        mov al,20h
        out 20h,al
        sti
        cld
        push ecx esi
        movzx ecx,_vrt_pallen
        or ecx,ecx
        jz short vrtirqpmf0
        mov dx,3c8h
        mov al,_vrt_palindex
        out dx,al
        inc edx
        mov esi,ecx
        cmp ecx,80h
        jbe short vrtirqpmf1
        mov ecx,80h
vrtirqpmf1:
        sub esi,ecx
        add al,cl
        mov _vrt_pallen,si
        mov _vrt_palindex,al
        mov esi,_vrt_palptr
        lea ecx,[ecx*2+ecx]
        rep outsb
        mov _vrt_palptr,esi
vrtirqpmf0:
        inc _vrt_timer
        call _vrt_rout
        pop esi ecx ds edx eax
        iretd

;
align 4
vrtirqrm:                       ; This is 16bit code in a 32bit segment
        db 50h,52h              ; PUSH AX DX
        db 0bah,0dah,3          ; MOD DX,3dah
        db 0ech                 ; IN AL,DX
        db 25h,8,0              ; AND AX,8
        db 48h                  ; DEC AX
        db 0f7h,0d8h            ; NEG AX
        db 2eh,1,6              ; ADD CS:VRTV,AX
vrtirqrmm0      dw      ?       ;
        db 0ech                 ; IN AL,DX
        db 0a8h,8               ; TEST AL,8
        db 74h,0fbh             ; JZ SHORT $-3
        db 0ebh,0               ; JMP SHORT $+2
        db 0b8h                 ; MOV AX,vrtv
vrtv    dw      4100h           ;
        db 0e6h,40h             ; OUT 40h,AL
        db 88h,0e0h             ; MOV AL,AH
        db 0e6h,40h             ; OUT 40h,AL
        db 2eh,066h,0ffh,6      ; INC DWORD PTR CS:_VRT_TIMER
vrtirqrmm1      dw      ?       ;
        db 05ah                 ; POP DX
        db 0b0h,20h             ; MOV AL,20h
        db 0e6h,20h             ; OUT 20h,AL
        db 58h                  ; POP AX
        db 0cfh                 ; IRET

;
; Set up vertical retrace stuff
; Out:
;   EAX,BX,EDX - ?
; Notes:
;   Uses IRQ 0.
;
_vrt_init:
        mov ax,900h
        int 31h
        push ax

        mov eax,offset _vrt_timer
        add eax,_code32a
        shl eax,12
        shr ax,12
        mov vrtirqrmm1,ax
        mov edx,offset vrtv-offset _vrt_timer
        add dx,ax
        mov vrtirqrmm0,dx
        mov edx,offset vrtirqrm-offset _vrt_timer
        add ax,dx
        xchg eax,gs:[8*4]
        mov ormirq0vect,eax

        xor bl,bl
	call _getirqvect
	mov opmirq0vect,edx
        mov edx,offset vrtirqpm
        call _setirqvect

        mov al,30h
        out 43h,al
        mov al,00h
        out 40h,al
        mov al,41h
        out 40h,al

        call _vrt_settimer

        pop ax
        int 31h
        ret

;
; Uninit vertical retrace stuff
; Out:
;   AX,BX,EDX - ?
;
_vrt_uninit:
        mov ax,900h
        int 31h
        push ax

        mov edx,ormirq0vect
        mov gs:[8*4],edx
        mov edx,opmirq0vect
        xor bl,bl
        call _setirqvect

        mov al,36h
        out 43h,al
        xor al,al
        out 40h,al
        out 40h,al

        pop ax
        int 31h
        ret

;
; Set timer to current retrace period exactly
; Out:
;   AX,BX,DX - ?
;
_vrt_settimer:
        mov ax,900h
        int 31h
        push ax

        mov al,30h
        out 43h,al
        mov dx,3dah
        in al,dx
        test al,8
        jnz $-3
        in al,dx
        test al,8
        jz $-3
        xor al,al
        out 40h,al
        out 40h,al

        in al,dx
        test al,8
	jnz $-3
        in al,dx
        test al,8
        jz $-3
        in al,40h
	mov ah,al
	in al,40h
	xchg al,ah
	neg ax
        sub ax,0c0h
        mov vrtv,ax
	mov bx,ax

        in al,dx
        test al,8
        jz $-3
        in al,dx
        test al,8
        jnz $-3
	mov al,bl
        out 40h,al
	mov al,bh
        out 40h,al

        pop ax
        int 31h
        ret

code32  ends
        end

