//
//				+-------------------------------------------------------------------+
//				|						ElemAff.cpp									|
//				|																	|
//				| Defininit tout les elements ki devront etre affichs poil au nez	|
//				|																	|
//				|  David-U2/GameSquad 1999(c)										|
//				+-------------------------------------------------------------------+


#include "stdafx.h"
#include "..\include\Vip2Headers.h"


//-------------------------------------------------------------------------------------------------------------------------
//									+-------------------+
//									| Class BitmapSkin  |
//									+-------------------+
//-------------------------------------------------------------------------------------------------------------------------
BitmapSkin::BitmapSkin( int ID, LPCSTR nomOpen, BOOL msk )
{
	Mask = msk		;
	IDBit = ID		;
	suiv = NULL		;
	suivList = NULL	;

	DIBRender::LoadBitmapJpg( nomOpen, dx, dy, Bit )	;
}
//-------------------------------------------------------------------------------------------------------------------------
BitmapSkin::~BitmapSkin()
{
	delete [] Bit	;
}
//-------------------------------------------------------------------------------------------------------------------------
// affiche la bitmap
void BitmapSkin::Affiche( int x, int y )
{
	int dep=0						;
	int depS=y*DIBRender::GetXSize()	;

	if( Mask )	// n'affiche pas la couleur de mask
	{
		for(int a=0; a<dy; a++,depS+=DIBRender::GetXSize() )
			for(int b=0; b<dx; b++,dep++)
				if( Bit[dep] != TRANSP_COLOR_SKIN )
					DIBRender::BackGen[ depS+b+x ] = Bit[dep]	;
	}
	else
	{
		for( int a=0; a<dy; a++,depS+=DIBRender::GetXSize() )
			for( int b=0; b<dx; b++,dep++ )
				DIBRender::BackGen[ depS+b+x ] = Bit[dep]	;
	}
}
//-------------------------------------------------------------------------------------------------------------------------
void BitmapSkin::Affiche( int debx, int deltax, int x, int y )
{
	int dep=0						;
	int depS=y*DIBRender::GetXSize()	;

	for( int a=0; a<dy; a++,depS+=DIBRender::GetXSize(),debx+=dx )
		for( int b=0,dep=0; b<deltax; b++,dep++ )
			DIBRender::BackGen[ depS+b+x ] = Bit[debx+dep]	;
}
//-------------------------------------------------------------------------------------------------------------------------





//-------------------------------------------------------------------------------------------------------------------------
//									+-------------------+
//									| Class BoutonSkin  |
//									+-------------------+
//-------------------------------------------------------------------------------------------------------------------------
BoutonSkin::BoutonSkin( int id, int xp, int yp, int clmsk, BitmapSkin *b )
{
	ID = id				;
	xpos = xp			;
	ypos = yp			;
	colormask = clmsk	;
	HighLight = b		;
	Etat	= FALSE		;
}
//-------------------------------------------------------------------------------------------------------------------------
void BoutonSkin::Affiche()
{
	if( Etat )
		HighLight->Affiche( xpos, ypos )	;
}
//-------------------------------------------------------------------------------------------------------------------------


//-------------------------------------------------------------------------------------------------------------------------
//									+-------------------+
//									| Class SlideSkin   |
//									+-------------------+
//-------------------------------------------------------------------------------------------------------------------------
MultiAff::MultiAff( int id, int xp, int yp )
{
	ID = id		;
	xpos = xp	;
	ypos = yp	;

	All = NULL		;
	Actua = NULL	;

	suiv = NULL	;
}
//-------------------------------------------------------------------------------------------------------------------------
void MultiAff::AddBitmap( BitmapSkin* ptr )
{
	ptr->suivList = All	;
	All = ptr			;
}
//-------------------------------------------------------------------------------------------------------------------------
void MultiAff::SetActuaBitmap( int id )
{
	BitmapSkin* tmp ;

	if( id == -1 ) 
	{
		Actua = NULL	;
		return			;
	}

	tmp = All	;
	while( tmp )
	{
		if( tmp->Cmp(id) )
		{
			Actua= tmp	;
			break		;
		}
		tmp = tmp->suivList	;
	}
}
//-------------------------------------------------------------------------------------------------------------------------
void MultiAff::Affiche()
{
	if( Actua )
		Actua->Affiche( xpos, ypos )	;
}
//-------------------------------------------------------------------------------------------------------------------------
