    				 /*-------------------------------------------------------------+
					  |				         MP3Manager.cpp							|
					  |																|
					  |	sous se nom de class complexe se cache en fait un truc 		|
					  |	 relativement tres simple ( une sur couche a skysound koa )	|
					  |																|
					  | 	U2^PoPsy TeAm 2000										|
					  +-------------------------------------------------------------*/

#include "stdafx.h"


#define BUFFERSIZE	45000	// size du buffer de dcompression du mp3 
#define POLL_TIME	.08		// interval de temps de polling du mp3

//----------------------------------------------------------------------------------------------------------
////////////////////////////////////////////////////////////////////////////////////////////////////////////
//									+-----------------------+
//									|	Class MP3Manager	|
//									+-----------------------+
////////////////////////////////////////////////////////////////////////////////////////////////////////////
//----------------------------------------------------------------------------------------------------------
MP3Manager::MP3Manager()
{
	LastPoll = 0.0	;
	time = 0.0		;
	PollTime = 0.0	;
}
//----------------------------------------------------------------------------------------------------------
BOOL MP3Manager::Load( LPCSTR nom, BOOL stereo )
{
	CByteArray*	array	;
	int			ret		;
	int			flag=0	;

	//------------------ Initialize SkySOUND
	SSND_Init(SSND_INTERNAL)	;

	if( !stereo ) flag = SSND_FORCEMONO	;

	array = U3D3DataManager->GetDataFolder( nom )			;

	if( array )
	{
		ret = SSND_PrepareMPG(	(char*)array->GetData(),
								array->GetSize(),
								SSND_MPEGDEFAULT|flag,
								BUFFERSIZE,
								SSND_FROMMEMORY)	;

		if( ret == SSND_RETURNERROR )
			return FALSE	;
	}
	else
	{
		ret = SSND_PrepareMPG(	(char*)nom,
								0,
								SSND_MPEGDEFAULT|flag,
								BUFFERSIZE,
								SSND_FROMFILE)	;

		if( ret == SSND_RETURNERROR )
			return FALSE	;
	}

	return TRUE	;
}
//----------------------------------------------------------------------------------------------------------
void MP3Manager::Play()
{
	LastPoll = ClockU3D::GetTime()	;
    SSND_PlayMPG()					;
}
//----------------------------------------------------------------------------------------------------------
void MP3Manager::Stop()
{
#ifndef _MASTER
	DebugOutput( " Free MPG !\n" )	;
#endif
    SSND_FreeMPG()	;
#ifndef _MASTER
	DebugOutput( " Uninit MPG !\n" )	;
#endif
    SSND_Uninit()	;
#ifndef _MASTER
	DebugOutput( " Done ! Stop Skysound !\n" )	;
#endif
}
//----------------------------------------------------------------------------------------------------------
void MP3Manager::Poll()
{
	time = ClockU3D::GetTime()	;
	time -= LastPoll			;

	if( time > (POLL_TIME-PollTime) )
	{
		PollTime = 0.0	;

//		LastPoll = ClockU3D::GetTime()	;
		SSND_Poll()						;
//		PollTime = ClockU3D::GetTime()	;
//		PollTime -= LastPoll			;
	}
}
//----------------------------------------------------------------------------------------------------------
