Unit LW2;

Interface

Uses SPX_VGA, SPX_IMG, Crt, Mouse, SPX_FNC, SPX_TXT;

Const
 MaxMap = 200;
 MaxTile = 5;
 MaxTiles = 20;

Type
  MapType = Array[1..MaxMap,1..MaxMap] of Byte;
  Tilelist = Array[1..MaxTiles] of Pointer;
  LandType = Record
    Map : MapType;
  End;
  ButtonType = Record
    X1, Y1, X2, Y2 : Integer;
  End;
  NMEColorType = Record
    P1, P2, S1, S2 : Byte;
  End;

Var
  Buttonpressed, H, V, AX, AY : Integer;
  GamePalette : RGBList;
  Land : ^LandType;
  Tiles : TileList;

Procedure MoveTo(Var X, Y : Integer; Pic : Pointer);
Procedure Put(X, Y : Integer; Tile : Pointer);
Procedure EnterTextXY(X, Y, L : Integer; Var S : String; Out : Boolean );
Procedure DrawMap(AX, AY : Integer);
Procedure RandomLand;
Procedure ShowBigMap(TilesX, TilesY, AX, AY : Integer);

Implementation

Procedure RandomLand;
Var X, Y : Integer;
Begin
 For X := 1 to MaxMap do
  For Y := 1 to MaxMap do
   If (X = 1) or (X = MaxMap) or (Y = 1) or (Y = MaxMap) then Land^.Map[X,Y] := 3
   Else Land^.Map[x,y] := Random(MaxTiles)+1;
End;

Procedure DrawMap(AX, AY : Integer);
Var X, Y : Integer;
Begin
  For X := 1 to MaxMap do
    For Y := 1 to MaxMap do
      Begin
        Pset(AX+X-1,AY+Y-1,Land^.Map[X,Y]);
      End;
End;

Procedure ShowBigMap(TilesX, TilesY, AX, AY : Integer);
Var X, Y : Integer;
Begin
  MouseOff;
  For X := 1 to TilesX do
    For Y := 1 to TilesY do
      Put(X, Y, Tiles[Land^.Map[AX+X,AY+Y]]);
  MouseOn;
End;

Procedure MoveTo(Var X,Y:Integer; Pic : Pointer);
Var CX, CY : Integer;
Begin
  If X > 310 Then X := 310 Else If X < 222 Then X := 222;
  If Y > 114 Then Y := 114 Else If Y < 25 Then Y := 25;
  CX := AX;
  CY := AY;
  While (CX <> X) Or (CY <> Y) do
    Begin
      VSinc;
      MouseOff;
      CopyRect(CX-6,CY-6,CX+5,CY+5,Pages[2]^,Pages[1]^);
      MouseOn;
      If CY < Y Then Inc(CY) Else If CY > Y Then Dec(CY);
      If CX < X Then Inc(CX) Else If CX > X Then Dec(CX);
      If CY < Y Then Inc(CY) Else If CY > Y Then Dec(CY);
      If CX < X Then Inc(CX) Else If CX > X Then Dec(CX);
      MouseOff;
      FtPut(CX-6, CY-6, Pic^, False);
      MouseOn;
    End;
  AX := X;
  AY := Y;
End;

Procedure Put(X, Y : Integer; Tile : Pointer);
Begin
  FtPut((X-1)*MaxTile,(Y-1)*MaxTile,Tile^,False);
End;

Procedure EnterTextXY(X, Y, L : Integer; Var S : String; Out : Boolean );
Var P,U,C : Byte;
    T,R : String;
    CH : Char;
Begin
  P := 0;
  T := '';
  C := 0;
  Repeat
    Repeat
    Until KeyPressed;
    CH := ReadKey;
    If (CH = #8) And (P > 0) Then Begin
      Dec(P);
      R := '';
      For U := 1 to P do
        R := R + T[U];
      If (T[P+1] <> #32) Then
        Begin
          Bar(X, Y, X + (L+2) * 6, Y + 6, 0);
          PutLetter(X, Y, 105, R);
        End;
      T := R;
    End
    Else If (UpCase(CH) in ['A'..'Z','.']) And (P < L) Then Begin
      Inc(P);
      T := T + CH;
    End;
    PutLetter(X, Y, 105, T);
  Until (Ch = #13);
  S := T;
End;
End.
