Procedure SetupMap(F : String);
Var E : Integer;
Begin
  Morf := new(PMyMorph,init(MaxMap,MaxMap,19,12,16,16));
  setpageactive(2);
  geo_cnt := loadgmp(F,Morf^.gpic,Morf^.map);
  Morf^.ts := 4;
End;

Procedure Movemap(Var x, y : integer; Var speed : integer);
begin
  if np[7,2] or np[8,2] or np[9,2] then dec(y,speed) else
   if np[1,2] or np[2,2] or np[3,2] then inc(y,speed);
  if np[7,2] or np[4,2] or np[1,2] then dec(x,speed) else
   if np[9,2] or np[6,2] or np[3,2] then inc(x,speed);
  if ch in ['1'..'9'] then speed := vl(ch);
  ifix(x,0,MaxMap*16);
  ifix(y,0,MaxMap*16);
end;

procedure Animate;
var speed, x, y : integer;
begin
  putletter(21,21,14,'Entering ANIMATE procedure..');
  x := 15;
  y := 15;
  speed := 1;
  setpageactive(2);
  repeat
     cls(0);
     movemap(x, y, speed);
     Morf^.drawmap(x,y);
     putletter(25,20,0,st(x)+','+st(y));
     putletter(24,19,10,st(x)+','+st(y));
     putletter(25,27,0,'Speed = '+st(speed));
     putletter(24,26,10,'Speed = '+st(speed));
     pset(160,100,0);
     pset(161,101,15);
     copyRect(16,16,303,183,pages[2]^,pages[1]^);
  until esc;
end;

{**}

function LevelType.geomap(x,y:integer):integer;
begin
  geomap := map[y,x];
end;

procedure LevelType.nogogeo(x,y:integer);
begin
  fput(x,y,gpic[0],false);
end;

procedure LevelType.placegeo(x,y,geonum:integer);
begin
  if geonum in [1..geo_cnt] then fput(x,y,gpic[geonum-1]^,false);
end;

{**}

Procedure ZINClevtest;
Begin
 setpageactive(1);
 cls(0);
 setpageactive(2);
 cls(0);
 SetupMap('TEST.GMP');
 fsetcolors(pal);
 Animate;
 dispose(morf, done);
End;

