unit mcga256e;
{                                                                           }
{ Unit    -  Tweaked mode 13h MCGA graphics engine                          }
{ Version -  1.0                                                            }
{ Date    -  1/11/93                                                        }
{                                                                           }
{     Copyright (c) 1993 by Chris Woodward.  All rights reserved.           }
{                                                                           }

{**} interface {**}

uses
  CRT;

const
  _CRTParams : Array[0..9] of Word =
    ( $00d06,         { Vertical total                                      }
      $03e07,         { Oferflow (bit 8 of vertical counts)                 }
      $04109,         { Cell height (2 to double-scan)                      }
      $0ea10,         { Vertical sync. start                                }
      $0ac11,         { Vertical syn. end and protect cr0-cr7               }
      $0df12,         { Vertical displayed                                  }
      $00014,         { Turn off dword mode                                 }
      $0e715,         { Vertical blank start                                }
      $00616,         { Vertical blank end                                  }
      $0e317 );       { Turn on byte mode                                   }
  _CRTSize : Word = SizeOf( _CRTParams ) DIV 2;

var
  _ActiveOfs : Word;
  _VisualOfs : Word;

procedure _InitGraph;
procedure _CloseGraph;
procedure _ClearScreen( c : Byte );
procedure _SetVisual( p : Byte );
procedure _SetActive( p : Byte );
procedure _SetAddress( a : Word );
procedure _SetPixel( x, y : Word; c : Byte );
function _ReadPixel( x, y : Word ) : Byte;
procedure _DrawScreen(var thescreen);
procedure _TweakScrollLeft(height:word); {scrolls by 4}
Procedure _TweakLine (X1,Y1,X2,Y2:Integer;Color:Byte);
{**} implementation {**}

procedure _InitGraph;
assembler;
asm
  mov ax, 13h
  int 10h
  mov dx, 03c4h
  mov ax, 0604h
  out dx, ax
  mov ax, 0100h
  out dx, ax
  mov dx, 03c2h
  mov al, 0e3h
  out dx, al
  mov dx, 03c4h
  mov ax, 0300h
  out dx, ax
  mov dx, 03d4h
  mov al, 11h
  out dx, al
  inc dx
  in  al, dx
  and al, 7fh
  out dx, al
  dec dx
  cld
  mov ax, seg _CRTParams
  mov ds, ax
  mov si, offset _CRTParams
  mov cx, 0ah
  @SetCRTParams:
    lodsw
    out dx, ax
  loop @SetCRTParams
  mov dx, 03c4h
  mov ax, 0f02h
  out dx, ax
  mov ax, 0a000h
  mov es, ax
  sub di, di
  mov ax, 0000h
  mov cx, 8000h
  rep stosw
end; { _InitGraph }

procedure _CloseGraph;
assembler;
asm
  mov ax, LastMode
  int 10h
end; { _CloseGraph }

procedure _SetVisual( p : Byte );
assembler;
asm
  mov ax, 50h
  mov bl, p
  mul bl
  mov bx, 0f0h
  mul bx
  inc bx
  mov _VisualOfs, ax
  push ax
  mov dx, 03d4h
  mov al, 0ch
  out dx, ax
  pop ax
  mov cl, 8h
  shl ax, cl
  mov al, 0dh
  out dx, ax
end; { _SetVisual }

procedure _SetActive( p : Byte );
assembler;
asm
  mov ax, 50h
  mul p
  mov bx, 0f0h
  mul bx
  inc bx
  mov _ActiveOfs, ax
end; { _SetActive }

procedure _SetAddress( a : Word );
assembler;
asm
  mov bx, a
  mov dx, 03d4h
  mov al, 0ch
  mov ah, bh
  out dx, ax
  mov al, 0dh
  mov ah, bl
  out dx, ax
end; { _SetAddress }

procedure _ClearScreen( c : Byte );
assembler;
asm
  mov dx, 03c4h
  mov ax, 0f02h
  out dx, ax
  mov ax, 0a000h
  mov es, ax
  mov di, _ActiveOfs
  mov al, c
  mov ah, al
  mov cx, 2580h
  rep stosw
end;

procedure _DrawScreen(var thescreen);
assembler;
label
     _drawloop1,_bigloop;
asm
   push ds
   push si
   mov cl,0
   lds si,thescreen
_bigloop:
  mov dx, 03c4h
  mov ax,0102h
  shl ah,cl
  out dx,ax
  mov ax, 0a000h
  mov es, ax
  mov di, _ActiveOfs
  push cx
  mov cx, 3e80h
_drawloop1:
  mov ah,ds:[si]
  mov es:[di],ah
  inc si
  inc di
  dec cx
  jnz _drawloop1
  pop cx
  inc cl
  cmp cl,4
  jne _bigloop
  pop si
  pop ds

end;

procedure _TweakScrollLeft(height:word); assembler;  {scrolls by 4}
label
     _drawloop;
asm
  push ds
  mov dx, 03c4h
  mov ax, 0f02h
  out dx, ax
  mov ax, 0a000h
  mov es, ax
  mov ds,ax
  mov di, _ActiveOfs
  mov si,di
  inc si
  mov bx,height
_drawloop:
  mov cx, 39
  rep movsw
  movsb
  dec bx
  inc si
  inc di
  jnz _drawloop
  pop ds
end;

procedure _SetPixel( x, y : Word; c : Byte );
Assembler;
asm
  mov ax, 50h
  mul y                 { y*80}
  mov bx, x
  shr bx, 1
  shr bx, 1             { x/4 }
  add bx, ax
  add bx, _ActiveOfs    {active offset+(y*80+x)}
  mov ax, 0a000h
  mov es, ax            {es=$a000}
  mov cx, x
  and cl, 011b          { AND the last two bits of the x coordinate}
  mov ax, 0102h
  shl ah, cl            { ah=01, al=2*last two bits of x coordinate}
  mov dx, 03c4h
  out dx, ax
  mov al, c
  mov es:[bx], al
end; { _SetPixel }

function _ReadPixel( x, y : Word ) : Byte;
assembler;
asm
  mov ax, 50h
  mul y
  mov bx, x
  shr bx, 1
  shr bx, 1
  add bx, ax
  add bx, _ActiveOfs
  mov ax, 0a000h
  mov es, ax
  mov ax, x
  and ah, 3h
  mov al, 4h
  mov dx, 03ceh
  out dx, ax
  mov al, es:[bx]
  sub ah, ah
end; { _ReadPixel }

Procedure _TweakLine(X1,Y1,X2,Y2:Integer;Color:Byte);
var
  X,Y,
  YIncr,
  D,DX,DY,
  AIncr,BIncr :  Integer;
  Ofs         :  Word;
begin
  If X1 > X2 then begin
    D  := X1;
    X1 := X2;
    X2 := D;
    D  := Y1;
    Y1 := Y2;
    Y2 := D;
    end;
  If Y2 > Y1 then YIncr :=  1
             else YIncr := -1;
  DX := X2 - X1;
  DY := Abs (Y2-Y1);
  D := 2 * DY - DX;
  AIncr := 2 * (DY - DX);
  BIncr := 2 * DY;

  X := X1;
  Y := Y1;
  _SetPixel (X,Y,Color);

  For X := X1 + 1 to X2 do begin
    If D >= 0 then begin
      Inc (Y,YIncr);
      Inc (D,AIncr);
      end
    Else Inc (D,BIncr);
    _SetPixel (X,Y,Color);
    end;
end;
begin
  _ActiveOfs := $0000;
  _VisualOfs := $0000;
end.
