Unit Sprites;

Interface
uses MCGA256E;

Type
 TransPtr = Array[0..0] of byte;
 TransType = ^TransPtr;
 ImagePtr = Array[0..0,0..0] of Byte;
 ImageType = ^ImagePtr;
 SpriteRec = Record
  SizeX, SizeY : Byte;
  Image : ImageType;
  X, Y : Word;
  Xvel, Yvel : Shortint;
  Active : Boolean;
 End;
 SpriteInfo = Record
  Trans : TransType;
  Calculate : array[1..3] of boolean;
    {1 - Rotation
     2 - Scale
     3 - Velocity}
 End;
Var SI : SpriteInfo;
    Sprite : array[1..50] of ^SpriteRec;


procedure Scale( Source : ImageType; VAR Dest : ImageType;
                 xSize, ySize, xNew, yNew : Word );

Procedure Rotate(OImage : ImageType; Var NImage : ImageType; Rads : Real; XSize, YSize : Byte);

Procedure Update(Page : Byte);

Implementation

procedure Scale( Source : ImageType; VAR Dest : ImageType;
                 xSize, ySize, xNew, yNew : Word );
var
  x : Word;
  y : Word;
begin
  for y := 0 to (xNew-1) do
    for x := 0 to (yNew-1) do
      Dest^[x,y] := Source^[Round(xSize*x/xNew),Round(ySize*y/yNew)];
end;
  
Procedure Rotate(OImage : ImageType; Var NImage : ImageType; Rads : Real; XSize, YSize : Byte);
Var X, Y, X1, Y1, A, B : Integer;
  Radius, ORads : Real;

Begin
  For X := 1 to XSize do
    For Y := 1 to YSize do
      Begin
        X1 := X - XSize div 2;
        Y1 := YSize div 2 - Y;
        Radius := Sqrt( Sqr(X1) + Sqr(Y1) );
        If X1 > 0 Then
          ORads := ArcTan( Y1 / X1 )
        Else
          If X1 < 0 Then
            ORads := ArcTan( Y1 / X1 ) + Pi
          Else
            ORads := ArcTan( Y1 / 0.0001 );
        ORads := ORads + Rads;
        A := Round( Radius * Cos (ORads) ) + XSize div 2;
        B := -Round( Radius * Sin (ORads) ) + YSize div 2;
        If (A in [1..XSize]) and (B in [1..YSize]) Then
          NImage^[X,Y] := OImage^[A,B]
        Else
          NImage^[X,Y] := 0;
      End;
End;

Function Transparent(B : Byte) : Boolean;
Var C : Byte;
    Temp : Boolean;
Begin
 For C := 1 to Sizeof(SI.Trans^) do
  If B = SI.Trans^[C] then Temp := True;
 Transparent := Temp;
End;

Procedure DrawSprite(XL, YL : Integer; S : SpriteRec);
Var XDraw, YDraw : Byte;
Begin
 With S do begin
   For XDraw := 1 to SizeX do
    For YDraw := 1 to SizeY do
     if Transparent(S.Image^[XDraw, YDraw]) then
     _SetPixel(X, Y, S.Image^[XDraw, YDraw]);
  End;
End;
 
Procedure Update(Page : Byte);
Var C : Byte;
Begin
 C := 1;
 _SetActive(Page);
 _ClearScreen(0);
 While (C <= 50) or (Sprite[C] <> Nil) or (Sprite[C]^.Active = True) do begin
  DrawSprite(Sprite[C]^.X, Sprite[C]^.Y, Sprite[C]^);
  if SI.Calculate[3] then
   Sprite[C]^.X := Sprite[C]^.X + Sprite[C]^.X + Sprite[C]^.XVel;
   Sprite[C]^.Y := Sprite[C]^.Y + Sprite[C]^.Y + Sprite[C]^.YVel;
  End;
  Inc(C);
End;

End.

