;
; *** Listing 10-19 ***
;
; Generates the 8-bit checksum of a 1000-byte array
; by loading both segment and offset from a far
; pointer each time through the loop and without
; using string instructions, as the code generated
; by a typical high-level language compiler would.
;
	jmp	Skip
;
FarSeg	segment	para
ARRAY_LENGTH	equ	1000
ByteArray	db	ARRAY_LENGTH dup (0)
				;this array resides in a
				; far segment
FarSeg	ends
;
FarPtr	dd	ByteArray	;a far pointer to the array
;
Skip:
	call	ZTimerOn
	mov	cx,ARRAY_LENGTH	;# of bytes to checksum
	sub	ah,ah		;zero the checksum counter
ChecksumLoop:
	les	bx,[FarPtr]	;load both segment and
				; offset from the far
				; pointer
	inc	word ptr [FarPtr]
				;advance the offset portion
				; of the far pointer
	add	ah,es:[bx]	;add the next byte to the
				; checksum
	loop	ChecksumLoop
	call	ZTimerOff
