;
; *** Listing 13-17 ***
;
; Copies a zero-terminated string to another string,
; filtering out non-printable characters by means of a
; macro that performs the test.
;
	jmp	Skip
;
SourceString	label	byte
	db	'This is a sample string, consisting of '
X=1
	rept	31
	db	X
X=X+1
	endm
	db	7fh
	db	'both printable and non-printable '
	db	'characters', 0
DestinationString	label	byte
	db	200 dup (?)
;
; Macro that determines whether a character is printable (in
; the range 20h through 7Eh).
;
; Input:
;	AL = character to check
;
; Output:
;	Zero flag set to 1 if character is printable,
;		set to 0 otherwise
;
; Registers altered: none
;
IS_PRINTABLE	macro
	local	IsPrintableDone
	cmp	al,20h
	jb	IsPrintableDone	;not printable
	cmp	al,7eh
	ja	IsPrintableDone	;not printable
	cmp	al,al	;set the Zero flag to 1, since the
			; character is printable
IsPrintableDone:
	endm
;
; Copies a zero-terminated string to another string,
; filtering out non-printable characters.
;
; Input:
;	DS:SI = source string
;	ES:DI = destination string
;
; Output: none
;
; Registers altered: AL, SI, DI
;
; Direction flag cleared
;
; Note: Does not handle strings that are longer than 64K
;	bytes or cross segment boundaries.
;
CopyPrintable:
	cld
CopyPrintableLoop:
	lodsb			;get the next byte to copy
	IS_PRINTABLE		;is it printable?
	jnz	NotPrintable	;nope, don't copy it
	stosb			;put the byte in the
	     			; destination string
	jmp	CopyPrintableLoop ;the character was
				; printable, so it couldn't
				; possibly have been 0. No
				; need to check whether it
				; terminated the string
NotPrintable:
	and	al,al		;was that the
				; terminating zero?
	jnz	CopyPrintableLoop ;no, do next byte
	stosb			;copy the terminating zero
	ret			;done
;
Skip:
	call	ZTimerOn
	mov	di,seg DestinationString
	mov	es,di
	mov	di,offset DestinationString
			;ES:DI points to the destination
	mov	si,offset SourceString
			;DS:SI points to the source
	call	CopyPrintable	;copy the printable
				; characters
	call	ZTimerOff
