;              T         T               T


; Select music player
; 0: none
; 1: The Player 6.1a (P61)
; 2: Future Composer
; 3: TFMX
; 4: AHX
; 5: Octamed SoundStudio
;MUSICPLAYER=	1		;note: is set in the bat file
	

;for different music players (AHX, Octamed type 1, the player, TFMX) choose vblank instead of timer interrupt
; 0 = use cia
; 1 = use vblank
; 2 = use cia timing, but actually update the music in vblank (only useful on ahx and TFMX)
MUSICPLAYERUSEVBLANK=		0


TFMXTEST:			equ		4

;0= 4 channel
;1= 8 channel
OCTAMEDPLAYERTYPE=			0

SHOWMUSICRASTERLINES=		Debug		; waits until $2c before starting the vblank code, and shows colors red=vblank, green=non-vblank

; Compact demo-startup by Blueberry/Loonies
; Example usage source code
; Version 1.3, August 22, 2013
; Public Domain

; Set demo compatibility
; 0: 68000 only, Kickstart 1.3 only, PAL only
; 1: All CPUs, Kickstarts and display modes
; 2: 68010+, Kickstart 3.0+, all display modes
COMPATIBILITY=				1

; Set to 1 to require fast memory
FASTMEM=					0

; Set to 1 to enable pause on right mouse button
; with single-step on left mouse button
RMBPAUSE=					1

; Set to 1 if you use FPU code in your interrupt
FPUINT=						0

; Set to 1 if you use bitplane, copper, blitter or sprites, respectively
BITPLANE=					1
COPPER=						1
BLITTER=					1
SPRITE=						1

; Set to 1 to get address of topaz font data in TopazCharData
TOPAZ=						0

; Set to 1 when writing the object file to enable section hack
SECTIONHACK=				UseMiniPacker


										; Demo startup must be first for section hack to work
	include	DemoStartup.s

BLT_A:				equ		%11110000
BLT_B:				equ		%11001100
BLT_C:				equ		%10101010

					rsreset
Bob_WidthInWords:	rs.w	1
Bob_NumSprites:		equ		Bob_WidthInWords
Bob_Height:			rs.w	1
Bob_Width:			rs.w	1
Bob_Offset:			rs.l	1
Bob_AnchorX:		rs.w	1
Bob_AnchorY:		rs.w	1
Bob_SizeOf:			rs.b	0




************************************
_Precalc:
	; Called as the very first thing, before system shutdown

	WinUAEBreakpoint
	; Example: Set bitplane pointer
	move.l	ChipPtr(pc),a1
	lea.l	Bitplane-Chip(a1),a3
	lea		CopperBplPtr,a2
	moveq	#4-1,d7
.setupBitplanes:
	move.l	a3,d0
	add.w	#40,a3
	move.w	d0,6(a2)
	swap	d0
	move.w	d0,2(a2)
	add.w	#8,a2
	dbra	d7,.setupBitplanes

	lea		CopperSprPtr,a2
	lea		SpriteData,a3
	move.l	a3,a4
	moveq	#8-1,d7
.setupSprites:
	move.l	a3,a5
	add.w	(a4)+,a5
	move.l	a5,d0
	move.w	d0,6(a2)
	swap	d0
	move.w	d0,2(a2)
	add.w	#8,a2
	dbra	d7,.setupSprites

	lea		CopperImageBplPtr,a2
	lea		ImageData,a3
	moveq	#6-1,d7
.setupImageBitplanes:
	move.l	a3,d0
	add.w	#40,a3
	move.w	d0,6(a2)
	swap	d0
	move.w	d0,2(a2)
	add.w	#8,a2
	dbra	d7,.setupImageBitplanes

	rts


************************************
_Exit:
			; Called after system restore

	opt o-	;Hannibal disable optimizations when doing self-modifying code

			; Example: Cache flush test
	move.w	#1000-1,d7
.code:
	move.l	#1,d2
	lea.l	.code+2(pc),a0
	addq.l	#1,(a0)
	CACHEFLUSH
	dbf		d7,.code
			; D2 should be 1000 here

	opt o+	;Hannibal re-enable optimizations after self-modifying code
	moveq.l	#0,d0
	rts




************************************
_Main:
	; Main demo routine, called by the startup.
	; Demo will quit when this routine returns.
	; Example: Set copper address

	lea.l	CopperScene1,a1
	move.l	a1,$dff080

.MainLoop:
	;you could do stuff here. This example does everything in interrupt, though, so not needed
	bra.w	.MainLoop


************************************
_Interrupt:
							; Called by the vblank interrupt.

	move.l	ScenePtr,a0
	jmp		(a0)

ScenePtr:
	dc.l	Scene1

FRAMES_ON_SCENE_1:		equ	150
Scene1:
	lea.l	VBlank(pc),a0
	move.l	(a0),d0
	cmp.w	#FRAMES_ON_SCENE_1,d0
	bne		.exit
	move.l	#Scene2,ScenePtr
	lea.l	CopperScene2,a1
	move.l	a1,$dff080
	bsr		Scene2InitTextPage
.exit:
	rts

Scene2InitTextPage:
							;__reg("a3") const char* GetScrollText(__reg("d4") short pageIndex)
	xref _GetScrollText

	move.w	Scene2TextPage,d4
	jsr		_GetScrollText
	move.l	a3,Scene2Text
	addq.w	#1,Scene2TextPage
	move.w	#100,Scene2EndOfPageWaitFrames
	move.w	#0,Scene2X
	move.w	#0,Scene2Y
							;actually blit the data
	tst.w	$dff002
.waitcop:
	btst	#14,$dff002
	bne		.waitcop
	move.l	#Bitplane+8,$dff054
	move.w	#8,$dff066
	move.l	#$01000000,$dff040
	move.w	#255*4*64+16,$dff058
	rts
Scene2TextPage:
	dc.w	0
Scene2Text:
	dc.l	0
Scene2EndOfPageWaitFrames:
	dc.w	0
Scene2X:
	dc.w	0
Scene2Y:
	dc.w	0


Scene2:
	move.l	Scene2Text,a0
	clr.w	d0
	move.b	(a0)+,d0
	beq		.EndOfPage
	move.l	a0,Scene2Text

	cmp.b	#$a,d0
	bne		.NotNewline
	add.w	#FontHeight,Scene2Y
	clr.w	Scene2X
	rts
.NotNewline:
	lea		FontAsciiRemapTable,a2
							;remap from ascii to an index into the bob table
	move.b	0(a2,d0.w),d0
							;if it is a $ff then character is unknown - assume it is a space
	cmp.b	#$ff,d0
	bne		.NotSpace
	add.w	#FontSpaceWidth,Scene2X
	rts

.NotSpace:
	mulu	#Bob_SizeOf,d0
	lea		FontBobTable,a2
	add.w	d0,a2


							;draw a regular letter
	lea		Bitplane+8,a3
	move.w	Scene2Y,d3
	mulu	#40*4,d3
	add.l	d3,a3

	move.w	Scene2X,d3
	add.w	#FontWidthBetweenChars,Scene2X
	move.w	Bob_Width(a2),d0
	add.w	d0,Scene2X

	move.w	d3,d6
	lsr.w	#4,d3
	add.w	d3,a3
	add.w	d3,a3

	and.l	#$f,d6

	ror.l	#4,d6

	add.l	#$0b000000+(BLT_A|BLT_C)<<16,d6


	lea		FontData,a4		;-2 because due to shifting, the first word is masked out
	add.l	Bob_Offset(a2),a4
	move.w	Bob_Height(a2),d3

	mulu	#4*64,d3
	move.w	Bob_WidthInWords(a2),d4
	add.w	#1,d4
	add.w	d4,d3
	move.w	#40,d5
	sub.w	d4,d5
	sub.w	d4,d5

							;actually blit the data
	tst.w	$dff002
.waitcop:
	btst	#14,$dff002
	bne		.waitcop
	move.l	a4,$dff050
	move.l	a3,$dff048
	move.l	a3,$dff054
	move.w	#-2,$dff064
	move.w	d5,$dff060
	move.w	d5,$dff066
	move.l	d6,$dff040
	move.l	#$ffff0000,$dff044
	move.w	d3,$dff058
	rts
.EndOfPage:
	subq.w	#1,Scene2EndOfPageWaitFrames
	bne		.NoNewPage
	bsr		Scene2InitTextPage
.NoNewPage:
	rts

							;font writer here:
FontSpaceWidth:			equ	$d
FontWidthBetweenChars:	equ	2
FontHeight:				equ	$30
************************************

	
	if MUSICPLAYER=1
usecode=					0
		include	"convertedassets/usecode.blow_ya_nose_now.i"

		include "../dh0/p61con/P6111-Play.i"
P61Module:
		incbin	"convertedassets/p61.blow_ya_nose_now"
		section	datachip,data_c
P61Samples:
		incbin	"convertedassets/smp.blow_ya_nose_now"
		even
	endc

	if MUSICPLAYER=2
		section	datachip,data_c
FCModule:
		incbin	"../dh1/fcmodules/jesper kyd/cytax-ice02-intro-14.fc"
	endc

	if MUSICPLAYER=3
TFMXKhzPlaybackRate: equ	18
		include "../dh0/TFMX/source/rout.tfmx7v_sid_fixed.s"
		if TFMXTEST=0
TFMXSubSong:		equ		0
TFMXmdat:	
			incbin	"../dh1/TFMX/songs/chris huelsbeck1/mdat.turrican intro.tfmx"
			section	datachip,data_c
TFMXsmpl:	
			incbin	"../dh1/TFMX/songs/chris huelsbeck1/smpl.turrican intro.tfmx"
		endc
		if TFMXTEST=1
TFMXSubSong:		equ		0
TFMXmdat:	
			incbin	"../dh1/TFMX/songs/chris huelsbeck1/mdat.turrican 2 level 0-intro.tfmx"
			section	datachip,data_c
TFMXsmpl:	
			incbin	"../dh1/TFMX/songs/chris huelsbeck1/smpl.turrican 2 level 0-intro.tfmx"
		endc

		if TFMXTEST=2
TFMXSubSong:		equ		0
TFMXmdat:	
			incbin	"../dh1/TFMX/songs/chris huelsbeck1/mdat.turrican 3 intro.tfmx"
			section	datachip,data_c
TFMXsmpl:	
			incbin	"../dh1/TFMX/songs/chris huelsbeck1/smpl.turrican 3 intro.tfmx"	
		endc
		if TFMXTEST=3
TFMXSubSong:		equ		0
TFMXmdat:	
			incbin	"../dh1/TFMX/songs/chris huelsbeck1/mdat.r-type.tfmx"
			section	datachip,data_c
TFMXsmpl:	
			incbin	"../dh1/TFMX/songs/chris huelsbeck1/smpl.r-type.tfmx"
		endc
		if TFMXTEST=4
TFMXSubSong:		equ		6
TFMXmdat:	
			incbin	"../dh1/TFMX/songs/chris huelsbeck1/mdat.monkey island 1.tfmx"
			section	datachip,data_c
TFMXsmpl:	
			incbin	"../dh1/TFMX/songs/chris huelsbeck1/smpl.monkey island 1.tfmx"
		endc
	endc




	if MUSICPLAYER=4
		section dude,data_c
AHXModule:
		incbin	"..\dh1\AHXSongs\Pink\Agony End.ahx"
ahxSubSong:			equ		0
	endif

	if MUSICPLAYER=5
		if OCTAMEDPLAYERTYPE=0
			section dude,data_c
OSSModule:	
;			incbin	"..\dh1\OctaMED\Modules\Dr. Awesome\stardance.mmd0"
			incbin	"..\dh1\OctaMED\Modules\Walkman\klisje paa klisje.mmd2"
		else 
OSSModule:	
			incbin	"..\dh1\OctaMED\Modules\djnick\djnick - hands of fate.med"
		endif
	endif
	even

CopperScene2:
	dc.l	$008e2c81,$00902cc1
	dc.l	$00920038,$009400d0
	dc.l	$01004200,$01020000
	dc.l	$01080000+3*40,$010a0000+3*40
	dc.l	$01060000,$010c0011
CopperBplPtr:
	dc.l	$00e00000,$00e20000
	dc.l	$00e40000,$00e60000
	dc.l	$00e80000,$00ea0000
	dc.l	$00ec0000,$00ee0000
CopperSprPtr:
	dc.l	$01200000,$01220000
	dc.l	$01240000,$01260000
	dc.l	$01280000,$012a0000
	dc.l	$012c0000,$012e0000
	dc.l	$01300000,$01320000
	dc.l	$01340000,$01360000
	dc.l	$01380000,$013a0000
	dc.l	$013c0000,$013e0000
	dc.l	$01080000+40*3,$010a0000+40*3
	dc.l	$01fc0000
	include "convertedassets/coolchar_facet.COP_dcw.i"
	include "convertedassets/jade-lemon_16color_sprite.COP_dcw.i"
	include "convertedassets/copperbar_balle.COP_dcw.i"
	dc.l	$ffe1fffe
	include "convertedassets/copperbar_balle_2.COP_dcw.i"
	dc.l	$fffffffe


SpriteData:
	include "convertedassets/jade-lemon_16color_sprite.ASP_dcw.i"
FontAsciiRemapTable:
	include "convertedassets/coolchar_facet.FAR_dcb.i"
FontBobTable:
	include "convertedassets/coolchar_facet.BOB_dcw.i"

FontData:
	incbin "convertedassets/coolchar_facet.BPL"



CopperScene1:
	dc.l	$008e2c81,$00902cc1
	dc.l	$00920038,$009400d0
	dc.l	$01006200,$01020000
	dc.l	$01060000,$010c0011
	dc.l	$01080000+5*40,$010a0000+5*40

CopperImageBplPtr:
	dc.l	$00e00000,$00e20000
	dc.l	$00e40000,$00e60000
	dc.l	$00e80000,$00ea0000
	dc.l	$00ec0000,$00ee0000
	dc.l	$00f00000,$00f20000
	dc.l	$00f40000,$00f60000

CopperImageSprPtr:
	dc.l	$01200000,$01220000
	dc.l	$01240000,$01260000
	dc.l	$01280000,$012a0000
	dc.l	$012c0000,$012e0000
	dc.l	$01300000,$01320000
	dc.l	$01340000,$01360000
	dc.l	$01380000,$013a0000
	dc.l	$013c0000,$013e0000
	include "convertedassets/slashobnoxiousehb.COP_dcw.i"
	dc.l	$fffffffe
ImageData:
	incbin "convertedassets/slashobnoxiousehb.EHB"

	; Pll	ace all chip space in the single chip section.
	; Define no other sections.
	section	bsschip,bss_c
Chip:

	if MUSICPLAYER=3
TFMXChipBuffer:
		ds.l	512
	endif
Bitplane:
	ds.b	40*256*4

	
;Shallow Hash=11911623320158153721924036134223181397349
