@rem start visual studio command prompt
@if not exist "%vs120comntools%..\..\VC\vcvarsall.bat" goto notVS2013
@call "%vs120comntools%..\..\VC\vcvarsall.bat" x86
@goto VSPromptStarted
:notVS2013
@if not exist "%vs110comntools%..\..\VC\vcvarsall.bat" goto notVS2012
@call "%vs110comntools%..\..\VC\vcvarsall.bat" x86
@goto VSPromptStarted
:notVS2012
@echo Visual Studio 2012 or 2013 required
@goto End

:VSPromptStarted

@echo **** Building VBCC ****
@cd /d "%~dp0"
@cd vbcc
@if not exist obj_win32 md obj_win32
@del obj_win32\*.* /s /q >NUL
@if not exist bin md bin 
@del bin\*.* /s /q >NUL

@nmake /f makefile.win32 bin\vprof
@if errorlevel 1 goto error
@copy bin\vprof.exe ..\..\bin\
@if errorlevel 1 goto error

@nmake /f makefile.win32 bin\vc
@if errorlevel 1 goto error
@copy bin\vc.exe ..\..\bin\
@if errorlevel 1 goto error


@echo *** BUILD INSTRUCTIONS ***
@echo *** VBCC compile process will ask you some questions
@echo *** press enter 18 times, 
@echo *** then answer y(enter) signed __int64(enter)
@echo *** then answer (enter) y(enter) unsigned __int64(enter)
@echo *** then press enter 6 more times, and it should build

@nmake /f makefile.win32 bin\vbccm68k TARGET=m68k
@if errorlevel 1 goto error
@copy bin\vbccm68k.exe ..\..\bin\
@if errorlevel 1 goto error


@echo **** Building VAsm ****
@cd /d "%~dp0"
@cd vasm
@if not exist obj_win32 md obj_win32
@del obj_win32\*.* /s /q >NUL

nmake /f makefile.win32 CPU=m68k SYNTAX=mot
@if errorlevel 1 goto error
copy vasmm68k_mot_win32.exe ..\..\bin\
@if errorlevel 1 goto error
copy vobjdump_win32.exe ..\..\bin\
@if errorlevel 1 goto error


@echo **** Building VLink ****
@cd /d "%~dp0"
@cd vlink
@if not exist objects md objects
@del objects\*.* /s /q >NUL
nmake /f makefile.win32
@if errorlevel 1 goto error
copy vlink.exe ..\..\bin\
@if errorlevel 1 goto error



@echo SUCCESS
@goto end

:error
@echo FAILED
:end
@cd /d "%~dp0"
