/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

#ifndef CAOSGL_CORE_COPENGLWINDOW
#define CAOSGL_CORE_COPENGLWINDOW

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
#include <caosGL/core/cAbsWindow.h>
#include <caosGL/core/cArea.h>

// extern includes
#include <caosGL/core/Dyngl.h>

namespace caosGL { 
	namespace core {
		/**
		 *<br> class:		cOpenGLWindow
		 *<br> namespace:	caosGL::core
		 *<br> inherits:	caosGL::core::cAbsWindow
		 *<br> implements:	<none>
		 *<br> purpose:		Creates a window, somewhere where things can be
		 *              drawn.
		 *
		 */

		class CAOSGL_API cOpenGLWindow : public cAbsWindow {
		public:
			virtual ~cOpenGLWindow ();
			
			virtual const tBool open (tInt w, tInt h, WNDPROC wProc, tBool fs = false);
			virtual const tBool close ();
			
			virtual tVoid update ();
			virtual tVoid clear (const tBool depth = true);
			virtual tVoid clear (const tInt color, const tBool depth = true);

			virtual cArea & clip ();
			virtual tVoid clip (const cArea & clip);

			virtual tInt width () const;
			virtual tInt height () const;

			void getInfo ();

			// instance managment.
			public:
				static cAbsWindow * instance ();

			private:
				cOpenGLWindow ();
				static cAbsWindow * makeInstance ();
				static cAbsWindow * _instance;

		private:
			tBool createGLWindow(tChar* str, tInt width, tInt height, tBool fullscreen, WNDPROC wProc);
			tInt initGL(GLvoid);
			tVoid reSizeGLScene(GLsizei width, GLsizei height);

			tBool _opened;
			tBool _fullScreen;
			tInt _width;
			tInt _height;
			cArea _clip;
			cArea srcClip;
			cArea dstClip;
		};
	}
}

#endif // CAOSGL_CORE_COPENGLWINDOW

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof