/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
#include <caosGL/core/cBassSndNode.h>
#include <caosGL/core/DynBass.h>

// extern includes
//#include <some.h>

#include <caosGL/core/cBassSndPlayer.h>

static log4cpp::Category& cat = log4cpp::Category::getInstance ("caosGL::core::cBassSndPlayer");

namespace caosGL {
	namespace core {
		/**
		 *<br> class:		cBassSndPlayer
		 *<br> namespace:	caosGL::gfx
		 *<br> inherits:	<none>
		 *<br> implements:	<none>
		 *<br> purpose:		
		 *
		 */

		vector <cSndNode*> nodes;
		
		/********************************************************************************************/
		cBassSndPlayer::~cBassSndPlayer () { 
		}

		/********************************************************************************************/
		cBassSndPlayer::cBassSndPlayer () {
			init = loadBass () == 1;
			if (!init) {
				cat.error ("Could not load bass.dll, it's possible that it could not be found.");
				MessageBox(0,"Bass could not be loaded, do you have it?","Bass.dll",MB_OK|MB_ICONSTOP);
				return;
			}
			hWnd = GetForegroundWindow ();
			if (!BASS_Init (-1, 44100, 0, hWnd)) {
				cat.error ("Couldn't initialize the hardware how i wanted it, use the no sound device");
				// couldn't initialize device, so use no sound
				BASS_Init (-2, 44100, 0, hWnd);
			}
			BASS_Start ();
		} 

		/********************************************************************************************/
		cSndNode * cBassSndPlayer::makeSndNode (const string name, caosGL::gfx::cGroup * f) {
			if (!init) return cNULL;
			cBassSndNode * sn = new cBassSndNode (name,f);
			nodes.push_back (sn);
			return sn;
		}

	}
}

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof