/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
#include <caosGL/gfx/cScene.h>

// extern includes
#include <algorithm>
#include <caosGL/core/cUtil.h>
#include <caosGL/core/cParser.h>
#include <caosGL/core/cRegistry.h>

#include <caosGL/core/cEvent.h>

using namespace caosGL::core;

namespace caosGL {
	namespace core {
		/**
		 *<br> class:		cEvent
		 *<br> namespace:	caosGL::gfx
		 *<br> inherits:	caosGL::gfx::cBaseNode
		 *<br> implements:	<none>
		 *<br> purpose:		
		 *
		 */

		static vector <tAttr> attributeNames;
	    static log4cpp::Category& cat = log4cpp::Category::getInstance ("sys.cEvent");

		tBool predEvent (event * e0, event * e1) { return e0->time < e1->time; }

		/********************************************************************************************/
		cEvent::cEvent (const string n, cGroup * f) : cBaseNode (n,f) {
			init ();
		}

		/********************************************************************************************/
		cEvent::~cEvent () {
		}

		/********************************************************************************************/
		tVoid cEvent::addEvent (const string who, tDWord name, const string value, tFloat t) {
			event * e = new event (who, name, value, t);
			eventList.push_back (e);
		}

		/********************************************************************************************/
		tVoid cEvent::close () {
			if (_closed) return;
			sort (eventList.begin (),eventList.end (),predEvent);
			it = eventList.begin ();
			_closed = true;
			for (vector <event*>::iterator i = eventList.begin (); i != eventList.end (); i++ ){
				cat.debug ("Got the event for %s.%s = %s @ %f", (*i)->who.c_str(), cUtil::doFli ((*i)->name).c_str () ,(*i)->value.c_str(),(*i)->time);
			}
		}

		// from cBaseNode
		/********************************************************************************************/
		tBool cEvent::compile () {
			close ();
			return true;
		}

		// from cBaseNode
		/********************************************************************************************/
		tBool cEvent::visit (tFloat t) {
//			cat.debug ("visit @ %f", t);
			tBool ret = true;
			if (it == eventList.end ())
				return false;
			event * e = *it;
//			cat.debug ("Got the event for %s.%s = %s @ %f", e->who.c_str(),e->name.charData(),e->value.c_str(),e->time);
			while (e->time < t) {
				cBaseNode * bn = cRegistry::getNode (e->who);
				if (!bn) {
					it++;
					return false;
				}
				cat.debug ("Firing event for %s, key:%s value:%s %f", bn->name ().c_str (), cUtil::doFli (e->name).c_str(), e->value.c_str (), e->time);
				bn->set (e->name, e->value);
				it++;
				if (it == eventList.end ())
					return false;
				ret = true;
				e = *it;
			}
			
			return ret;
		}

		// from cBaseNode
		/********************************************************************************************/
		tVoid cEvent::leave () {
			return;
		}

		// from cBaseNode
		/********************************************************************************************/
		tBool cEvent::init () {
			_closed = false;
			return true;
		}

		// from cBaseNode
		/********************************************************************************************/
		const tBool cEvent::set (const tDWord key, const string & value) {
			return false;
		}

		// from cBaseNode
		/********************************************************************************************/
		const tBool cEvent::set (const tDWord key, const tFloat & value) {
			return false;
		}

		// from cBaseNode
		/********************************************************************************************/
		const tBool cEvent::get (const tDWord key, string & value) const {
			return false;
		}

		// from cBaseNode
		/********************************************************************************************/
		const vector <tAttr> * cEvent::getAttributeNames () const {
			return &attributeNames;
		}

		// from cBaseNode
		/********************************************************************************************/
		const string cEvent::getTypeName () const { return "caosGL::core::cEvent"; }
	}
}

// for node creation
#include <caosGL/core/cRegistry.h>
#include <caosGL/gfx/cNodeCreator.h>

class cEventNodeCreator : public cNodeCreator {
public:
	cEventNodeCreator () {
		name ("caosGL::core::cEvent");
	}
	cBaseNode * createNode (const string n, cGroup * f) {
		return new caosGL::core::cEvent (n,f);
	}
};
caosGL::core::cRegisterNodeCreator <cEventNodeCreator> cEventNodeCreatorInstance;

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof