/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes

// extern includes
#include <caosGL/gfx/cNodeCreator.h>
#include <caosGL/gfx/cAnimCurve.h>
#include <map>
#include <caosGL/core/cUtil.h>

#include <caosGL/core/cRegistry.h>

using namespace caosGL::gfx;

namespace caosGL {
	namespace core {
		/**
		 *<br> class:		cRegistry
		 *<br> namespace:	caosGL::core
		 *<br> inherits:	<none>
		 *<br> implements:	<none>
		 *<br> purpose:		The registry stores the objects, handles creation, and retrieves the node
		 *
		 */

	    static log4cpp::Category& cat = log4cpp::Category::getInstance ("sys.cRegistry");
		static map <string, cNodeCreator *> * creators;
		static map <string, cBaseNode *> * createdNodes;
		static map <string, cEvaluatable *> * evaluatables;
		cRegistry * cRegistry::_instance = cNULL;
		/********************************************************************************************/
		cRegistry::cRegistry () {
			creators = new map <string, cNodeCreator *>;
			createdNodes = new map <string, cBaseNode *>;
			evaluatables = cNULL;
		}

		/********************************************************************************************/
		cRegistry::~cRegistry () {
			delete creators;
		}

		/********************************************************************************************/
		cRegistry * cRegistry::instance () {
			if (_instance == cNULL) {
				_instance = makeInstance ();
			}
			return _instance;
		}

		/********************************************************************************************/
		cRegistry * cRegistry::makeInstance () {
			return new cRegistry ();
		}
		
		/********************************************************************************************/
		tVoid cRegistry::registerNodeCreator (caosGL::gfx::cNodeCreator * createNode) {
			instance ();
			// can't put this here because the thing breaks!!
			// cat.info ("Registring type %s to the registry.", createNode->name ().c_str ());
			// printf ("node creator: %s\n", createNode->name ().c_str());
			creators->insert (map <string, cNodeCreator *>::value_type (createNode->name (), createNode));
		}

		/********************************************************************************************/
		cBaseNode * cRegistry::createNode (const string type, const string name, cGroup * f) {
			map <string, cNodeCreator *>::const_iterator it = creators->find (type);
			if (it != creators->end ()) {
				cNodeCreator * nc = it->second;
				cBaseNode * bn = nc->createNode (name, f);
				addNodeToPool (bn);
				return bn;
			} else {
				cat.error ("Could not create node of type %s and name %s.", type.c_str (), name.c_str ());
				return cNULL;
			}
		}

		/********************************************************************************************/
		cBaseNode * cRegistry::getNode (const string name) {
			map <string, cBaseNode *>::const_iterator it = createdNodes->find (name);
			if (it != createdNodes->end ()) {
				return it->second;
			}
			return cNULL;
		}

		/********************************************************************************************/
		tVoid cRegistry::addNodeToPool (cBaseNode * bn) {
			map <string, cBaseNode *>::const_iterator it = createdNodes->find (bn->name ());
			if (it != createdNodes->end ()) {
				cat.warn ("Duplicate name in node pool!! (%s)", bn->name ().c_str ());
			}
			createdNodes->insert (map <string, cBaseNode *>::value_type (bn->name (), bn));
		}

		/********************************************************************************************/
		tVoid cRegistry::addEvaluatables (map <string, cEvaluatable*> * ac) {
/**//*		{for (map <string, cEvaluatable *>::iterator it = ac->begin (); it != ac->end (); it++) {
				cat.info ("Anim curve %s:%s", it->second->name ().c_str (), it->second->toString ().c_str());
			}}*/

			for (map <string, cEvaluatable *>::iterator it = ac->begin (); it != ac->end (); it++) {
				cEvaluatable * ac = it->second;
				string name; ac->get('obj', name);
				cBaseNode * bn = getNode (name);
				if (!bn) {
					cat.error ("Object that the evaluatable (%s) pointed to (%s) doesn't exist!",
						ac->name ().c_str (), name.c_str());
					continue;
				}
				bn->addEvaluatable (ac);
			}
			if (evaluatables) {
				for (map <string, cEvaluatable *>::iterator it = ac->begin (); it != ac->end (); it++) {
					evaluatables->insert (*it);
				}
				delete ac;
			} else {
				evaluatables = ac;
			}
		}

		/********************************************************************************************/
		cEvaluatable * cRegistry::getEvaluatable (const string name) {
			map <string, cEvaluatable *>::const_iterator it = evaluatables->find (name);
			if (it != evaluatables->end ()) {
				return it->second;
			}
			return cNULL;
		}

		/********************************************************************************************/
		const string cRegistry::toString () {
			string ret;
			ret.append ("[");
			for (map <string, cNodeCreator *>::iterator it = creators->begin (); it != creators->end () ; it++) {
				ret.append ("key: #");
				ret.append (it->first);
				ret.append ("# value: #");
				ret.append (it->second->name ());
				ret.append ("#; ");
			}
			ret.append ("]");
			return ret;
		}

		/********************************************************************************************/
		tVoid cRegistry::printAll () {
			for (map <string, cNodeCreator *>::const_iterator it0 = creators->begin(); it0 != creators->end () ; it0++) {
				cNodeCreator * nc = it0->second;
				cBaseNode * bn = nc->createNode ("test", cNULL);
				const vector <tAttr> * attr = bn->getAttributeNames ();
				for (vector <tAttr>::const_iterator it1 = attr->begin(); it1 != attr->end(); it1++) {
					string name; bn->get (it1->first, name);
					cat.info ("%s::%s::%s::%s", bn->getTypeName().c_str(), cUtil::doFli (it1->first).c_str(), it1->second, name.c_str());
				}
				delete bn;
			}
		}
	}
}

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof