/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes

// extern includes
#include <map>
#include <caosGL/core/tinyxml.h>
#include <caosGL/core/cVFS.h>

#include <caosGL/core/cSystem.h>


namespace caosGL {
	namespace core {
		/**
		 *<br> class:		cSystem
		 *<br> namespace:	caosGL::core
		 *<br> inherits:	<none>
		 *<br> implements:	<none>
		 *<br> purpose:		the system class, stores properties, and stuff..
		 *
		 */

		static map <string, string> properties;
	    static log4cpp::Category& cat = log4cpp::Category::getInstance ("sys");

		cSystem * cSystem::_instance = cNULL;
		/********************************************************************************************/
		cSystem::cSystem () { init (); } 
		/********************************************************************************************/
		cSystem::~cSystem () {} 

		/********************************************************************************************/
		tBool cSystem::init () {

			istream * is = cVFS::getStreamHard ("caosGL.xml");
			if (is->good ()) {
			} else {
				cat.emerg ("Could not load the caosGL.xml file, bad, bad, bad...");
				delete is;
				return false;
			}

			is->seekg (0,ios_base::end);
			long length = is->tellg ();
			is->seekg (0);

			tChar * buf = new tChar [length];
			is->read ((tChar*)buf, length);

			TiXmlDocument doc;
			doc.Parse (buf);
			TiXmlElement * caosGL = doc.FirstChildElement ("caosGL");

			for (TiXmlNode * key = caosGL->FirstChildElement (); key; key = key->NextSiblingElement ()) {
				TiXmlNode * value = key->FirstChild ();
				cat.debug ("%s : %s", key->Value ().c_str (), value->Value ().c_str ());
				properties.insert (map <string, string>::value_type (key->Value (), value->Value ()));
			}

			delete is;

			return true;
		}

		/********************************************************************************************/
		cSystem * cSystem::instance () {
			if (_instance == cNULL) {
				_instance = makeInstance ();
			}
			return _instance;
		}

		/********************************************************************************************/
		cSystem * cSystem::makeInstance () {
			return new cSystem ();
		}

		/********************************************************************************************/
		const string cSystem::get (const string name) {
			map <string, string>::const_iterator it = properties.find (name);
			if (it != properties.end ())
				return it->second;
			return "null";
		}

		/********************************************************************************************/
		const string cSystem::toString () {
			string ret;
			ret.append ("[");
			for (map <string, string>::iterator it = properties.begin (); it != properties.end () ; it++) {
				ret.append ("key: #");
				ret.append (it->first);
				ret.append ("# value: #");
				ret.append (it->second);
				ret.append ("#; ");
			}
			ret.append ("]");
			return ret;
		}
	}
}

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof