/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
#include <caosGL/gfx/cScene.h>

// extern includes
#include <caosGL/core/cUtil.h>
#include <caosGL/core/cRegistry.h>
#include <caosGL/core/math.h>

#include <caosGL/gfx/cGroup.h>

using namespace caosGL::core;

namespace caosGL {
	namespace gfx {
		/**
		 *<br> class:		cGroup
		 *<br> namespace:	caosGL::gfx
		 *<br> inherits:	caosGL::gfx::cBaseNode
		 *<br> implements:	<none>
		 *<br> purpose:		The base node for grouping other objects. Two main clases extend this one
		 *					cTransform and cLayer.
		 *
		 */

		static vector <tAttr> attributeNames;
		static log4cpp::Category& cat = log4cpp::Category::getInstance ("caosGL::gfx::cGroup");
		/********************************************************************************************/
		cGroup::cGroup (const string & n, cGroup * f) : super (n,f) {
			init ();
		}

		/********************************************************************************************/
		cGroup::~cGroup () {
			for (tNodeList::const_iterator it = _nodeList.begin (); it != _nodeList.end (); it++) {
				delete (*it);
			}
		}

		/********************************************************************************************/
		tBool cGroup::addNode (cBaseNode * node) {
			if (!node) {
				cat.debug ("Cowardly refusing to add a null node!");
				return false;
			}
			_nodeList.push_back (node);
			return true;
		}

		/********************************************************************************************/
		tBool cGroup::removeNode (const string & nodeName) {
			cBaseNode * bn = cRegistry::getNode (nodeName);
			for (tNodeList::iterator it = _nodeList.begin (); it != _nodeList.end (); it++) {
				if (bn == (*it)) {
					it = _nodeList.erase (it);
					return true;
				}
			}
			return false;//_nodeList.erase (nodeName) == 1;
		}
		
		/********************************************************************************************/
		const cBaseNode * cGroup::getNode (const string & nodeName) const {
			cBaseNode * bn = cRegistry::getNode (nodeName);
			for (tNodeList::const_iterator it = _nodeList.begin (); it != _nodeList.end (); it++) {
				if (bn == (*it))
					return bn;
			}
			return cNULL;
		}

		/********************************************************************************************/
		const tNodeList * cGroup::getNodes () const {
			return &_nodeList;
		}

		/********************************************************************************************/
		tVoid cGroup::clear () {
			_nodeList.clear ();
		}

		/********************************************************************************************/
		tVoid cGroup::printTree () const {
			cat.debug ("____Printing tree %s::%s________________________", getTypeName().c_str(), _name.c_str());
			printTree (getNodes (), 0);
		}

		/********************************************************************************************/
		tVoid cGroup::printTree (const tNodeList * nodeList, const tInt tabCount) const {
			for (tNodeList::const_iterator it = nodeList->begin (); it != nodeList->end (); it++) {
				cBaseNode * bn = (*it);
				cat.debug ("%s%s; %s", cUtil::tabs (tabCount).c_str(), bn->getTypeName().c_str(), bn->name().c_str());
				cGroup * gr = dynamic_cast <cGroup *> (bn);
				if (gr) {
					printTree (gr->getNodes(), tabCount+1);
				}
			}
		}

		// from cBaseNode
		/********************************************************************************************/
		tBool cGroup::compile () {
			_strt = HUGE_VAL;
			_end = -HUGE_VAL;
			for (tNodeList::const_iterator it = _nodeList.begin (); it != _nodeList.end (); it++) {
				cBaseNode * bn = (*it);
				
				if (_strt > bn->start ()) 
					_strt = bn->start ();
				if (_end < bn->end ())
					_end = bn->end ();
			}
			return true;
		}

		// from cBaseNode
		/********************************************************************************************/
		tBool cGroup::init () {
			#define ATTRIB(n,t,v,d) ATTRIB_INIT_VAR(n,v)
			#include cGroup_attribsFile
			#undef ATTRIB
			return true;
		}

		// from cBaseNode
		/********************************************************************************************/
		const tBool cGroup::set (const tDWord key, const string & value) {
			if (super::set (key, value)) return true;
			switch (key) {
				#define ATTRIB(n,t,v,d) ATTRIB_SET_S(n)
				#include cGroup_attribsFile
				#undef ATTRIB
			case '    ': return false;
			default: return false;
			}
			return false;
		}

		// from cBaseNode
		/********************************************************************************************/
		const tBool cGroup::set (const tDWord key, const tFloat & value) {
			if (super::set (key, value)) return true;
			switch (key) {
				#define ATTRIB(n,t,v,d) ATTRIB_SET_N(n)
				#include cGroup_attribsFile
				#undef ATTRIB
			case '    ': return false;
			default: return false;
			}
			return false;
		}

		// from cBaseNode
		/********************************************************************************************/
		const tBool cGroup::get (const tDWord key, string & value) const {
			if (super::get (key, value)) return true;
			switch (key) {
				#define ATTRIB(n,t,v,d) ATTRIB_GET(n)
				#include cGroup_attribsFile
				#undef ATTRIB
			case '    ': return false;
			default: return false;
			}
			return false;
		}

		// from cBaseNode
		/********************************************************************************************/
		const vector <tAttr> * cGroup::getAttributeNames () const {
			if (attributeNames.size () == 0) {
				const vector <tAttr> * v = super::getAttributeNames ();
				attributeNames.insert (attributeNames.begin (), v->begin (), v->end ());
				#define ATTRIB(n,t,v,d) ATTRIB_ATTRIBNAMES(n,d)
				#include cGroup_attribsFile
				#undef ATTRIB
			}
			return &attributeNames;
		}
	}
}

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof