/* For license details see bottom.
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes
#include <caosGL/gfx/cScene.h>

// extern includes
#include <caosGL/core/cGLTexture.h>
#include <caosGL/core/cGLTextureSpace.h>
#include <caosGL/core/cRegistry.h>
#include <caosGL/core/math.h>
#include <caosGL/gfx/cSurfaceProvider.h>

#include <caosGL/gfx/cTextureSpace.h>
using namespace caosGL::core;
using namespace caosGL::core;

namespace caosGL {
	namespace gfx {
		/**
		 *<br> class:		cTextureSpace
		 *<br> namespace:	caosGL::gfx
		 *<br> inherits:	<none>
		 *<br> implements:	<none>
		 *<br> purpose:		A common repository of textures.
		 *
		 */

		static log4cpp::Category& cat = log4cpp::Category::getInstance ("caosGL::gfx::cTextureSpace");
		cTextureSpace * cTextureSpace::_instance = cNULL;
		vector <cGLTexture *> cTextureSpace::surfaces;
		/********************************************************************************************/
		cTextureSpace::cTextureSpace () {
		}

		/********************************************************************************************/
		cTextureSpace::~cTextureSpace () {
			
		}

		/********************************************************************************************/
		cTextureSpace * cTextureSpace::instance () {
			if (_instance == cNULL) {
				_instance = makeInstance ();
			}
			return _instance;
		}

		/********************************************************************************************/
		cTextureSpace * cTextureSpace::makeInstance () {
			return new cTextureSpace ();
		}

		/********************************************************************************************/
		cGLTexture * cTextureSpace::get (const string & names) {
			cGLTexture * tx = cGLTextureSpace::instance ()->get (names);
			if (!tx) {
				cat.debug ("\"%s\" not in cGLTextureSpace, getting from file", names.c_str());
				tx = cSurfaceProvider::instance()->getSurface (names);
				if (!tx) {
					cat.debug ("Ok, not in cSurfaceProvider either, creating an empty one");
					cGLTexture::eGLTextureType type = cGLTexture::eGLTextureType_Mipmap;
					tInt pos = names.find (';');
					if (pos != string::npos) {
						// got type parameter
						cat.info ("Got filter type: %c", names[0]);
						switch (names[0]) {
						case 'n': type = cGLTexture::eGLTextureType_Nearest; break;
						case 'l': type = cGLTexture::eGLTextureType_Linear;  break;
						case 'm': type = cGLTexture::eGLTextureType_Mipmap;  break;

						}
					}

					tx = new cGLTexture (names, type);
					cGLTextureSpace::instance ()->put (names, tx);
				} else {
					cGLTextureSpace::instance ()->put (names, tx);
				}
			} else {
				cat.debug ("Got it [%s]", names.c_str());
			}
			return tx;
		}

		/********************************************************************************************/
		tBool cTextureSpace::put (const string & name, cGLTexture * tex) {
			return cGLTextureSpace::instance ()->put (name, tex);
		}			
	}
}

/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by 
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */
// eof