/**
 * The Catalyst of Design Software License, Version 1.0
 *
 * Copyright (c) 2002 Catalyst of Design (David Morris-Oliveros).  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by
 *        Catalyst of Design (http://talsit.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "caosGL" and "Catalyst of Design" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact caosGL@talsit.org.
 *
 * 5. Products derived from this software may not be called "caosGL",
 *    nor may "caosGL" appear in their name, without prior written
 *    permission of Catalyst of Design.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CATALYST OF DESIGN OR ITS
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 */

/**
 *<br> class:		<none>
 *<br> namespace:	<none>
 *<br> inherits:	<none>
 *<br> implements:	<none>
 *<br> purpose:		The entry point to the caosGLoader. Creates the necesarry
 *              caosGL objects, initializes them, and starts an event
 *              loop, waiting for an escape event.
 *
 */

// system includes
#include <caosGL/core/globals.h>
#include <caosGL/core/types.h>

// package includes

// extern includes
#include <windows.h>
#include <math.h>

#include <caosGL/gfx/cSurfaceProvider.h>
#include <caosGL/gfx/cScene.h>
#include <caosGL/gfx/cTime.h>
#include <caosGL/gfx/cSceneGraph.h>
#include <caosGL/core/cEngine.h>
#include <caosGL/core/cParser.h>
#include <caosGL/core/cSystem.h>
#include <caosGL/core/cTimer.h>
#include <caosGL/core/cOpenGLWindow.h>
#include <caosGL/core/cSurface.h>
#include <caosGL/core/cRegistry.h>
#include <caosGL/core/cSndNode.h>
#include <windows.h>
#include <math.h>

using namespace caosGL::gfx;
using namespace caosGL::core;

cSndNode * muzik = cNULL;
static tBool paused = false;
static tInt xPos = 0;
static tDouble myTime = 0;


LRESULT CALLBACK wndProc (	HWND	hWnd,
							UINT	uMsg,
							WPARAM	wParam,
							LPARAM	lParam)
{
	switch (uMsg) {
	case WM_CLOSE:
		PostQuitMessage (0);
		return 0;
	case WM_CHAR:
		switch (wParam) {
		case 27:
			PostQuitMessage (0);
			return 0;
		case 'p':
			if (!paused) {
				cTime::stop ();
				if (muzik)
					muzik->pause();
				paused = true;
			} else {
				cTime::resume ();
				if (muzik)
					muzik->play();
				paused = false;
			}
			return 0;
		}
		break;
	case WM_KEYDOWN:
		switch (wParam) {
		case VK_LEFT:
			if (paused) {
				cTime::set (cTime::elapsed () - 0.03);
				if (muzik) {
					muzik->pos (cTime::elapsed ());
				}
			}
			return 0;
		case VK_RIGHT:
			if (paused) {
				cTime::set (cTime::elapsed () + 0.03);
				if (muzik) {
					muzik->pos (cTime::elapsed ());
				}
			}
			return 0;
		}
		break;
	case WM_LBUTTONDOWN:
		xPos = LOWORD(lParam);
		myTime = cTime::elapsed ();
		break;
	case WM_MOUSEMOVE:
		if (paused) {
			if (wParam&MK_LBUTTON) {
				cTime::set (myTime + 0.01*(LOWORD(lParam)-xPos));
				if (muzik) {
					muzik->pos (cTime::elapsed ());
				}
			}
		}
		break;
	}
	return DefWindowProc(hWnd,uMsg,wParam,lParam);
}


int APIENTRY
	WinMain(HINSTANCE hInstance,
	        HINSTANCE hPrevInstance,
			LPSTR lpCmdLine,
			int nCmdShow) {

	cAbsWindow * window = cOpenGLWindow::instance ();
	cSystem * sys = cSystem::instance ();

	if (!window->open (cParser::parseInt (sys->get("width")),
			cParser::parseInt (sys->get("height")), 
			wndProc, cParser::parseBool (sys->get("fullscreen")))) {
		MessageBox(NULL,"Couldn't set the video mode or open a window!","caosGLoader",MB_OK);
	}

	tBool pedantic = cParser::parseBool (sys->get ("pedantic"));
	// if in pedantic, allow a delay for the resolution to change.
	if (pedantic)
		Sleep (1500);

	string loadImgStr = pedantic?sys->get ("loadImg"):"null";
	cScene * clrScr, * loadImg;
	cSndNode * loadMuz = cNULL;

	// If we have an image (and are in pedantic mode), put on some cool things so the user
	// doesn't get bored!
	if (loadImgStr != "null") {
		clrScr = dynamic_cast <cScene*> (cRegistry::createNode ("caosGL::effects::cReseter", "loading.clr", cNULL));
		loadImg = dynamic_cast <cScene*> (cRegistry::createNode ("caosGL::effects::cImage", "loading.img", cNULL));
		loadMuz = dynamic_cast <cSndNode*> (cRegistry::createNode ("caosGL::core::cSndNode", "loading.snd", cNULL));

		clrScr->set ('colr', "true");clrScr->set ('dept', "true");clrScr->set ('proj', "true");clrScr->set ('modl', "true");
		loadImg->set ('tex', loadImgStr);
		loadMuz->prepare (sys->get ("loadMuz"));
		loadMuz->play ();

		clrScr->compile ();
		loadImg->compile ();

		for (tFloat i = 0; i<1; i+=0.005) {
			loadImg->set ('alph', i);
			clrScr->visit  (0); clrScr->draw  (0); clrScr->leave  ();
			loadImg->visit (0); loadImg->draw (0); loadImg->leave ();
			window->update ();
		}
	}

	// get an instance, and tell it to read the script, set up, etc..
	cEngine * engine = cEngine::instance ();
	engine->setUp ();

	if (loadImgStr != "null") {
		for (tFloat j = 1; j>0; j-=0.005) {
			loadImg->set ('alph', j);
			clrScr->visit  (0); clrScr->draw  (0); clrScr->leave  ();
			loadImg->visit (0); loadImg->draw (0); loadImg->leave ();
			window->update ();
		}
		loadMuz->stop ();
	}

	// if in pedantic, allow a delay for the demo to actually start.
	if (pedantic)
		Sleep (1500);

	cSceneGraph::getRootNode ()->printTree();

	// TODO: fix this so as to work with the node type, not
	//       just the name...
	// this is a bit of a kuldge, but it works, and only if the 
	// music node is called "muzik"
	muzik = dynamic_cast <cSndNode*> (cRegistry::getNode ("muzik"));
	if (muzik)
		muzik->pos (cParser::parseDouble(sys->get ("start")));
	engine->start (cParser::parseDouble(sys->get ("start")));

	// event loop stuff...
	MSG		msg;
	bool doIt = true;
	while (doIt) {
		if (PeekMessage (&msg, NULL, 0, 0, PM_REMOVE)) {
			if(msg.message == WM_QUIT)
				doIt = false;
			TranslateMessage (&msg);
			DispatchMessage (&msg);
		}  else {
			// will return false if there is nothing else to play.
			doIt = engine->update ();
			window->update ();
		}
	}

	window->close ();
	return
	msg.wParam;
}

// eof
