(*- Quick ADF Viewer v1.0 --------------------------------------------------
    PASCAL Example of reading the Artworx Data Format (ADF!).
    Copyright (c) 1997 by Primus [ primus@stormfront.com.au ]
    Internet Home Page : [ http://stormfront.com.au/~primus ]
--------------------------------------------------------------------------*)
  Program QuickADF;
  Uses CRT;
(* ---------------------------------------------------------------------- *)
   Var
      Version   : Char;
      Palette   : Array[0..63,1..3] of Byte;
      Old_Pal   : Array[0..63,1..3] of Byte;
      VGA_Font  : Array[1..4096] of Char;
      VBuffer   : Array[1..4000] of Char;
      Key       : Char;
      Exit_Stat : Boolean;
      Pointer   : LongInt;
      Lines     : Integer;
      I         : Integer;
      F         : File;
      Count     : Byte;
(* ---------------------------------------------------------------------- *)
   Procedure GetPal(Color,R,G,B: Byte);
             Begin
                  Port[$3c7] := Color;
                  R := Port[$3c9];
                  G := Port[$3c9];
                  B := Port[$3c9];
             End;
(* ---------------------------------------------------------------------- *)
   Procedure SetPal(Color,R,G,B: Byte);
             Begin
                  Port[$3c8] := Color;
                  Port[$3c9] := R;
                  Port[$3c9] := G;
                  Port[$3c9] := B;
             End;
(* ---------------------------------------------------------------------- *)
   Procedure Intensity(Status: Boolean); assembler;
             ASM
                MOV AX,1003h
                CMP Status,1
                JE @ION
                MOV BL,01h
                JMP @EN
                @ION:
                XOR BX,BX
                @EN:
                INT 10h
             End;
(* ---------------------------------------------------------------------- *)
   Procedure EvenFont; assembler;
             ASM
                MOV DX,03C4h
                MOV AX,0100h
                OUT DX,AX
                MOV DX,03C4h
                MOV AX,0301h
                OUT DX,AX
                MOV DX,03C2h
                MOV AX,0063h
                OUT DX,AL
                MOV DX,03C4h
                MOV AX,0300h
                OUT DX,AX
                MOV DX,03D4h
                MOV AX,4F09h
                OUT DX,AX
             End;
(* ---------------------------------------------------------------------- *)
   Procedure VgaFont;
             Var S, O: Word;

             Begin;
                   S:=Seg(VGA_Font);
                   O:=Ofs(VGA_Font);
             ASM
                PUSH ES
                PUSH BP
                MOV AX,1110h
                MOV BX,1000h
                MOV CX,100h
                XOR DX,DX
                MOV ES,S
                MOV BP,O
                INT 10h
                POP BP
                POP ES
             End;
             End;
(* ---------------------------------------------------------------------- *)
   Procedure Cursor(Status: Boolean); assembler;
             ASM
                MOV AX,0100h
                CMP Status,1
                JE @CON
                MOV CX,2000h
                JMP @EN
                @CON:
                MOV CX,0708h
                @EN:
                INT 10h
             End;
(* ---------------------------------------------------------------------- *)
   Begin
        If Paramcount <> 1 then
           Begin
                Writeln;
                Writeln('Quick ADF Viewer v1.0 % (c) 1997 by Primus');
                Writeln('Usage: ADFVIEW <name of .ADF file to view>');
                Halt;
           End;

        Assign(F, Paramstr(1));
        {$I-} Reset(F,1); {$I+}

        If IOResult <> 0 then
           Begin
                Writeln('Error encountered reading '+Paramstr(1)+'.'+#7);
                Halt;
           End;

        Lines:= (Filesize(F)-4289) div 160;
        Blockread(F,Version,1);

        For Count:=0 to 63 do Blockread(F,palette[count],3);
        Blockread(F,Vga_Font,4096);

        Writeln;
        Writeln('Quick ADF Viewer v1.0 % (c) 1997 by Primus');
        Writeln('==========================================');
        Writeln('   Filename : ',Paramstr(1));
        Writeln('     Length : ',Lines,' Lines');
        Writeln('ADF Version : ',Ord(Version));
        Writeln('==========================================');
        Writeln('   Press any key to continue...');
        Repeat Until Keypressed;

        For Count:=0 to 63 do
        GetPal(Count,Old_Pal[Count,1],Old_Pal[Count,2],Old_Pal[Count,3]);

        For count:=0 to 63 do
        SetPal(Count,Palette[Count,1],Palette[Count,2],Palette[Count,3]);

        Intensity(True);  EvenFont;  VGAFont;  Cursor(False);

        Reset(F,1);

        While Exit_Stat=False do
              Begin
                   Seek(F,(Pointer*160)+4289);
                   Blockread(F,VBuffer,4000);
                   Move(VBuffer,Mem[$B800:0000],4000);
                   Key:=Readkey;
                   If Key=#0 then Key:=Readkey;
                   Case Key of
                        #72: Dec(Pointer);
                        #80: Inc(Pointer);
                        #73: If (Pointer > 1) then
                             For I:=1 to 25 do
                                 Begin
                                      Dec(Pointer);
                                      Seek(F,(Pointer*160)+4289);
                                      BlockRead(F,VBuffer,4000);
                                      Move(VBuffer,Mem[$B800:0000],4000);
                                      Delay(I div 2);
                                      If Pointer < 1 then
                                         Begin
                                              Pointer:=0;
                                              I:=25;
                                         End;
                                 End;
                        #81: If (Pointer < Lines-26) then
                             For I:=1 to 25 do
                                 Begin
                                      Inc(Pointer);
                                      Seek(F,(Pointer*160)+4289);
                                      BlockRead(F,VBuffer,4000);
                                      Move(VBuffer,Mem[$B800:0000],4000);
                                      Delay(I div 2);
                                      If Pointer > (Lines-26) then
                                         Begin
                                              Pointer:=Lines-25;
                                              I:=25;
                                         End;
                                 End;
                        #71: Pointer:=0;
                        #79: Pointer:=Lines;
                        #27: Exit_Stat:=True;
                   End;
                   If Pointer > (Lines-25) then Pointer:=Lines-25;
                   If Pointer < 0 then Pointer:=0;
              End;

        Close(F);
        For count:=0 to 63 do
        SetPal(Count,Old_Pal[Count,1],Old_Pal[Count,2],Old_Pal[Count,3]);

        Fillchar(mem[$B800:0000],4000,#00);
        Textmode(C80);  Cursor(True);  Intensity(False);
End.